// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.network.fluent.IpamPoolsClient;
import com.azure.resourcemanager.network.fluent.models.IpamPoolInner;
import com.azure.resourcemanager.network.fluent.models.PoolAssociationInner;
import com.azure.resourcemanager.network.fluent.models.PoolUsageInner;
import com.azure.resourcemanager.network.models.IpamPoolList;
import com.azure.resourcemanager.network.models.IpamPoolUpdate;
import com.azure.resourcemanager.network.models.PoolAssociationList;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in IpamPoolsClient.
 */
public final class IpamPoolsClientImpl implements IpamPoolsClient {
    /**
     * The proxy service used to perform REST calls.
     */
    private final IpamPoolsService service;

    /**
     * The service client containing this operation class.
     */
    private final NetworkManagementClientImpl client;

    /**
     * Initializes an instance of IpamPoolsClientImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    IpamPoolsClientImpl(NetworkManagementClientImpl client) {
        this.service
            = RestProxy.create(IpamPoolsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for NetworkManagementClientIpamPools to be used by the proxy service to
     * perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "NetworkManagementClientIpamPools")
    public interface IpamPoolsService {
        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkManagers/{networkManagerName}/ipamPools")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<IpamPoolList>> list(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("networkManagerName") String networkManagerName, @QueryParam("skipToken") String skipToken,
            @QueryParam("skip") Integer skip, @QueryParam("top") Integer top, @QueryParam("sortKey") String sortKey,
            @QueryParam("sortValue") String sortValue, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkManagers/{networkManagerName}/ipamPools/{poolName}")
        @ExpectedResponses({ 200, 201 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> create(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("networkManagerName") String networkManagerName, @PathParam("poolName") String poolName,
            @QueryParam("api-version") String apiVersion, @HeaderParam("If-Match") String ifMatch,
            @BodyParam("application/json") IpamPoolInner body, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Patch("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkManagers/{networkManagerName}/ipamPools/{poolName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<IpamPoolInner>> update(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("networkManagerName") String networkManagerName, @PathParam("poolName") String poolName,
            @QueryParam("api-version") String apiVersion, @HeaderParam("If-Match") String ifMatch,
            @BodyParam("application/json") IpamPoolUpdate body, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkManagers/{networkManagerName}/ipamPools/{poolName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<IpamPoolInner>> get(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("networkManagerName") String networkManagerName, @PathParam("poolName") String poolName,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkManagers/{networkManagerName}/ipamPools/{poolName}")
        @ExpectedResponses({ 202, 204 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> delete(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("networkManagerName") String networkManagerName, @PathParam("poolName") String poolName,
            @QueryParam("api-version") String apiVersion, @HeaderParam("If-Match") String ifMatch,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkManagers/{networkManagerName}/ipamPools/{poolName}/getPoolUsage")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<PoolUsageInner>> getPoolUsage(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("networkManagerName") String networkManagerName, @PathParam("poolName") String poolName,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkManagers/{networkManagerName}/ipamPools/{poolName}/listAssociatedResources")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<PoolAssociationList>> listAssociatedResources(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("networkManagerName") String networkManagerName, @PathParam("poolName") String poolName,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<IpamPoolList>> listNext(@PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("$host") String endpoint, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<PoolAssociationList>> listAssociatedResourcesNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * Gets list of Pool resources at Network Manager level.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param skipToken Optional skip token.
     * @param skip Optional num entries to skip.
     * @param top Optional num entries to show.
     * @param sortKey Optional key by which to sort.
     * @param sortValue Optional sort value for pagination.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of Pool resources at Network Manager level along with {@link PagedResponse} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<IpamPoolInner>> listSinglePageAsync(String resourceGroupName, String networkManagerName,
        String skipToken, Integer skip, Integer top, String sortKey, String sortValue) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkManagerName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter networkManagerName is required and cannot be null."));
        }
        final String apiVersion = "2024-10-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
                    networkManagerName, skipToken, skip, top, sortKey, sortValue, apiVersion, accept, context))
            .<PagedResponse<IpamPoolInner>>map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(),
                res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets list of Pool resources at Network Manager level.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param skipToken Optional skip token.
     * @param skip Optional num entries to skip.
     * @param top Optional num entries to show.
     * @param sortKey Optional key by which to sort.
     * @param sortValue Optional sort value for pagination.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of Pool resources at Network Manager level along with {@link PagedResponse} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<IpamPoolInner>> listSinglePageAsync(String resourceGroupName, String networkManagerName,
        String skipToken, Integer skip, Integer top, String sortKey, String sortValue, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkManagerName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter networkManagerName is required and cannot be null."));
        }
        final String apiVersion = "2024-10-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .list(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, networkManagerName,
                skipToken, skip, top, sortKey, sortValue, apiVersion, accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Gets list of Pool resources at Network Manager level.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param skipToken Optional skip token.
     * @param skip Optional num entries to skip.
     * @param top Optional num entries to show.
     * @param sortKey Optional key by which to sort.
     * @param sortValue Optional sort value for pagination.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of Pool resources at Network Manager level as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<IpamPoolInner> listAsync(String resourceGroupName, String networkManagerName, String skipToken,
        Integer skip, Integer top, String sortKey, String sortValue) {
        return new PagedFlux<>(
            () -> listSinglePageAsync(resourceGroupName, networkManagerName, skipToken, skip, top, sortKey, sortValue),
            nextLink -> listNextSinglePageAsync(nextLink));
    }

    /**
     * Gets list of Pool resources at Network Manager level.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of Pool resources at Network Manager level as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<IpamPoolInner> listAsync(String resourceGroupName, String networkManagerName) {
        final String skipToken = null;
        final Integer skip = null;
        final Integer top = null;
        final String sortKey = null;
        final String sortValue = null;
        return new PagedFlux<>(
            () -> listSinglePageAsync(resourceGroupName, networkManagerName, skipToken, skip, top, sortKey, sortValue),
            nextLink -> listNextSinglePageAsync(nextLink));
    }

    /**
     * Gets list of Pool resources at Network Manager level.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param skipToken Optional skip token.
     * @param skip Optional num entries to skip.
     * @param top Optional num entries to show.
     * @param sortKey Optional key by which to sort.
     * @param sortValue Optional sort value for pagination.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of Pool resources at Network Manager level as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<IpamPoolInner> listAsync(String resourceGroupName, String networkManagerName, String skipToken,
        Integer skip, Integer top, String sortKey, String sortValue, Context context) {
        return new PagedFlux<>(() -> listSinglePageAsync(resourceGroupName, networkManagerName, skipToken, skip, top,
            sortKey, sortValue, context), nextLink -> listNextSinglePageAsync(nextLink, context));
    }

    /**
     * Gets list of Pool resources at Network Manager level.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of Pool resources at Network Manager level as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<IpamPoolInner> list(String resourceGroupName, String networkManagerName) {
        final String skipToken = null;
        final Integer skip = null;
        final Integer top = null;
        final String sortKey = null;
        final String sortValue = null;
        return new PagedIterable<>(
            listAsync(resourceGroupName, networkManagerName, skipToken, skip, top, sortKey, sortValue));
    }

    /**
     * Gets list of Pool resources at Network Manager level.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param skipToken Optional skip token.
     * @param skip Optional num entries to skip.
     * @param top Optional num entries to show.
     * @param sortKey Optional key by which to sort.
     * @param sortValue Optional sort value for pagination.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of Pool resources at Network Manager level as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<IpamPoolInner> list(String resourceGroupName, String networkManagerName, String skipToken,
        Integer skip, Integer top, String sortKey, String sortValue, Context context) {
        return new PagedIterable<>(
            listAsync(resourceGroupName, networkManagerName, skipToken, skip, top, sortKey, sortValue, context));
    }

    /**
     * Creates/Updates the Pool resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param poolName IP Address Manager Pool resource name.
     * @param body Pool resource object to create/update.
     * @param ifMatch The entity state (ETag) version of the pool to update. This value can be omitted or set to "*" to
     * apply the operation unconditionally.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return instance of Pool resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String resourceGroupName, String networkManagerName,
        String poolName, IpamPoolInner body, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkManagerName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter networkManagerName is required and cannot be null."));
        }
        if (poolName == null) {
            return Mono.error(new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String apiVersion = "2024-10-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.create(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, networkManagerName, poolName, apiVersion, ifMatch, body, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Creates/Updates the Pool resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param poolName IP Address Manager Pool resource name.
     * @param body Pool resource object to create/update.
     * @param ifMatch The entity state (ETag) version of the pool to update. This value can be omitted or set to "*" to
     * apply the operation unconditionally.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return instance of Pool resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String resourceGroupName,
        String networkManagerName, String poolName, IpamPoolInner body, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkManagerName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter networkManagerName is required and cannot be null."));
        }
        if (poolName == null) {
            return Mono.error(new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String apiVersion = "2024-10-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.create(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
            networkManagerName, poolName, apiVersion, ifMatch, body, accept, context);
    }

    /**
     * Creates/Updates the Pool resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param poolName IP Address Manager Pool resource name.
     * @param body Pool resource object to create/update.
     * @param ifMatch The entity state (ETag) version of the pool to update. This value can be omitted or set to "*" to
     * apply the operation unconditionally.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of instance of Pool resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<IpamPoolInner>, IpamPoolInner> beginCreateAsync(String resourceGroupName,
        String networkManagerName, String poolName, IpamPoolInner body, String ifMatch) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = createWithResponseAsync(resourceGroupName, networkManagerName, poolName, body, ifMatch);
        return this.client.<IpamPoolInner, IpamPoolInner>getLroResult(mono, this.client.getHttpPipeline(),
            IpamPoolInner.class, IpamPoolInner.class, this.client.getContext());
    }

    /**
     * Creates/Updates the Pool resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param poolName IP Address Manager Pool resource name.
     * @param body Pool resource object to create/update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of instance of Pool resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<IpamPoolInner>, IpamPoolInner> beginCreateAsync(String resourceGroupName,
        String networkManagerName, String poolName, IpamPoolInner body) {
        final String ifMatch = null;
        Mono<Response<Flux<ByteBuffer>>> mono
            = createWithResponseAsync(resourceGroupName, networkManagerName, poolName, body, ifMatch);
        return this.client.<IpamPoolInner, IpamPoolInner>getLroResult(mono, this.client.getHttpPipeline(),
            IpamPoolInner.class, IpamPoolInner.class, this.client.getContext());
    }

    /**
     * Creates/Updates the Pool resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param poolName IP Address Manager Pool resource name.
     * @param body Pool resource object to create/update.
     * @param ifMatch The entity state (ETag) version of the pool to update. This value can be omitted or set to "*" to
     * apply the operation unconditionally.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of instance of Pool resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<IpamPoolInner>, IpamPoolInner> beginCreateAsync(String resourceGroupName,
        String networkManagerName, String poolName, IpamPoolInner body, String ifMatch, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = createWithResponseAsync(resourceGroupName, networkManagerName, poolName, body, ifMatch, context);
        return this.client.<IpamPoolInner, IpamPoolInner>getLroResult(mono, this.client.getHttpPipeline(),
            IpamPoolInner.class, IpamPoolInner.class, context);
    }

    /**
     * Creates/Updates the Pool resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param poolName IP Address Manager Pool resource name.
     * @param body Pool resource object to create/update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of instance of Pool resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<IpamPoolInner>, IpamPoolInner> beginCreate(String resourceGroupName,
        String networkManagerName, String poolName, IpamPoolInner body) {
        final String ifMatch = null;
        return this.beginCreateAsync(resourceGroupName, networkManagerName, poolName, body, ifMatch).getSyncPoller();
    }

    /**
     * Creates/Updates the Pool resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param poolName IP Address Manager Pool resource name.
     * @param body Pool resource object to create/update.
     * @param ifMatch The entity state (ETag) version of the pool to update. This value can be omitted or set to "*" to
     * apply the operation unconditionally.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of instance of Pool resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<IpamPoolInner>, IpamPoolInner> beginCreate(String resourceGroupName,
        String networkManagerName, String poolName, IpamPoolInner body, String ifMatch, Context context) {
        return this.beginCreateAsync(resourceGroupName, networkManagerName, poolName, body, ifMatch, context)
            .getSyncPoller();
    }

    /**
     * Creates/Updates the Pool resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param poolName IP Address Manager Pool resource name.
     * @param body Pool resource object to create/update.
     * @param ifMatch The entity state (ETag) version of the pool to update. This value can be omitted or set to "*" to
     * apply the operation unconditionally.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return instance of Pool resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<IpamPoolInner> createAsync(String resourceGroupName, String networkManagerName, String poolName,
        IpamPoolInner body, String ifMatch) {
        return beginCreateAsync(resourceGroupName, networkManagerName, poolName, body, ifMatch).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Creates/Updates the Pool resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param poolName IP Address Manager Pool resource name.
     * @param body Pool resource object to create/update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return instance of Pool resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<IpamPoolInner> createAsync(String resourceGroupName, String networkManagerName, String poolName,
        IpamPoolInner body) {
        final String ifMatch = null;
        return beginCreateAsync(resourceGroupName, networkManagerName, poolName, body, ifMatch).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Creates/Updates the Pool resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param poolName IP Address Manager Pool resource name.
     * @param body Pool resource object to create/update.
     * @param ifMatch The entity state (ETag) version of the pool to update. This value can be omitted or set to "*" to
     * apply the operation unconditionally.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return instance of Pool resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<IpamPoolInner> createAsync(String resourceGroupName, String networkManagerName, String poolName,
        IpamPoolInner body, String ifMatch, Context context) {
        return beginCreateAsync(resourceGroupName, networkManagerName, poolName, body, ifMatch, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Creates/Updates the Pool resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param poolName IP Address Manager Pool resource name.
     * @param body Pool resource object to create/update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return instance of Pool resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public IpamPoolInner create(String resourceGroupName, String networkManagerName, String poolName,
        IpamPoolInner body) {
        final String ifMatch = null;
        return createAsync(resourceGroupName, networkManagerName, poolName, body, ifMatch).block();
    }

    /**
     * Creates/Updates the Pool resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param poolName IP Address Manager Pool resource name.
     * @param body Pool resource object to create/update.
     * @param ifMatch The entity state (ETag) version of the pool to update. This value can be omitted or set to "*" to
     * apply the operation unconditionally.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return instance of Pool resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public IpamPoolInner create(String resourceGroupName, String networkManagerName, String poolName,
        IpamPoolInner body, String ifMatch, Context context) {
        return createAsync(resourceGroupName, networkManagerName, poolName, body, ifMatch, context).block();
    }

    /**
     * Updates the specific Pool resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param poolName IP Address Manager Pool resource name.
     * @param ifMatch The entity state (ETag) version of the pool to update. This value can be omitted or set to "*" to
     * apply the operation unconditionally.
     * @param body Pool resource object to update partially.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return instance of Pool resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<IpamPoolInner>> updateWithResponseAsync(String resourceGroupName, String networkManagerName,
        String poolName, String ifMatch, IpamPoolUpdate body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkManagerName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter networkManagerName is required and cannot be null."));
        }
        if (poolName == null) {
            return Mono.error(new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        if (body != null) {
            body.validate();
        }
        final String apiVersion = "2024-10-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.update(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, networkManagerName, poolName, apiVersion, ifMatch, body, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Updates the specific Pool resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param poolName IP Address Manager Pool resource name.
     * @param ifMatch The entity state (ETag) version of the pool to update. This value can be omitted or set to "*" to
     * apply the operation unconditionally.
     * @param body Pool resource object to update partially.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return instance of Pool resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<IpamPoolInner>> updateWithResponseAsync(String resourceGroupName, String networkManagerName,
        String poolName, String ifMatch, IpamPoolUpdate body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkManagerName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter networkManagerName is required and cannot be null."));
        }
        if (poolName == null) {
            return Mono.error(new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        if (body != null) {
            body.validate();
        }
        final String apiVersion = "2024-10-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.update(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
            networkManagerName, poolName, apiVersion, ifMatch, body, accept, context);
    }

    /**
     * Updates the specific Pool resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param poolName IP Address Manager Pool resource name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return instance of Pool resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<IpamPoolInner> updateAsync(String resourceGroupName, String networkManagerName, String poolName) {
        final String ifMatch = null;
        final IpamPoolUpdate body = null;
        return updateWithResponseAsync(resourceGroupName, networkManagerName, poolName, ifMatch, body)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Updates the specific Pool resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param poolName IP Address Manager Pool resource name.
     * @param ifMatch The entity state (ETag) version of the pool to update. This value can be omitted or set to "*" to
     * apply the operation unconditionally.
     * @param body Pool resource object to update partially.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return instance of Pool resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<IpamPoolInner> updateWithResponse(String resourceGroupName, String networkManagerName,
        String poolName, String ifMatch, IpamPoolUpdate body, Context context) {
        return updateWithResponseAsync(resourceGroupName, networkManagerName, poolName, ifMatch, body, context).block();
    }

    /**
     * Updates the specific Pool resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param poolName IP Address Manager Pool resource name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return instance of Pool resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public IpamPoolInner update(String resourceGroupName, String networkManagerName, String poolName) {
        final String ifMatch = null;
        final IpamPoolUpdate body = null;
        return updateWithResponse(resourceGroupName, networkManagerName, poolName, ifMatch, body, Context.NONE)
            .getValue();
    }

    /**
     * Gets the specific Pool resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param poolName Pool resource name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specific Pool resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<IpamPoolInner>> getWithResponseAsync(String resourceGroupName, String networkManagerName,
        String poolName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkManagerName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter networkManagerName is required and cannot be null."));
        }
        if (poolName == null) {
            return Mono.error(new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        final String apiVersion = "2024-10-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.get(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, networkManagerName, poolName, apiVersion, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets the specific Pool resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param poolName Pool resource name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specific Pool resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<IpamPoolInner>> getWithResponseAsync(String resourceGroupName, String networkManagerName,
        String poolName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkManagerName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter networkManagerName is required and cannot be null."));
        }
        if (poolName == null) {
            return Mono.error(new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        final String apiVersion = "2024-10-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
            networkManagerName, poolName, apiVersion, accept, context);
    }

    /**
     * Gets the specific Pool resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param poolName Pool resource name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specific Pool resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<IpamPoolInner> getAsync(String resourceGroupName, String networkManagerName, String poolName) {
        return getWithResponseAsync(resourceGroupName, networkManagerName, poolName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets the specific Pool resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param poolName Pool resource name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specific Pool resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<IpamPoolInner> getWithResponse(String resourceGroupName, String networkManagerName, String poolName,
        Context context) {
        return getWithResponseAsync(resourceGroupName, networkManagerName, poolName, context).block();
    }

    /**
     * Gets the specific Pool resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param poolName Pool resource name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specific Pool resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public IpamPoolInner get(String resourceGroupName, String networkManagerName, String poolName) {
        return getWithResponse(resourceGroupName, networkManagerName, poolName, Context.NONE).getValue();
    }

    /**
     * Delete the Pool resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param poolName Pool resource name.
     * @param ifMatch The entity state (ETag) version of the pool to update. This value can be omitted or set to "*" to
     * apply the operation unconditionally.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String networkManagerName,
        String poolName, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkManagerName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter networkManagerName is required and cannot be null."));
        }
        if (poolName == null) {
            return Mono.error(new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        final String apiVersion = "2024-10-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, networkManagerName, poolName, apiVersion, ifMatch, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Delete the Pool resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param poolName Pool resource name.
     * @param ifMatch The entity state (ETag) version of the pool to update. This value can be omitted or set to "*" to
     * apply the operation unconditionally.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName,
        String networkManagerName, String poolName, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkManagerName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter networkManagerName is required and cannot be null."));
        }
        if (poolName == null) {
            return Mono.error(new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        final String apiVersion = "2024-10-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
            networkManagerName, poolName, apiVersion, ifMatch, accept, context);
    }

    /**
     * Delete the Pool resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param poolName Pool resource name.
     * @param ifMatch The entity state (ETag) version of the pool to update. This value can be omitted or set to "*" to
     * apply the operation unconditionally.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String networkManagerName,
        String poolName, String ifMatch) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = deleteWithResponseAsync(resourceGroupName, networkManagerName, poolName, ifMatch);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            this.client.getContext());
    }

    /**
     * Delete the Pool resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param poolName Pool resource name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String networkManagerName,
        String poolName) {
        final String ifMatch = null;
        Mono<Response<Flux<ByteBuffer>>> mono
            = deleteWithResponseAsync(resourceGroupName, networkManagerName, poolName, ifMatch);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            this.client.getContext());
    }

    /**
     * Delete the Pool resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param poolName Pool resource name.
     * @param ifMatch The entity state (ETag) version of the pool to update. This value can be omitted or set to "*" to
     * apply the operation unconditionally.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String networkManagerName,
        String poolName, String ifMatch, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = deleteWithResponseAsync(resourceGroupName, networkManagerName, poolName, ifMatch, context);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            context);
    }

    /**
     * Delete the Pool resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param poolName Pool resource name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String networkManagerName,
        String poolName) {
        final String ifMatch = null;
        return this.beginDeleteAsync(resourceGroupName, networkManagerName, poolName, ifMatch).getSyncPoller();
    }

    /**
     * Delete the Pool resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param poolName Pool resource name.
     * @param ifMatch The entity state (ETag) version of the pool to update. This value can be omitted or set to "*" to
     * apply the operation unconditionally.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String networkManagerName,
        String poolName, String ifMatch, Context context) {
        return this.beginDeleteAsync(resourceGroupName, networkManagerName, poolName, ifMatch, context).getSyncPoller();
    }

    /**
     * Delete the Pool resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param poolName Pool resource name.
     * @param ifMatch The entity state (ETag) version of the pool to update. This value can be omitted or set to "*" to
     * apply the operation unconditionally.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String networkManagerName, String poolName,
        String ifMatch) {
        return beginDeleteAsync(resourceGroupName, networkManagerName, poolName, ifMatch).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Delete the Pool resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param poolName Pool resource name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String networkManagerName, String poolName) {
        final String ifMatch = null;
        return beginDeleteAsync(resourceGroupName, networkManagerName, poolName, ifMatch).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Delete the Pool resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param poolName Pool resource name.
     * @param ifMatch The entity state (ETag) version of the pool to update. This value can be omitted or set to "*" to
     * apply the operation unconditionally.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String networkManagerName, String poolName, String ifMatch,
        Context context) {
        return beginDeleteAsync(resourceGroupName, networkManagerName, poolName, ifMatch, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Delete the Pool resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param poolName Pool resource name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String networkManagerName, String poolName) {
        final String ifMatch = null;
        deleteAsync(resourceGroupName, networkManagerName, poolName, ifMatch).block();
    }

    /**
     * Delete the Pool resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param poolName Pool resource name.
     * @param ifMatch The entity state (ETag) version of the pool to update. This value can be omitted or set to "*" to
     * apply the operation unconditionally.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String networkManagerName, String poolName, String ifMatch,
        Context context) {
        deleteAsync(resourceGroupName, networkManagerName, poolName, ifMatch, context).block();
    }

    /**
     * Get the Pool Usage.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param poolName Pool resource name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Pool Usage along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<PoolUsageInner>> getPoolUsageWithResponseAsync(String resourceGroupName,
        String networkManagerName, String poolName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkManagerName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter networkManagerName is required and cannot be null."));
        }
        if (poolName == null) {
            return Mono.error(new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        final String apiVersion = "2024-10-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getPoolUsage(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, networkManagerName, poolName, apiVersion, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the Pool Usage.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param poolName Pool resource name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Pool Usage along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<PoolUsageInner>> getPoolUsageWithResponseAsync(String resourceGroupName,
        String networkManagerName, String poolName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkManagerName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter networkManagerName is required and cannot be null."));
        }
        if (poolName == null) {
            return Mono.error(new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        final String apiVersion = "2024-10-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getPoolUsage(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
            networkManagerName, poolName, apiVersion, accept, context);
    }

    /**
     * Get the Pool Usage.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param poolName Pool resource name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Pool Usage on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PoolUsageInner> getPoolUsageAsync(String resourceGroupName, String networkManagerName,
        String poolName) {
        return getPoolUsageWithResponseAsync(resourceGroupName, networkManagerName, poolName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Get the Pool Usage.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param poolName Pool resource name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Pool Usage along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<PoolUsageInner> getPoolUsageWithResponse(String resourceGroupName, String networkManagerName,
        String poolName, Context context) {
        return getPoolUsageWithResponseAsync(resourceGroupName, networkManagerName, poolName, context).block();
    }

    /**
     * Get the Pool Usage.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param poolName Pool resource name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Pool Usage.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PoolUsageInner getPoolUsage(String resourceGroupName, String networkManagerName, String poolName) {
        return getPoolUsageWithResponse(resourceGroupName, networkManagerName, poolName, Context.NONE).getValue();
    }

    /**
     * List Associated Resource in the Pool.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param poolName Pool resource name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of PoolAssociation along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PoolAssociationInner>> listAssociatedResourcesSinglePageAsync(String resourceGroupName,
        String networkManagerName, String poolName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkManagerName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter networkManagerName is required and cannot be null."));
        }
        if (poolName == null) {
            return Mono.error(new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        final String apiVersion = "2024-10-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.listAssociatedResources(this.client.getEndpoint(), this.client.getSubscriptionId(),
                    resourceGroupName, networkManagerName, poolName, apiVersion, accept, context))
            .<PagedResponse<PoolAssociationInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * List Associated Resource in the Pool.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param poolName Pool resource name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of PoolAssociation along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PoolAssociationInner>> listAssociatedResourcesSinglePageAsync(String resourceGroupName,
        String networkManagerName, String poolName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkManagerName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter networkManagerName is required and cannot be null."));
        }
        if (poolName == null) {
            return Mono.error(new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        final String apiVersion = "2024-10-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listAssociatedResources(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
                networkManagerName, poolName, apiVersion, accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * List Associated Resource in the Pool.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param poolName Pool resource name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of PoolAssociation as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<PoolAssociationInner> listAssociatedResourcesAsync(String resourceGroupName,
        String networkManagerName, String poolName) {
        return new PagedFlux<>(
            () -> listAssociatedResourcesSinglePageAsync(resourceGroupName, networkManagerName, poolName),
            nextLink -> listAssociatedResourcesNextSinglePageAsync(nextLink));
    }

    /**
     * List Associated Resource in the Pool.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param poolName Pool resource name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of PoolAssociation as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<PoolAssociationInner> listAssociatedResourcesAsync(String resourceGroupName,
        String networkManagerName, String poolName, Context context) {
        return new PagedFlux<>(
            () -> listAssociatedResourcesSinglePageAsync(resourceGroupName, networkManagerName, poolName, context),
            nextLink -> listAssociatedResourcesNextSinglePageAsync(nextLink, context));
    }

    /**
     * List Associated Resource in the Pool.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param poolName Pool resource name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of PoolAssociation as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<PoolAssociationInner> listAssociatedResources(String resourceGroupName,
        String networkManagerName, String poolName) {
        return new PagedIterable<>(listAssociatedResourcesAsync(resourceGroupName, networkManagerName, poolName));
    }

    /**
     * List Associated Resource in the Pool.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param poolName Pool resource name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of PoolAssociation as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<PoolAssociationInner> listAssociatedResources(String resourceGroupName,
        String networkManagerName, String poolName, Context context) {
        return new PagedIterable<>(
            listAssociatedResourcesAsync(resourceGroupName, networkManagerName, poolName, context));
    }

    /**
     * Gets list of Pool resources at Network Manager level.
     * 
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of Pool resources at Network Manager level along with {@link PagedResponse} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<IpamPoolInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.listNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<IpamPoolInner>>map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(),
                res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets list of Pool resources at Network Manager level.
     * 
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of Pool resources at Network Manager level along with {@link PagedResponse} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<IpamPoolInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * List Associated Resource in the Pool.
     * 
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of PoolAssociation along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PoolAssociationInner>> listAssociatedResourcesNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.listAssociatedResourcesNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<PoolAssociationInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * List Associated Resource in the Pool.
     * 
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of PoolAssociation along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PoolAssociationInner>> listAssociatedResourcesNextSinglePageAsync(String nextLink,
        Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listAssociatedResourcesNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }
}
