// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Rule of type application.
 */
@Fluent
public final class ApplicationRule extends FirewallPolicyRule {
    /*
     * Rule Type.
     */
    private FirewallPolicyRuleType ruleType = FirewallPolicyRuleType.APPLICATION_RULE;

    /*
     * List of source IP addresses for this rule.
     */
    private List<String> sourceAddresses;

    /*
     * List of destination IP addresses or Service Tags.
     */
    private List<String> destinationAddresses;

    /*
     * Array of Application Protocols.
     */
    private List<FirewallPolicyRuleApplicationProtocol> protocols;

    /*
     * List of FQDNs for this rule.
     */
    private List<String> targetFqdns;

    /*
     * List of Urls for this rule condition.
     */
    private List<String> targetUrls;

    /*
     * List of FQDN Tags for this rule.
     */
    private List<String> fqdnTags;

    /*
     * List of source IpGroups for this rule.
     */
    private List<String> sourceIpGroups;

    /*
     * Terminate TLS connections for this rule.
     */
    private Boolean terminateTls;

    /*
     * List of destination azure web categories.
     */
    private List<String> webCategories;

    /*
     * List of HTTP/S headers to insert.
     */
    private List<FirewallPolicyHttpHeaderToInsert> httpHeadersToInsert;

    /**
     * Creates an instance of ApplicationRule class.
     */
    public ApplicationRule() {
    }

    /**
     * Get the ruleType property: Rule Type.
     * 
     * @return the ruleType value.
     */
    @Override
    public FirewallPolicyRuleType ruleType() {
        return this.ruleType;
    }

    /**
     * Get the sourceAddresses property: List of source IP addresses for this rule.
     * 
     * @return the sourceAddresses value.
     */
    public List<String> sourceAddresses() {
        return this.sourceAddresses;
    }

    /**
     * Set the sourceAddresses property: List of source IP addresses for this rule.
     * 
     * @param sourceAddresses the sourceAddresses value to set.
     * @return the ApplicationRule object itself.
     */
    public ApplicationRule withSourceAddresses(List<String> sourceAddresses) {
        this.sourceAddresses = sourceAddresses;
        return this;
    }

    /**
     * Get the destinationAddresses property: List of destination IP addresses or Service Tags.
     * 
     * @return the destinationAddresses value.
     */
    public List<String> destinationAddresses() {
        return this.destinationAddresses;
    }

    /**
     * Set the destinationAddresses property: List of destination IP addresses or Service Tags.
     * 
     * @param destinationAddresses the destinationAddresses value to set.
     * @return the ApplicationRule object itself.
     */
    public ApplicationRule withDestinationAddresses(List<String> destinationAddresses) {
        this.destinationAddresses = destinationAddresses;
        return this;
    }

    /**
     * Get the protocols property: Array of Application Protocols.
     * 
     * @return the protocols value.
     */
    public List<FirewallPolicyRuleApplicationProtocol> protocols() {
        return this.protocols;
    }

    /**
     * Set the protocols property: Array of Application Protocols.
     * 
     * @param protocols the protocols value to set.
     * @return the ApplicationRule object itself.
     */
    public ApplicationRule withProtocols(List<FirewallPolicyRuleApplicationProtocol> protocols) {
        this.protocols = protocols;
        return this;
    }

    /**
     * Get the targetFqdns property: List of FQDNs for this rule.
     * 
     * @return the targetFqdns value.
     */
    public List<String> targetFqdns() {
        return this.targetFqdns;
    }

    /**
     * Set the targetFqdns property: List of FQDNs for this rule.
     * 
     * @param targetFqdns the targetFqdns value to set.
     * @return the ApplicationRule object itself.
     */
    public ApplicationRule withTargetFqdns(List<String> targetFqdns) {
        this.targetFqdns = targetFqdns;
        return this;
    }

    /**
     * Get the targetUrls property: List of Urls for this rule condition.
     * 
     * @return the targetUrls value.
     */
    public List<String> targetUrls() {
        return this.targetUrls;
    }

    /**
     * Set the targetUrls property: List of Urls for this rule condition.
     * 
     * @param targetUrls the targetUrls value to set.
     * @return the ApplicationRule object itself.
     */
    public ApplicationRule withTargetUrls(List<String> targetUrls) {
        this.targetUrls = targetUrls;
        return this;
    }

    /**
     * Get the fqdnTags property: List of FQDN Tags for this rule.
     * 
     * @return the fqdnTags value.
     */
    public List<String> fqdnTags() {
        return this.fqdnTags;
    }

    /**
     * Set the fqdnTags property: List of FQDN Tags for this rule.
     * 
     * @param fqdnTags the fqdnTags value to set.
     * @return the ApplicationRule object itself.
     */
    public ApplicationRule withFqdnTags(List<String> fqdnTags) {
        this.fqdnTags = fqdnTags;
        return this;
    }

    /**
     * Get the sourceIpGroups property: List of source IpGroups for this rule.
     * 
     * @return the sourceIpGroups value.
     */
    public List<String> sourceIpGroups() {
        return this.sourceIpGroups;
    }

    /**
     * Set the sourceIpGroups property: List of source IpGroups for this rule.
     * 
     * @param sourceIpGroups the sourceIpGroups value to set.
     * @return the ApplicationRule object itself.
     */
    public ApplicationRule withSourceIpGroups(List<String> sourceIpGroups) {
        this.sourceIpGroups = sourceIpGroups;
        return this;
    }

    /**
     * Get the terminateTls property: Terminate TLS connections for this rule.
     * 
     * @return the terminateTls value.
     */
    public Boolean terminateTls() {
        return this.terminateTls;
    }

    /**
     * Set the terminateTls property: Terminate TLS connections for this rule.
     * 
     * @param terminateTls the terminateTls value to set.
     * @return the ApplicationRule object itself.
     */
    public ApplicationRule withTerminateTls(Boolean terminateTls) {
        this.terminateTls = terminateTls;
        return this;
    }

    /**
     * Get the webCategories property: List of destination azure web categories.
     * 
     * @return the webCategories value.
     */
    public List<String> webCategories() {
        return this.webCategories;
    }

    /**
     * Set the webCategories property: List of destination azure web categories.
     * 
     * @param webCategories the webCategories value to set.
     * @return the ApplicationRule object itself.
     */
    public ApplicationRule withWebCategories(List<String> webCategories) {
        this.webCategories = webCategories;
        return this;
    }

    /**
     * Get the httpHeadersToInsert property: List of HTTP/S headers to insert.
     * 
     * @return the httpHeadersToInsert value.
     */
    public List<FirewallPolicyHttpHeaderToInsert> httpHeadersToInsert() {
        return this.httpHeadersToInsert;
    }

    /**
     * Set the httpHeadersToInsert property: List of HTTP/S headers to insert.
     * 
     * @param httpHeadersToInsert the httpHeadersToInsert value to set.
     * @return the ApplicationRule object itself.
     */
    public ApplicationRule withHttpHeadersToInsert(List<FirewallPolicyHttpHeaderToInsert> httpHeadersToInsert) {
        this.httpHeadersToInsert = httpHeadersToInsert;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ApplicationRule withName(String name) {
        super.withName(name);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ApplicationRule withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (protocols() != null) {
            protocols().forEach(e -> e.validate());
        }
        if (httpHeadersToInsert() != null) {
            httpHeadersToInsert().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", name());
        jsonWriter.writeStringField("description", description());
        jsonWriter.writeStringField("ruleType", this.ruleType == null ? null : this.ruleType.toString());
        jsonWriter.writeArrayField("sourceAddresses", this.sourceAddresses,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("destinationAddresses", this.destinationAddresses,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("protocols", this.protocols, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("targetFqdns", this.targetFqdns, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("targetUrls", this.targetUrls, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("fqdnTags", this.fqdnTags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("sourceIpGroups", this.sourceIpGroups,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("terminateTLS", this.terminateTls);
        jsonWriter.writeArrayField("webCategories", this.webCategories,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("httpHeadersToInsert", this.httpHeadersToInsert,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApplicationRule from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApplicationRule if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ApplicationRule.
     */
    public static ApplicationRule fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApplicationRule deserializedApplicationRule = new ApplicationRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedApplicationRule.withName(reader.getString());
                } else if ("description".equals(fieldName)) {
                    deserializedApplicationRule.withDescription(reader.getString());
                } else if ("ruleType".equals(fieldName)) {
                    deserializedApplicationRule.ruleType = FirewallPolicyRuleType.fromString(reader.getString());
                } else if ("sourceAddresses".equals(fieldName)) {
                    List<String> sourceAddresses = reader.readArray(reader1 -> reader1.getString());
                    deserializedApplicationRule.sourceAddresses = sourceAddresses;
                } else if ("destinationAddresses".equals(fieldName)) {
                    List<String> destinationAddresses = reader.readArray(reader1 -> reader1.getString());
                    deserializedApplicationRule.destinationAddresses = destinationAddresses;
                } else if ("protocols".equals(fieldName)) {
                    List<FirewallPolicyRuleApplicationProtocol> protocols
                        = reader.readArray(reader1 -> FirewallPolicyRuleApplicationProtocol.fromJson(reader1));
                    deserializedApplicationRule.protocols = protocols;
                } else if ("targetFqdns".equals(fieldName)) {
                    List<String> targetFqdns = reader.readArray(reader1 -> reader1.getString());
                    deserializedApplicationRule.targetFqdns = targetFqdns;
                } else if ("targetUrls".equals(fieldName)) {
                    List<String> targetUrls = reader.readArray(reader1 -> reader1.getString());
                    deserializedApplicationRule.targetUrls = targetUrls;
                } else if ("fqdnTags".equals(fieldName)) {
                    List<String> fqdnTags = reader.readArray(reader1 -> reader1.getString());
                    deserializedApplicationRule.fqdnTags = fqdnTags;
                } else if ("sourceIpGroups".equals(fieldName)) {
                    List<String> sourceIpGroups = reader.readArray(reader1 -> reader1.getString());
                    deserializedApplicationRule.sourceIpGroups = sourceIpGroups;
                } else if ("terminateTLS".equals(fieldName)) {
                    deserializedApplicationRule.terminateTls = reader.getNullable(JsonReader::getBoolean);
                } else if ("webCategories".equals(fieldName)) {
                    List<String> webCategories = reader.readArray(reader1 -> reader1.getString());
                    deserializedApplicationRule.webCategories = webCategories;
                } else if ("httpHeadersToInsert".equals(fieldName)) {
                    List<FirewallPolicyHttpHeaderToInsert> httpHeadersToInsert
                        = reader.readArray(reader1 -> FirewallPolicyHttpHeaderToInsert.fromJson(reader1));
                    deserializedApplicationRule.httpHeadersToInsert = httpHeadersToInsert;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApplicationRule;
        });
    }
}
