// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Properties of the AzureFirewallRCAction.
 */
@Fluent
public final class AzureFirewallPacketCaptureFlags implements JsonSerializable<AzureFirewallPacketCaptureFlags> {
    /*
     * Flags to capture
     */
    private AzureFirewallPacketCaptureFlagsType type;

    /**
     * Creates an instance of AzureFirewallPacketCaptureFlags class.
     */
    public AzureFirewallPacketCaptureFlags() {
    }

    /**
     * Get the type property: Flags to capture.
     * 
     * @return the type value.
     */
    public AzureFirewallPacketCaptureFlagsType type() {
        return this.type;
    }

    /**
     * Set the type property: Flags to capture.
     * 
     * @param type the type value to set.
     * @return the AzureFirewallPacketCaptureFlags object itself.
     */
    public AzureFirewallPacketCaptureFlags withType(AzureFirewallPacketCaptureFlagsType type) {
        this.type = type;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AzureFirewallPacketCaptureFlags from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AzureFirewallPacketCaptureFlags if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AzureFirewallPacketCaptureFlags.
     */
    public static AzureFirewallPacketCaptureFlags fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AzureFirewallPacketCaptureFlags deserializedAzureFirewallPacketCaptureFlags
                = new AzureFirewallPacketCaptureFlags();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("type".equals(fieldName)) {
                    deserializedAzureFirewallPacketCaptureFlags.type
                        = AzureFirewallPacketCaptureFlagsType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAzureFirewallPacketCaptureFlags;
        });
    }
}
