// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Public IP Address associated with azure firewall.
 */
@Fluent
public final class AzureFirewallPublicIpAddress implements JsonSerializable<AzureFirewallPublicIpAddress> {
    /*
     * Public IP Address value.
     */
    private String address;

    /**
     * Creates an instance of AzureFirewallPublicIpAddress class.
     */
    public AzureFirewallPublicIpAddress() {
    }

    /**
     * Get the address property: Public IP Address value.
     * 
     * @return the address value.
     */
    public String address() {
        return this.address;
    }

    /**
     * Set the address property: Public IP Address value.
     * 
     * @param address the address value to set.
     * @return the AzureFirewallPublicIpAddress object itself.
     */
    public AzureFirewallPublicIpAddress withAddress(String address) {
        this.address = address;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("address", this.address);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AzureFirewallPublicIpAddress from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AzureFirewallPublicIpAddress if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AzureFirewallPublicIpAddress.
     */
    public static AzureFirewallPublicIpAddress fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AzureFirewallPublicIpAddress deserializedAzureFirewallPublicIpAddress = new AzureFirewallPublicIpAddress();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("address".equals(fieldName)) {
                    deserializedAzureFirewallPublicIpAddress.address = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAzureFirewallPublicIpAddress;
        });
    }
}
