// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The FailoverConnectionDetails model.
 */
@Fluent
public final class FailoverConnectionDetails implements JsonSerializable<FailoverConnectionDetails> {
    /*
     * Name of the failover connection
     */
    private String failoverConnectionName;

    /*
     * Location of the failover connection
     */
    private String failoverLocation;

    /*
     * Whether the customer was able to establish connectivity through this failover connection or not
     */
    private Boolean isVerified;

    /**
     * Creates an instance of FailoverConnectionDetails class.
     */
    public FailoverConnectionDetails() {
    }

    /**
     * Get the failoverConnectionName property: Name of the failover connection.
     * 
     * @return the failoverConnectionName value.
     */
    public String failoverConnectionName() {
        return this.failoverConnectionName;
    }

    /**
     * Set the failoverConnectionName property: Name of the failover connection.
     * 
     * @param failoverConnectionName the failoverConnectionName value to set.
     * @return the FailoverConnectionDetails object itself.
     */
    public FailoverConnectionDetails withFailoverConnectionName(String failoverConnectionName) {
        this.failoverConnectionName = failoverConnectionName;
        return this;
    }

    /**
     * Get the failoverLocation property: Location of the failover connection.
     * 
     * @return the failoverLocation value.
     */
    public String failoverLocation() {
        return this.failoverLocation;
    }

    /**
     * Set the failoverLocation property: Location of the failover connection.
     * 
     * @param failoverLocation the failoverLocation value to set.
     * @return the FailoverConnectionDetails object itself.
     */
    public FailoverConnectionDetails withFailoverLocation(String failoverLocation) {
        this.failoverLocation = failoverLocation;
        return this;
    }

    /**
     * Get the isVerified property: Whether the customer was able to establish connectivity through this failover
     * connection or not.
     * 
     * @return the isVerified value.
     */
    public Boolean isVerified() {
        return this.isVerified;
    }

    /**
     * Set the isVerified property: Whether the customer was able to establish connectivity through this failover
     * connection or not.
     * 
     * @param isVerified the isVerified value to set.
     * @return the FailoverConnectionDetails object itself.
     */
    public FailoverConnectionDetails withIsVerified(Boolean isVerified) {
        this.isVerified = isVerified;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("failoverConnectionName", this.failoverConnectionName);
        jsonWriter.writeStringField("failoverLocation", this.failoverLocation);
        jsonWriter.writeBooleanField("isVerified", this.isVerified);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of FailoverConnectionDetails from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of FailoverConnectionDetails if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the FailoverConnectionDetails.
     */
    public static FailoverConnectionDetails fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FailoverConnectionDetails deserializedFailoverConnectionDetails = new FailoverConnectionDetails();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("failoverConnectionName".equals(fieldName)) {
                    deserializedFailoverConnectionDetails.failoverConnectionName = reader.getString();
                } else if ("failoverLocation".equals(fieldName)) {
                    deserializedFailoverConnectionDetails.failoverLocation = reader.getString();
                } else if ("isVerified".equals(fieldName)) {
                    deserializedFailoverConnectionDetails.isVerified = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedFailoverConnectionDetails;
        });
    }
}
