// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Azure Firewall Packet Capture Parameters.
 */
@Fluent
public final class FirewallPacketCaptureParameters implements JsonSerializable<FirewallPacketCaptureParameters> {
    /*
     * Duration of packet capture in seconds. If the field is not provided, the default value is 60.
     */
    private Integer durationInSeconds;

    /*
     * Number of packets to be captured. If the field is not provided, the default value is 1000.
     */
    private Integer numberOfPacketsToCapture;

    /*
     * Upload capture location
     */
    private String sasUrl;

    /*
     * Name of file to be uploaded to sasURL
     */
    private String fileName;

    /*
     * The protocol of packets to capture
     */
    private AzureFirewallNetworkRuleProtocol protocol;

    /*
     * The tcp-flag type to be captured. Used with protocol TCP
     */
    private List<AzureFirewallPacketCaptureFlags> flags;

    /*
     * Rules to filter packet captures.
     */
    private List<AzureFirewallPacketCaptureRule> filters;

    /*
     * The Azure Firewall packet capture operation to perform
     */
    private AzureFirewallPacketCaptureOperationType operation;

    /**
     * Creates an instance of FirewallPacketCaptureParameters class.
     */
    public FirewallPacketCaptureParameters() {
    }

    /**
     * Get the durationInSeconds property: Duration of packet capture in seconds. If the field is not provided, the
     * default value is 60.
     * 
     * @return the durationInSeconds value.
     */
    public Integer durationInSeconds() {
        return this.durationInSeconds;
    }

    /**
     * Set the durationInSeconds property: Duration of packet capture in seconds. If the field is not provided, the
     * default value is 60.
     * 
     * @param durationInSeconds the durationInSeconds value to set.
     * @return the FirewallPacketCaptureParameters object itself.
     */
    public FirewallPacketCaptureParameters withDurationInSeconds(Integer durationInSeconds) {
        this.durationInSeconds = durationInSeconds;
        return this;
    }

    /**
     * Get the numberOfPacketsToCapture property: Number of packets to be captured. If the field is not provided, the
     * default value is 1000.
     * 
     * @return the numberOfPacketsToCapture value.
     */
    public Integer numberOfPacketsToCapture() {
        return this.numberOfPacketsToCapture;
    }

    /**
     * Set the numberOfPacketsToCapture property: Number of packets to be captured. If the field is not provided, the
     * default value is 1000.
     * 
     * @param numberOfPacketsToCapture the numberOfPacketsToCapture value to set.
     * @return the FirewallPacketCaptureParameters object itself.
     */
    public FirewallPacketCaptureParameters withNumberOfPacketsToCapture(Integer numberOfPacketsToCapture) {
        this.numberOfPacketsToCapture = numberOfPacketsToCapture;
        return this;
    }

    /**
     * Get the sasUrl property: Upload capture location.
     * 
     * @return the sasUrl value.
     */
    public String sasUrl() {
        return this.sasUrl;
    }

    /**
     * Set the sasUrl property: Upload capture location.
     * 
     * @param sasUrl the sasUrl value to set.
     * @return the FirewallPacketCaptureParameters object itself.
     */
    public FirewallPacketCaptureParameters withSasUrl(String sasUrl) {
        this.sasUrl = sasUrl;
        return this;
    }

    /**
     * Get the fileName property: Name of file to be uploaded to sasURL.
     * 
     * @return the fileName value.
     */
    public String fileName() {
        return this.fileName;
    }

    /**
     * Set the fileName property: Name of file to be uploaded to sasURL.
     * 
     * @param fileName the fileName value to set.
     * @return the FirewallPacketCaptureParameters object itself.
     */
    public FirewallPacketCaptureParameters withFileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    /**
     * Get the protocol property: The protocol of packets to capture.
     * 
     * @return the protocol value.
     */
    public AzureFirewallNetworkRuleProtocol protocol() {
        return this.protocol;
    }

    /**
     * Set the protocol property: The protocol of packets to capture.
     * 
     * @param protocol the protocol value to set.
     * @return the FirewallPacketCaptureParameters object itself.
     */
    public FirewallPacketCaptureParameters withProtocol(AzureFirewallNetworkRuleProtocol protocol) {
        this.protocol = protocol;
        return this;
    }

    /**
     * Get the flags property: The tcp-flag type to be captured. Used with protocol TCP.
     * 
     * @return the flags value.
     */
    public List<AzureFirewallPacketCaptureFlags> flags() {
        return this.flags;
    }

    /**
     * Set the flags property: The tcp-flag type to be captured. Used with protocol TCP.
     * 
     * @param flags the flags value to set.
     * @return the FirewallPacketCaptureParameters object itself.
     */
    public FirewallPacketCaptureParameters withFlags(List<AzureFirewallPacketCaptureFlags> flags) {
        this.flags = flags;
        return this;
    }

    /**
     * Get the filters property: Rules to filter packet captures.
     * 
     * @return the filters value.
     */
    public List<AzureFirewallPacketCaptureRule> filters() {
        return this.filters;
    }

    /**
     * Set the filters property: Rules to filter packet captures.
     * 
     * @param filters the filters value to set.
     * @return the FirewallPacketCaptureParameters object itself.
     */
    public FirewallPacketCaptureParameters withFilters(List<AzureFirewallPacketCaptureRule> filters) {
        this.filters = filters;
        return this;
    }

    /**
     * Get the operation property: The Azure Firewall packet capture operation to perform.
     * 
     * @return the operation value.
     */
    public AzureFirewallPacketCaptureOperationType operation() {
        return this.operation;
    }

    /**
     * Set the operation property: The Azure Firewall packet capture operation to perform.
     * 
     * @param operation the operation value to set.
     * @return the FirewallPacketCaptureParameters object itself.
     */
    public FirewallPacketCaptureParameters withOperation(AzureFirewallPacketCaptureOperationType operation) {
        this.operation = operation;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (flags() != null) {
            flags().forEach(e -> e.validate());
        }
        if (filters() != null) {
            filters().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("durationInSeconds", this.durationInSeconds);
        jsonWriter.writeNumberField("numberOfPacketsToCapture", this.numberOfPacketsToCapture);
        jsonWriter.writeStringField("sasUrl", this.sasUrl);
        jsonWriter.writeStringField("fileName", this.fileName);
        jsonWriter.writeStringField("protocol", this.protocol == null ? null : this.protocol.toString());
        jsonWriter.writeArrayField("flags", this.flags, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("filters", this.filters, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("operation", this.operation == null ? null : this.operation.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of FirewallPacketCaptureParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of FirewallPacketCaptureParameters if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the FirewallPacketCaptureParameters.
     */
    public static FirewallPacketCaptureParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FirewallPacketCaptureParameters deserializedFirewallPacketCaptureParameters
                = new FirewallPacketCaptureParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("durationInSeconds".equals(fieldName)) {
                    deserializedFirewallPacketCaptureParameters.durationInSeconds
                        = reader.getNullable(JsonReader::getInt);
                } else if ("numberOfPacketsToCapture".equals(fieldName)) {
                    deserializedFirewallPacketCaptureParameters.numberOfPacketsToCapture
                        = reader.getNullable(JsonReader::getInt);
                } else if ("sasUrl".equals(fieldName)) {
                    deserializedFirewallPacketCaptureParameters.sasUrl = reader.getString();
                } else if ("fileName".equals(fieldName)) {
                    deserializedFirewallPacketCaptureParameters.fileName = reader.getString();
                } else if ("protocol".equals(fieldName)) {
                    deserializedFirewallPacketCaptureParameters.protocol
                        = AzureFirewallNetworkRuleProtocol.fromString(reader.getString());
                } else if ("flags".equals(fieldName)) {
                    List<AzureFirewallPacketCaptureFlags> flags
                        = reader.readArray(reader1 -> AzureFirewallPacketCaptureFlags.fromJson(reader1));
                    deserializedFirewallPacketCaptureParameters.flags = flags;
                } else if ("filters".equals(fieldName)) {
                    List<AzureFirewallPacketCaptureRule> filters
                        = reader.readArray(reader1 -> AzureFirewallPacketCaptureRule.fromJson(reader1));
                    deserializedFirewallPacketCaptureParameters.filters = filters;
                } else if ("operation".equals(fieldName)) {
                    deserializedFirewallPacketCaptureParameters.operation
                        = AzureFirewallPacketCaptureOperationType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedFirewallPacketCaptureParameters;
        });
    }
}
