// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Network configuration diagnostic result corresponded provided traffic query.
 */
@Fluent
public final class NetworkSecurityGroupResult implements JsonSerializable<NetworkSecurityGroupResult> {
    /*
     * The network traffic is allowed or denied.
     */
    private SecurityRuleAccess securityRuleAccessResult;

    /*
     * List of results network security groups diagnostic.
     */
    private List<EvaluatedNetworkSecurityGroup> evaluatedNetworkSecurityGroups;

    /**
     * Creates an instance of NetworkSecurityGroupResult class.
     */
    public NetworkSecurityGroupResult() {
    }

    /**
     * Get the securityRuleAccessResult property: The network traffic is allowed or denied.
     * 
     * @return the securityRuleAccessResult value.
     */
    public SecurityRuleAccess securityRuleAccessResult() {
        return this.securityRuleAccessResult;
    }

    /**
     * Set the securityRuleAccessResult property: The network traffic is allowed or denied.
     * 
     * @param securityRuleAccessResult the securityRuleAccessResult value to set.
     * @return the NetworkSecurityGroupResult object itself.
     */
    public NetworkSecurityGroupResult withSecurityRuleAccessResult(SecurityRuleAccess securityRuleAccessResult) {
        this.securityRuleAccessResult = securityRuleAccessResult;
        return this;
    }

    /**
     * Get the evaluatedNetworkSecurityGroups property: List of results network security groups diagnostic.
     * 
     * @return the evaluatedNetworkSecurityGroups value.
     */
    public List<EvaluatedNetworkSecurityGroup> evaluatedNetworkSecurityGroups() {
        return this.evaluatedNetworkSecurityGroups;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (evaluatedNetworkSecurityGroups() != null) {
            evaluatedNetworkSecurityGroups().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("securityRuleAccessResult",
            this.securityRuleAccessResult == null ? null : this.securityRuleAccessResult.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NetworkSecurityGroupResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NetworkSecurityGroupResult if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the NetworkSecurityGroupResult.
     */
    public static NetworkSecurityGroupResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NetworkSecurityGroupResult deserializedNetworkSecurityGroupResult = new NetworkSecurityGroupResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("securityRuleAccessResult".equals(fieldName)) {
                    deserializedNetworkSecurityGroupResult.securityRuleAccessResult
                        = SecurityRuleAccess.fromString(reader.getString());
                } else if ("evaluatedNetworkSecurityGroups".equals(fieldName)) {
                    List<EvaluatedNetworkSecurityGroup> evaluatedNetworkSecurityGroups
                        = reader.readArray(reader1 -> EvaluatedNetworkSecurityGroup.fromJson(reader1));
                    deserializedNetworkSecurityGroupResult.evaluatedNetworkSecurityGroups
                        = evaluatedNetworkSecurityGroups;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNetworkSecurityGroupResult;
        });
    }
}
