// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Option indicating enforcement of peerings created by the connectivity configuration.
 */
public final class PeeringEnforcement extends ExpandableStringEnum<PeeringEnforcement> {
    /**
     * Static value Unenforced for PeeringEnforcement.
     */
    public static final PeeringEnforcement UNENFORCED = fromString("Unenforced");

    /**
     * Static value Enforced for PeeringEnforcement.
     */
    public static final PeeringEnforcement ENFORCED = fromString("Enforced");

    /**
     * Creates a new instance of PeeringEnforcement value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public PeeringEnforcement() {
    }

    /**
     * Creates or finds a PeeringEnforcement from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding PeeringEnforcement.
     */
    public static PeeringEnforcement fromString(String name) {
        return fromString(name, PeeringEnforcement.class);
    }

    /**
     * Gets known PeeringEnforcement values.
     * 
     * @return known PeeringEnforcement values.
     */
    public static Collection<PeeringEnforcement> values() {
        return values(PeeringEnforcement.class);
    }
}
