// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Gateway or VpnServerConfiguration Radius server with radius secret details.
 */
@Fluent
public final class RadiusAuthServer implements JsonSerializable<RadiusAuthServer> {
    /*
     * Radius server IPAddress
     */
    private String radiusServerAddress;

    /*
     * Radius server secret
     */
    private String radiusServerSecret;

    /**
     * Creates an instance of RadiusAuthServer class.
     */
    public RadiusAuthServer() {
    }

    /**
     * Get the radiusServerAddress property: Radius server IPAddress.
     * 
     * @return the radiusServerAddress value.
     */
    public String radiusServerAddress() {
        return this.radiusServerAddress;
    }

    /**
     * Set the radiusServerAddress property: Radius server IPAddress.
     * 
     * @param radiusServerAddress the radiusServerAddress value to set.
     * @return the RadiusAuthServer object itself.
     */
    public RadiusAuthServer withRadiusServerAddress(String radiusServerAddress) {
        this.radiusServerAddress = radiusServerAddress;
        return this;
    }

    /**
     * Get the radiusServerSecret property: Radius server secret.
     * 
     * @return the radiusServerSecret value.
     */
    public String radiusServerSecret() {
        return this.radiusServerSecret;
    }

    /**
     * Set the radiusServerSecret property: Radius server secret.
     * 
     * @param radiusServerSecret the radiusServerSecret value to set.
     * @return the RadiusAuthServer object itself.
     */
    public RadiusAuthServer withRadiusServerSecret(String radiusServerSecret) {
        this.radiusServerSecret = radiusServerSecret;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("radiusServerAddress", this.radiusServerAddress);
        jsonWriter.writeStringField("radiusServerSecret", this.radiusServerSecret);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RadiusAuthServer from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RadiusAuthServer if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the RadiusAuthServer.
     */
    public static RadiusAuthServer fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RadiusAuthServer deserializedRadiusAuthServer = new RadiusAuthServer();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("radiusServerAddress".equals(fieldName)) {
                    deserializedRadiusAuthServer.radiusServerAddress = reader.getString();
                } else if ("radiusServerSecret".equals(fieldName)) {
                    deserializedRadiusAuthServer.radiusServerSecret = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRadiusAuthServer;
        });
    }
}
