// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The transport protocol for the endpoint.
 */
public final class TransportProtocol extends ExpandableStringEnum<TransportProtocol> {
    /**
     * Static value Udp for TransportProtocol.
     */
    public static final TransportProtocol UDP = fromString("Udp");

    /**
     * Static value Tcp for TransportProtocol.
     */
    public static final TransportProtocol TCP = fromString("Tcp");

    /**
     * Static value All for TransportProtocol.
     */
    public static final TransportProtocol ALL = fromString("All");

    /**
     * Static value Quic for TransportProtocol.
     */
    public static final TransportProtocol QUIC = fromString("Quic");

    /**
     * Creates a new instance of TransportProtocol value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public TransportProtocol() {
    }

    /**
     * Creates or finds a TransportProtocol from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding TransportProtocol.
     */
    public static TransportProtocol fromString(String name) {
        return fromString(name, TransportProtocol.class);
    }

    /**
     * Gets known TransportProtocol values.
     * 
     * @return known TransportProtocol values.
     */
    public static Collection<TransportProtocol> values() {
        return values(TransportProtocol.class);
    }
}
