// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Represents a single IP configuration.
 */
@Fluent
public final class VirtualApplianceIpConfiguration implements JsonSerializable<VirtualApplianceIpConfiguration> {
    /*
     * For hub NVAs, primary IP configs must be named 'privatenicipconfig' and 'publicnicipconfig', with non-primary
     * configs using these prefixes; no naming restrictions apply for NVAs in VNets. Maximum 80 character are allowed.
     */
    private String name;

    /*
     * Represents a single IP configuration properties.
     */
    private VirtualApplianceIpConfigurationProperties properties;

    /**
     * Creates an instance of VirtualApplianceIpConfiguration class.
     */
    public VirtualApplianceIpConfiguration() {
    }

    /**
     * Get the name property: For hub NVAs, primary IP configs must be named 'privatenicipconfig' and
     * 'publicnicipconfig', with non-primary configs using these prefixes; no naming restrictions apply for NVAs in
     * VNets. Maximum 80 character are allowed.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: For hub NVAs, primary IP configs must be named 'privatenicipconfig' and
     * 'publicnicipconfig', with non-primary configs using these prefixes; no naming restrictions apply for NVAs in
     * VNets. Maximum 80 character are allowed.
     * 
     * @param name the name value to set.
     * @return the VirtualApplianceIpConfiguration object itself.
     */
    public VirtualApplianceIpConfiguration withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the properties property: Represents a single IP configuration properties.
     * 
     * @return the properties value.
     */
    public VirtualApplianceIpConfigurationProperties properties() {
        return this.properties;
    }

    /**
     * Set the properties property: Represents a single IP configuration properties.
     * 
     * @param properties the properties value to set.
     * @return the VirtualApplianceIpConfiguration object itself.
     */
    public VirtualApplianceIpConfiguration withProperties(VirtualApplianceIpConfigurationProperties properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (properties() != null) {
            properties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("properties", this.properties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VirtualApplianceIpConfiguration from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VirtualApplianceIpConfiguration if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VirtualApplianceIpConfiguration.
     */
    public static VirtualApplianceIpConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualApplianceIpConfiguration deserializedVirtualApplianceIpConfiguration
                = new VirtualApplianceIpConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedVirtualApplianceIpConfiguration.name = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedVirtualApplianceIpConfiguration.properties
                        = VirtualApplianceIpConfigurationProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVirtualApplianceIpConfiguration;
        });
    }
}
