/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.Resource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.BastionHostIpConfiguration;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.Sku;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

@JsonFlatten
public class BastionHostInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(BastionHostInner.class);
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="sku")
    private Sku sku;
    @JsonProperty(value="properties.ipConfigurations")
    private List<BastionHostIpConfiguration> ipConfigurations;
    @JsonProperty(value="properties.dnsName")
    private String dnsName;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="id")
    private String id;

    public String etag() {
        return this.etag;
    }

    public Sku sku() {
        return this.sku;
    }

    public BastionHostInner withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    public List<BastionHostIpConfiguration> ipConfigurations() {
        return this.ipConfigurations;
    }

    public BastionHostInner withIpConfigurations(List<BastionHostIpConfiguration> ipConfigurations) {
        this.ipConfigurations = ipConfigurations;
        return this;
    }

    public String dnsName() {
        return this.dnsName;
    }

    public BastionHostInner withDnsName(String dnsName) {
        this.dnsName = dnsName;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String id() {
        return this.id;
    }

    public BastionHostInner withId(String id) {
        this.id = id;
        return this;
    }

    public BastionHostInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public BastionHostInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.ipConfigurations() != null) {
            this.ipConfigurations().forEach(e -> e.validate());
        }
    }
}

