/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.FlowLogFormatParameters;
import com.azure.resourcemanager.network.models.RetentionPolicyParameters;
import com.azure.resourcemanager.network.models.TrafficAnalyticsProperties;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonFlatten
public class FlowLogInformationInner {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(FlowLogInformationInner.class);
    @JsonProperty(value="targetResourceId", required=true)
    private String targetResourceId;
    @JsonProperty(value="flowAnalyticsConfiguration")
    private TrafficAnalyticsProperties flowAnalyticsConfiguration;
    @JsonProperty(value="properties.storageId", required=true)
    private String storageId;
    @JsonProperty(value="properties.enabled", required=true)
    private boolean enabled;
    @JsonProperty(value="properties.retentionPolicy")
    private RetentionPolicyParameters retentionPolicy;
    @JsonProperty(value="properties.format")
    private FlowLogFormatParameters format;

    public String targetResourceId() {
        return this.targetResourceId;
    }

    public FlowLogInformationInner withTargetResourceId(String targetResourceId) {
        this.targetResourceId = targetResourceId;
        return this;
    }

    public TrafficAnalyticsProperties flowAnalyticsConfiguration() {
        return this.flowAnalyticsConfiguration;
    }

    public FlowLogInformationInner withFlowAnalyticsConfiguration(TrafficAnalyticsProperties flowAnalyticsConfiguration) {
        this.flowAnalyticsConfiguration = flowAnalyticsConfiguration;
        return this;
    }

    public String storageId() {
        return this.storageId;
    }

    public FlowLogInformationInner withStorageId(String storageId) {
        this.storageId = storageId;
        return this;
    }

    public boolean enabled() {
        return this.enabled;
    }

    public FlowLogInformationInner withEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public RetentionPolicyParameters retentionPolicy() {
        return this.retentionPolicy;
    }

    public FlowLogInformationInner withRetentionPolicy(RetentionPolicyParameters retentionPolicy) {
        this.retentionPolicy = retentionPolicy;
        return this;
    }

    public FlowLogFormatParameters format() {
        return this.format;
    }

    public FlowLogInformationInner withFormat(FlowLogFormatParameters format) {
        this.format = format;
        return this;
    }

    public void validate() {
        if (this.targetResourceId() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property targetResourceId in model FlowLogInformationInner"));
        }
        if (this.flowAnalyticsConfiguration() != null) {
            this.flowAnalyticsConfiguration().validate();
        }
        if (this.storageId() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property storageId in model FlowLogInformationInner"));
        }
        if (this.retentionPolicy() != null) {
            this.retentionPolicy().validate();
        }
        if (this.format() != null) {
            this.format().validate();
        }
    }
}

