/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.core.management.SubResource;
import com.azure.resourcemanager.network.NetworkManager;
import com.azure.resourcemanager.network.implementation.ApplicationGatewayImpl;
import com.azure.resourcemanager.network.implementation.Utils;
import com.azure.resourcemanager.network.models.ApplicationGateway;
import com.azure.resourcemanager.network.models.ApplicationGatewayFrontend;
import com.azure.resourcemanager.network.models.ApplicationGatewayFrontendIpConfiguration;
import com.azure.resourcemanager.network.models.IpAllocationMethod;
import com.azure.resourcemanager.network.models.Network;
import com.azure.resourcemanager.network.models.PublicIpAddress;
import com.azure.resourcemanager.network.models.Subnet;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ChildResourceImpl;

class ApplicationGatewayFrontendImpl
extends ChildResourceImpl<ApplicationGatewayFrontendIpConfiguration, ApplicationGatewayImpl, ApplicationGateway>
implements ApplicationGatewayFrontend,
ApplicationGatewayFrontend.Definition<ApplicationGateway.DefinitionStages.WithListener>,
ApplicationGatewayFrontend.UpdateDefinition<ApplicationGateway.Update>,
ApplicationGatewayFrontend.Update {
    ApplicationGatewayFrontendImpl(ApplicationGatewayFrontendIpConfiguration inner, ApplicationGatewayImpl parent) {
        super((Object)inner, (Object)parent);
    }

    public String networkId() {
        SubResource subnetRef = ((ApplicationGatewayFrontendIpConfiguration)((Object)this.innerModel())).subnet();
        if (subnetRef != null) {
            return ResourceUtils.parentResourceIdFromResourceId((String)subnetRef.id());
        }
        return null;
    }

    public String subnetName() {
        SubResource subnetRef = ((ApplicationGatewayFrontendIpConfiguration)((Object)this.innerModel())).subnet();
        if (subnetRef != null) {
            return ResourceUtils.nameFromResourceId((String)subnetRef.id());
        }
        return null;
    }

    @Override
    public String privateIpAddress() {
        return ((ApplicationGatewayFrontendIpConfiguration)((Object)this.innerModel())).privateIpAddress();
    }

    @Override
    public IpAllocationMethod privateIpAllocationMethod() {
        return ((ApplicationGatewayFrontendIpConfiguration)((Object)this.innerModel())).privateIpAllocationMethod();
    }

    public String name() {
        return ((ApplicationGatewayFrontendIpConfiguration)((Object)this.innerModel())).name();
    }

    @Override
    public String publicIpAddressId() {
        if (((ApplicationGatewayFrontendIpConfiguration)((Object)this.innerModel())).publicIpAddress() != null) {
            return ((ApplicationGatewayFrontendIpConfiguration)((Object)this.innerModel())).publicIpAddress().id();
        }
        return null;
    }

    @Override
    public boolean isPublic() {
        return ((ApplicationGatewayFrontendIpConfiguration)((Object)this.innerModel())).publicIpAddress() != null;
    }

    @Override
    public boolean isPrivate() {
        return ((ApplicationGatewayFrontendIpConfiguration)((Object)this.innerModel())).subnet() != null;
    }

    public ApplicationGatewayFrontendImpl withExistingSubnet(Network network, String subnetName) {
        return this.withExistingSubnet(network.id(), subnetName);
    }

    public ApplicationGatewayFrontendImpl withExistingSubnet(String parentNetworkResourceId, String subnetName) {
        SubResource subnetRef = new SubResource().withId(parentNetworkResourceId + "/subnets/" + subnetName);
        ((ApplicationGatewayFrontendIpConfiguration)((Object)this.innerModel())).withSubnet(subnetRef);
        this.withoutPublicIpAddress();
        return this;
    }

    @Override
    public ApplicationGatewayFrontendImpl withExistingPublicIpAddress(PublicIpAddress pip) {
        return this.withExistingPublicIpAddress(pip.id());
    }

    @Override
    public ApplicationGatewayFrontendImpl withExistingPublicIpAddress(String resourceId) {
        SubResource pipRef = new SubResource().withId(resourceId);
        ((ApplicationGatewayFrontendIpConfiguration)((Object)this.innerModel())).withPublicIpAddress(pipRef);
        this.withoutSubnet();
        return this;
    }

    @Override
    public ApplicationGatewayFrontendImpl withoutPublicIpAddress() {
        ((ApplicationGatewayFrontendIpConfiguration)((Object)this.innerModel())).withPublicIpAddress(null);
        return this;
    }

    public ApplicationGatewayFrontendImpl withoutSubnet() {
        ((ApplicationGatewayFrontendIpConfiguration)((Object)this.innerModel())).withSubnet(null).withPrivateIpAddress(null).withPrivateIpAllocationMethod(null);
        return this;
    }

    @Override
    public ApplicationGatewayFrontendImpl withPrivateIpAddressDynamic() {
        ((ApplicationGatewayFrontendIpConfiguration)((Object)this.innerModel())).withPrivateIpAddress(null).withPrivateIpAllocationMethod(IpAllocationMethod.DYNAMIC);
        return this;
    }

    @Override
    public ApplicationGatewayFrontendImpl withPrivateIpAddressStatic(String ipAddress) {
        ((ApplicationGatewayFrontendIpConfiguration)((Object)this.innerModel())).withPrivateIpAddress(ipAddress).withPrivateIpAllocationMethod(IpAllocationMethod.STATIC);
        return this;
    }

    @Override
    public Subnet getSubnet() {
        return Utils.getAssociatedSubnet((NetworkManager)((ApplicationGatewayImpl)this.parent()).manager(), ((ApplicationGatewayFrontendIpConfiguration)((Object)this.innerModel())).subnet());
    }

    public ApplicationGatewayImpl attach() {
        return ((ApplicationGatewayImpl)this.parent()).withFrontend(this);
    }

    @Override
    public PublicIpAddress getPublicIpAddress() {
        String pipId = this.publicIpAddressId();
        if (pipId == null) {
            return null;
        }
        return (PublicIpAddress)((NetworkManager)((ApplicationGatewayImpl)this.parent()).manager()).publicIpAddresses().getById(pipId);
    }
}

