/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.ApplicationGatewayConnectionDraining;
import com.azure.resourcemanager.network.models.ApplicationGatewayCookieBasedAffinity;
import com.azure.resourcemanager.network.models.ApplicationGatewayProtocol;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

@JsonFlatten
public class ApplicationGatewayBackendHttpSettings
extends SubResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ApplicationGatewayBackendHttpSettings.class);
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="type", access=JsonProperty.Access.WRITE_ONLY)
    private String type;
    @JsonProperty(value="properties.port")
    private Integer port;
    @JsonProperty(value="properties.protocol")
    private ApplicationGatewayProtocol protocol;
    @JsonProperty(value="properties.cookieBasedAffinity")
    private ApplicationGatewayCookieBasedAffinity cookieBasedAffinity;
    @JsonProperty(value="properties.requestTimeout")
    private Integer requestTimeout;
    @JsonProperty(value="properties.probe")
    private SubResource probe;
    @JsonProperty(value="properties.authenticationCertificates")
    private List<SubResource> authenticationCertificates;
    @JsonProperty(value="properties.trustedRootCertificates")
    private List<SubResource> trustedRootCertificates;
    @JsonProperty(value="properties.connectionDraining")
    private ApplicationGatewayConnectionDraining connectionDraining;
    @JsonProperty(value="properties.hostName")
    private String hostname;
    @JsonProperty(value="properties.pickHostNameFromBackendAddress")
    private Boolean pickHostnameFromBackendAddress;
    @JsonProperty(value="properties.affinityCookieName")
    private String affinityCookieName;
    @JsonProperty(value="properties.probeEnabled")
    private Boolean probeEnabled;
    @JsonProperty(value="properties.path")
    private String path;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;

    public String name() {
        return this.name;
    }

    public ApplicationGatewayBackendHttpSettings withName(String name) {
        this.name = name;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public String type() {
        return this.type;
    }

    public Integer port() {
        return this.port;
    }

    public ApplicationGatewayBackendHttpSettings withPort(Integer port) {
        this.port = port;
        return this;
    }

    public ApplicationGatewayProtocol protocol() {
        return this.protocol;
    }

    public ApplicationGatewayBackendHttpSettings withProtocol(ApplicationGatewayProtocol protocol) {
        this.protocol = protocol;
        return this;
    }

    public ApplicationGatewayCookieBasedAffinity cookieBasedAffinity() {
        return this.cookieBasedAffinity;
    }

    public ApplicationGatewayBackendHttpSettings withCookieBasedAffinity(ApplicationGatewayCookieBasedAffinity cookieBasedAffinity) {
        this.cookieBasedAffinity = cookieBasedAffinity;
        return this;
    }

    public Integer requestTimeout() {
        return this.requestTimeout;
    }

    public ApplicationGatewayBackendHttpSettings withRequestTimeout(Integer requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    public SubResource probe() {
        return this.probe;
    }

    public ApplicationGatewayBackendHttpSettings withProbe(SubResource probe) {
        this.probe = probe;
        return this;
    }

    public List<SubResource> authenticationCertificates() {
        return this.authenticationCertificates;
    }

    public ApplicationGatewayBackendHttpSettings withAuthenticationCertificates(List<SubResource> authenticationCertificates) {
        this.authenticationCertificates = authenticationCertificates;
        return this;
    }

    public List<SubResource> trustedRootCertificates() {
        return this.trustedRootCertificates;
    }

    public ApplicationGatewayBackendHttpSettings withTrustedRootCertificates(List<SubResource> trustedRootCertificates) {
        this.trustedRootCertificates = trustedRootCertificates;
        return this;
    }

    public ApplicationGatewayConnectionDraining connectionDraining() {
        return this.connectionDraining;
    }

    public ApplicationGatewayBackendHttpSettings withConnectionDraining(ApplicationGatewayConnectionDraining connectionDraining) {
        this.connectionDraining = connectionDraining;
        return this;
    }

    public String hostname() {
        return this.hostname;
    }

    public ApplicationGatewayBackendHttpSettings withHostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    public Boolean pickHostnameFromBackendAddress() {
        return this.pickHostnameFromBackendAddress;
    }

    public ApplicationGatewayBackendHttpSettings withPickHostnameFromBackendAddress(Boolean pickHostnameFromBackendAddress) {
        this.pickHostnameFromBackendAddress = pickHostnameFromBackendAddress;
        return this;
    }

    public String affinityCookieName() {
        return this.affinityCookieName;
    }

    public ApplicationGatewayBackendHttpSettings withAffinityCookieName(String affinityCookieName) {
        this.affinityCookieName = affinityCookieName;
        return this;
    }

    public Boolean probeEnabled() {
        return this.probeEnabled;
    }

    public ApplicationGatewayBackendHttpSettings withProbeEnabled(Boolean probeEnabled) {
        this.probeEnabled = probeEnabled;
        return this;
    }

    public String path() {
        return this.path;
    }

    public ApplicationGatewayBackendHttpSettings withPath(String path) {
        this.path = path;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public ApplicationGatewayBackendHttpSettings withId(String id) {
        super.withId(id);
        return this;
    }

    public void validate() {
        if (this.connectionDraining() != null) {
            this.connectionDraining().validate();
        }
    }
}

