/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.MatchVariable;
import com.azure.resourcemanager.network.models.WebApplicationFirewallOperator;
import com.azure.resourcemanager.network.models.WebApplicationFirewallTransform;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class MatchCondition {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(MatchCondition.class);
    @JsonProperty(value="matchVariables", required=true)
    private List<MatchVariable> matchVariables;
    @JsonProperty(value="operator", required=true)
    private WebApplicationFirewallOperator operator;
    @JsonProperty(value="negationConditon")
    private Boolean negationConditon;
    @JsonProperty(value="matchValues", required=true)
    private List<String> matchValues;
    @JsonProperty(value="transforms")
    private List<WebApplicationFirewallTransform> transforms;

    public List<MatchVariable> matchVariables() {
        return this.matchVariables;
    }

    public MatchCondition withMatchVariables(List<MatchVariable> matchVariables) {
        this.matchVariables = matchVariables;
        return this;
    }

    public WebApplicationFirewallOperator operator() {
        return this.operator;
    }

    public MatchCondition withOperator(WebApplicationFirewallOperator operator) {
        this.operator = operator;
        return this;
    }

    public Boolean negationConditon() {
        return this.negationConditon;
    }

    public MatchCondition withNegationConditon(Boolean negationConditon) {
        this.negationConditon = negationConditon;
        return this;
    }

    public List<String> matchValues() {
        return this.matchValues;
    }

    public MatchCondition withMatchValues(List<String> matchValues) {
        this.matchValues = matchValues;
        return this;
    }

    public List<WebApplicationFirewallTransform> transforms() {
        return this.transforms;
    }

    public MatchCondition withTransforms(List<WebApplicationFirewallTransform> transforms) {
        this.transforms = transforms;
        return this;
    }

    public void validate() {
        if (this.matchVariables() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property matchVariables in model MatchCondition"));
        }
        this.matchVariables().forEach(e -> e.validate());
        if (this.operator() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property operator in model MatchCondition"));
        }
        if (this.matchValues() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property matchValues in model MatchCondition"));
        }
    }
}

