// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.VM;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Bastion Shareable Link. */
@Fluent
public final class BastionShareableLinkInner {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(BastionShareableLinkInner.class);

    /*
     * Reference of the virtual machine resource.
     */
    @JsonProperty(value = "vm", required = true)
    private VM vm;

    /*
     * The unique Bastion Shareable Link to the virtual machine.
     */
    @JsonProperty(value = "bsl", access = JsonProperty.Access.WRITE_ONLY)
    private String bsl;

    /*
     * The time when the link was created.
     */
    @JsonProperty(value = "createdAt", access = JsonProperty.Access.WRITE_ONLY)
    private String createdAt;

    /*
     * Optional field indicating the warning or error message related to the vm
     * in case of partial failure.
     */
    @JsonProperty(value = "message", access = JsonProperty.Access.WRITE_ONLY)
    private String message;

    /**
     * Get the vm property: Reference of the virtual machine resource.
     *
     * @return the vm value.
     */
    public VM vm() {
        return this.vm;
    }

    /**
     * Set the vm property: Reference of the virtual machine resource.
     *
     * @param vm the vm value to set.
     * @return the BastionShareableLinkInner object itself.
     */
    public BastionShareableLinkInner withVm(VM vm) {
        this.vm = vm;
        return this;
    }

    /**
     * Get the bsl property: The unique Bastion Shareable Link to the virtual machine.
     *
     * @return the bsl value.
     */
    public String bsl() {
        return this.bsl;
    }

    /**
     * Get the createdAt property: The time when the link was created.
     *
     * @return the createdAt value.
     */
    public String createdAt() {
        return this.createdAt;
    }

    /**
     * Get the message property: Optional field indicating the warning or error message related to the vm in case of
     * partial failure.
     *
     * @return the message value.
     */
    public String message() {
        return this.message;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (vm() == null) {
            throw logger
                .logExceptionAsError(
                    new IllegalArgumentException("Missing required property vm in model BastionShareableLinkInner"));
        } else {
            vm().validate();
        }
    }
}
