// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.Resource;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

/** The IpGroups resource information. */
@JsonFlatten
@Fluent
public class IpGroupInner extends Resource {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(IpGroupInner.class);

    /*
     * A unique read-only string that changes whenever the resource is updated.
     */
    @JsonProperty(value = "etag", access = JsonProperty.Access.WRITE_ONLY)
    private String etag;

    /*
     * The provisioning state of the IpGroups resource.
     */
    @JsonProperty(value = "properties.provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;

    /*
     * IpAddresses/IpAddressPrefixes in the IpGroups resource.
     */
    @JsonProperty(value = "properties.ipAddresses")
    private List<String> ipAddresses;

    /*
     * List of references to Firewall resources that this IpGroups is
     * associated with.
     */
    @JsonProperty(value = "properties.firewalls", access = JsonProperty.Access.WRITE_ONLY)
    private List<SubResource> firewalls;

    /*
     * List of references to Firewall Policies resources that this IpGroups is
     * associated with.
     */
    @JsonProperty(value = "properties.firewallPolicies", access = JsonProperty.Access.WRITE_ONLY)
    private List<SubResource> firewallPolicies;

    /*
     * Resource ID.
     */
    @JsonProperty(value = "id")
    private String id;

    /**
     * Get the etag property: A unique read-only string that changes whenever the resource is updated.
     *
     * @return the etag value.
     */
    public String etag() {
        return this.etag;
    }

    /**
     * Get the provisioningState property: The provisioning state of the IpGroups resource.
     *
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the ipAddresses property: IpAddresses/IpAddressPrefixes in the IpGroups resource.
     *
     * @return the ipAddresses value.
     */
    public List<String> ipAddresses() {
        return this.ipAddresses;
    }

    /**
     * Set the ipAddresses property: IpAddresses/IpAddressPrefixes in the IpGroups resource.
     *
     * @param ipAddresses the ipAddresses value to set.
     * @return the IpGroupInner object itself.
     */
    public IpGroupInner withIpAddresses(List<String> ipAddresses) {
        this.ipAddresses = ipAddresses;
        return this;
    }

    /**
     * Get the firewalls property: List of references to Firewall resources that this IpGroups is associated with.
     *
     * @return the firewalls value.
     */
    public List<SubResource> firewalls() {
        return this.firewalls;
    }

    /**
     * Get the firewallPolicies property: List of references to Firewall Policies resources that this IpGroups is
     * associated with.
     *
     * @return the firewallPolicies value.
     */
    public List<SubResource> firewallPolicies() {
        return this.firewallPolicies;
    }

    /**
     * Get the id property: Resource ID.
     *
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: Resource ID.
     *
     * @param id the id value to set.
     * @return the IpGroupInner object itself.
     */
    public IpGroupInner withId(String id) {
        this.id = id;
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public IpGroupInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public IpGroupInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
