// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.VpnNatRuleMapping;
import com.azure.resourcemanager.network.models.VpnNatRuleMode;
import com.azure.resourcemanager.network.models.VpnNatRuleType;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** VirtualNetworkGatewayNatRule Resource. */
@JsonFlatten
@Fluent
public class VirtualNetworkGatewayNatRuleInner extends SubResource {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(VirtualNetworkGatewayNatRuleInner.class);

    /*
     * The name of the resource that is unique within a resource group. This
     * name can be used to access the resource.
     */
    @JsonProperty(value = "name")
    private String name;

    /*
     * A unique read-only string that changes whenever the resource is updated.
     */
    @JsonProperty(value = "etag", access = JsonProperty.Access.WRITE_ONLY)
    private String etag;

    /*
     * Resource type.
     */
    @JsonProperty(value = "type", access = JsonProperty.Access.WRITE_ONLY)
    private String type;

    /*
     * The provisioning state of the NAT Rule resource.
     */
    @JsonProperty(value = "properties.provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;

    /*
     * The type of NAT rule for VPN NAT.
     */
    @JsonProperty(value = "properties.type")
    private VpnNatRuleType typePropertiesType;

    /*
     * The Source NAT direction of a VPN NAT.
     */
    @JsonProperty(value = "properties.mode")
    private VpnNatRuleMode mode;

    /*
     * The private IP address internal mapping for NAT.
     */
    @JsonProperty(value = "properties.internalMappings")
    private List<VpnNatRuleMapping> internalMappings;

    /*
     * The private IP address external mapping for NAT.
     */
    @JsonProperty(value = "properties.externalMappings")
    private List<VpnNatRuleMapping> externalMappings;

    /*
     * The IP Configuration ID this NAT rule applies to.
     */
    @JsonProperty(value = "properties.ipConfigurationId")
    private String ipConfigurationId;

    /**
     * Get the name property: The name of the resource that is unique within a resource group. This name can be used to
     * access the resource.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the resource that is unique within a resource group. This name can be used to
     * access the resource.
     *
     * @param name the name value to set.
     * @return the VirtualNetworkGatewayNatRuleInner object itself.
     */
    public VirtualNetworkGatewayNatRuleInner withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the etag property: A unique read-only string that changes whenever the resource is updated.
     *
     * @return the etag value.
     */
    public String etag() {
        return this.etag;
    }

    /**
     * Get the type property: Resource type.
     *
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Get the provisioningState property: The provisioning state of the NAT Rule resource.
     *
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the typePropertiesType property: The type of NAT rule for VPN NAT.
     *
     * @return the typePropertiesType value.
     */
    public VpnNatRuleType typePropertiesType() {
        return this.typePropertiesType;
    }

    /**
     * Set the typePropertiesType property: The type of NAT rule for VPN NAT.
     *
     * @param typePropertiesType the typePropertiesType value to set.
     * @return the VirtualNetworkGatewayNatRuleInner object itself.
     */
    public VirtualNetworkGatewayNatRuleInner withTypePropertiesType(VpnNatRuleType typePropertiesType) {
        this.typePropertiesType = typePropertiesType;
        return this;
    }

    /**
     * Get the mode property: The Source NAT direction of a VPN NAT.
     *
     * @return the mode value.
     */
    public VpnNatRuleMode mode() {
        return this.mode;
    }

    /**
     * Set the mode property: The Source NAT direction of a VPN NAT.
     *
     * @param mode the mode value to set.
     * @return the VirtualNetworkGatewayNatRuleInner object itself.
     */
    public VirtualNetworkGatewayNatRuleInner withMode(VpnNatRuleMode mode) {
        this.mode = mode;
        return this;
    }

    /**
     * Get the internalMappings property: The private IP address internal mapping for NAT.
     *
     * @return the internalMappings value.
     */
    public List<VpnNatRuleMapping> internalMappings() {
        return this.internalMappings;
    }

    /**
     * Set the internalMappings property: The private IP address internal mapping for NAT.
     *
     * @param internalMappings the internalMappings value to set.
     * @return the VirtualNetworkGatewayNatRuleInner object itself.
     */
    public VirtualNetworkGatewayNatRuleInner withInternalMappings(List<VpnNatRuleMapping> internalMappings) {
        this.internalMappings = internalMappings;
        return this;
    }

    /**
     * Get the externalMappings property: The private IP address external mapping for NAT.
     *
     * @return the externalMappings value.
     */
    public List<VpnNatRuleMapping> externalMappings() {
        return this.externalMappings;
    }

    /**
     * Set the externalMappings property: The private IP address external mapping for NAT.
     *
     * @param externalMappings the externalMappings value to set.
     * @return the VirtualNetworkGatewayNatRuleInner object itself.
     */
    public VirtualNetworkGatewayNatRuleInner withExternalMappings(List<VpnNatRuleMapping> externalMappings) {
        this.externalMappings = externalMappings;
        return this;
    }

    /**
     * Get the ipConfigurationId property: The IP Configuration ID this NAT rule applies to.
     *
     * @return the ipConfigurationId value.
     */
    public String ipConfigurationId() {
        return this.ipConfigurationId;
    }

    /**
     * Set the ipConfigurationId property: The IP Configuration ID this NAT rule applies to.
     *
     * @param ipConfigurationId the ipConfigurationId value to set.
     * @return the VirtualNetworkGatewayNatRuleInner object itself.
     */
    public VirtualNetworkGatewayNatRuleInner withIpConfigurationId(String ipConfigurationId) {
        this.ipConfigurationId = ipConfigurationId;
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public VirtualNetworkGatewayNatRuleInner withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (internalMappings() != null) {
            internalMappings().forEach(e -> e.validate());
        }
        if (externalMappings() != null) {
            externalMappings().forEach(e -> e.validate());
        }
    }
}
