// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.network.fluent.ExpressRouteCrossConnectionsClient;
import com.azure.resourcemanager.network.fluent.models.ExpressRouteCircuitsArpTableListResultInner;
import com.azure.resourcemanager.network.fluent.models.ExpressRouteCircuitsRoutesTableListResultInner;
import com.azure.resourcemanager.network.fluent.models.ExpressRouteCrossConnectionInner;
import com.azure.resourcemanager.network.fluent.models.ExpressRouteCrossConnectionsRoutesTableSummaryListResultInner;
import com.azure.resourcemanager.network.models.ExpressRouteCrossConnectionListResult;
import com.azure.resourcemanager.network.models.TagsObject;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsGet;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import java.nio.ByteBuffer;
import java.util.Map;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in ExpressRouteCrossConnectionsClient. */
public final class ExpressRouteCrossConnectionsClientImpl
    implements InnerSupportsGet<ExpressRouteCrossConnectionInner>,
        InnerSupportsListing<ExpressRouteCrossConnectionInner>,
        ExpressRouteCrossConnectionsClient {
    private final ClientLogger logger = new ClientLogger(ExpressRouteCrossConnectionsClientImpl.class);

    /** The proxy service used to perform REST calls. */
    private final ExpressRouteCrossConnectionsService service;

    /** The service client containing this operation class. */
    private final NetworkManagementClientImpl client;

    /**
     * Initializes an instance of ExpressRouteCrossConnectionsClientImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    ExpressRouteCrossConnectionsClientImpl(NetworkManagementClientImpl client) {
        this.service =
            RestProxy
                .create(
                    ExpressRouteCrossConnectionsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for NetworkManagementClientExpressRouteCrossConnections to be used by the
     * proxy service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "NetworkManagementCli")
    private interface ExpressRouteCrossConnectionsService {
        @Headers({"Content-Type: application/json"})
        @Get("/subscriptions/{subscriptionId}/providers/Microsoft.Network/expressRouteCrossConnections")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ExpressRouteCrossConnectionListResult>> list(
            @HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network"
                + "/expressRouteCrossConnections")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ExpressRouteCrossConnectionListResult>> listByResourceGroup(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network"
                + "/expressRouteCrossConnections/{crossConnectionName}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ExpressRouteCrossConnectionInner>> getByResourceGroup(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("crossConnectionName") String crossConnectionName,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Put(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network"
                + "/expressRouteCrossConnections/{crossConnectionName}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> createOrUpdate(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("crossConnectionName") String crossConnectionName,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @BodyParam("application/json") ExpressRouteCrossConnectionInner parameters,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Patch(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network"
                + "/expressRouteCrossConnections/{crossConnectionName}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ExpressRouteCrossConnectionInner>> updateTags(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("crossConnectionName") String crossConnectionName,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @BodyParam("application/json") TagsObject crossConnectionParameters,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network"
                + "/expressRouteCrossConnections/{crossConnectionName}/peerings/{peeringName}/arpTables/{devicePath}")
        @ExpectedResponses({200, 202})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> listArpTable(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("crossConnectionName") String crossConnectionName,
            @PathParam("peeringName") String peeringName,
            @PathParam("devicePath") String devicePath,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network"
                + "/expressRouteCrossConnections/{crossConnectionName}/peerings/{peeringName}/routeTablesSummary"
                + "/{devicePath}")
        @ExpectedResponses({200, 202})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> listRoutesTableSummary(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("crossConnectionName") String crossConnectionName,
            @PathParam("peeringName") String peeringName,
            @PathParam("devicePath") String devicePath,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network"
                + "/expressRouteCrossConnections/{crossConnectionName}/peerings/{peeringName}/routeTables/{devicePath}")
        @ExpectedResponses({200, 202})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> listRoutesTable(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("crossConnectionName") String crossConnectionName,
            @PathParam("peeringName") String peeringName,
            @PathParam("devicePath") String devicePath,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ExpressRouteCrossConnectionListResult>> listNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ExpressRouteCrossConnectionListResult>> listByResourceGroupNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept,
            Context context);
    }

    /**
     * Retrieves all the ExpressRouteCrossConnections in a subscription.
     *
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response for ListExpressRouteCrossConnection API service call.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ExpressRouteCrossConnectionInner>> listSinglePageAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2021-02-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .list(this.client.getEndpoint(), apiVersion, this.client.getSubscriptionId(), accept, context))
            .<PagedResponse<ExpressRouteCrossConnectionInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Retrieves all the ExpressRouteCrossConnections in a subscription.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response for ListExpressRouteCrossConnection API service call.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ExpressRouteCrossConnectionInner>> listSinglePageAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2021-02-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .list(this.client.getEndpoint(), apiVersion, this.client.getSubscriptionId(), accept, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Retrieves all the ExpressRouteCrossConnections in a subscription.
     *
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response for ListExpressRouteCrossConnection API service call.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<ExpressRouteCrossConnectionInner> listAsync() {
        return new PagedFlux<>(() -> listSinglePageAsync(), nextLink -> listNextSinglePageAsync(nextLink));
    }

    /**
     * Retrieves all the ExpressRouteCrossConnections in a subscription.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response for ListExpressRouteCrossConnection API service call.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<ExpressRouteCrossConnectionInner> listAsync(Context context) {
        return new PagedFlux<>(
            () -> listSinglePageAsync(context), nextLink -> listNextSinglePageAsync(nextLink, context));
    }

    /**
     * Retrieves all the ExpressRouteCrossConnections in a subscription.
     *
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response for ListExpressRouteCrossConnection API service call.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ExpressRouteCrossConnectionInner> list() {
        return new PagedIterable<>(listAsync());
    }

    /**
     * Retrieves all the ExpressRouteCrossConnections in a subscription.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response for ListExpressRouteCrossConnection API service call.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ExpressRouteCrossConnectionInner> list(Context context) {
        return new PagedIterable<>(listAsync(context));
    }

    /**
     * Retrieves all the ExpressRouteCrossConnections in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response for ListExpressRouteCrossConnection API service call.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ExpressRouteCrossConnectionInner>> listByResourceGroupSinglePageAsync(
        String resourceGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2021-02-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listByResourceGroup(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            apiVersion,
                            this.client.getSubscriptionId(),
                            accept,
                            context))
            .<PagedResponse<ExpressRouteCrossConnectionInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Retrieves all the ExpressRouteCrossConnections in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response for ListExpressRouteCrossConnection API service call.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ExpressRouteCrossConnectionInner>> listByResourceGroupSinglePageAsync(
        String resourceGroupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2021-02-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listByResourceGroup(
                this.client.getEndpoint(),
                resourceGroupName,
                apiVersion,
                this.client.getSubscriptionId(),
                accept,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Retrieves all the ExpressRouteCrossConnections in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response for ListExpressRouteCrossConnection API service call.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<ExpressRouteCrossConnectionInner> listByResourceGroupAsync(String resourceGroupName) {
        return new PagedFlux<>(
            () -> listByResourceGroupSinglePageAsync(resourceGroupName),
            nextLink -> listByResourceGroupNextSinglePageAsync(nextLink));
    }

    /**
     * Retrieves all the ExpressRouteCrossConnections in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response for ListExpressRouteCrossConnection API service call.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<ExpressRouteCrossConnectionInner> listByResourceGroupAsync(
        String resourceGroupName, Context context) {
        return new PagedFlux<>(
            () -> listByResourceGroupSinglePageAsync(resourceGroupName, context),
            nextLink -> listByResourceGroupNextSinglePageAsync(nextLink, context));
    }

    /**
     * Retrieves all the ExpressRouteCrossConnections in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response for ListExpressRouteCrossConnection API service call.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ExpressRouteCrossConnectionInner> listByResourceGroup(String resourceGroupName) {
        return new PagedIterable<>(listByResourceGroupAsync(resourceGroupName));
    }

    /**
     * Retrieves all the ExpressRouteCrossConnections in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response for ListExpressRouteCrossConnection API service call.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ExpressRouteCrossConnectionInner> listByResourceGroup(
        String resourceGroupName, Context context) {
        return new PagedIterable<>(listByResourceGroupAsync(resourceGroupName, context));
    }

    /**
     * Gets details about the specified ExpressRouteCrossConnection.
     *
     * @param resourceGroupName The name of the resource group (peering location of the circuit).
     * @param crossConnectionName The name of the ExpressRouteCrossConnection (service key of the circuit).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return details about the specified ExpressRouteCrossConnection.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<ExpressRouteCrossConnectionInner>> getByResourceGroupWithResponseAsync(
        String resourceGroupName, String crossConnectionName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (crossConnectionName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter crossConnectionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2021-02-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .getByResourceGroup(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            crossConnectionName,
                            apiVersion,
                            this.client.getSubscriptionId(),
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets details about the specified ExpressRouteCrossConnection.
     *
     * @param resourceGroupName The name of the resource group (peering location of the circuit).
     * @param crossConnectionName The name of the ExpressRouteCrossConnection (service key of the circuit).
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return details about the specified ExpressRouteCrossConnection.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<ExpressRouteCrossConnectionInner>> getByResourceGroupWithResponseAsync(
        String resourceGroupName, String crossConnectionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (crossConnectionName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter crossConnectionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2021-02-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .getByResourceGroup(
                this.client.getEndpoint(),
                resourceGroupName,
                crossConnectionName,
                apiVersion,
                this.client.getSubscriptionId(),
                accept,
                context);
    }

    /**
     * Gets details about the specified ExpressRouteCrossConnection.
     *
     * @param resourceGroupName The name of the resource group (peering location of the circuit).
     * @param crossConnectionName The name of the ExpressRouteCrossConnection (service key of the circuit).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return details about the specified ExpressRouteCrossConnection.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ExpressRouteCrossConnectionInner> getByResourceGroupAsync(
        String resourceGroupName, String crossConnectionName) {
        return getByResourceGroupWithResponseAsync(resourceGroupName, crossConnectionName)
            .flatMap(
                (Response<ExpressRouteCrossConnectionInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Gets details about the specified ExpressRouteCrossConnection.
     *
     * @param resourceGroupName The name of the resource group (peering location of the circuit).
     * @param crossConnectionName The name of the ExpressRouteCrossConnection (service key of the circuit).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return details about the specified ExpressRouteCrossConnection.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ExpressRouteCrossConnectionInner getByResourceGroup(String resourceGroupName, String crossConnectionName) {
        return getByResourceGroupAsync(resourceGroupName, crossConnectionName).block();
    }

    /**
     * Gets details about the specified ExpressRouteCrossConnection.
     *
     * @param resourceGroupName The name of the resource group (peering location of the circuit).
     * @param crossConnectionName The name of the ExpressRouteCrossConnection (service key of the circuit).
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return details about the specified ExpressRouteCrossConnection.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<ExpressRouteCrossConnectionInner> getByResourceGroupWithResponse(
        String resourceGroupName, String crossConnectionName, Context context) {
        return getByResourceGroupWithResponseAsync(resourceGroupName, crossConnectionName, context).block();
    }

    /**
     * Update the specified ExpressRouteCrossConnection.
     *
     * @param resourceGroupName The name of the resource group.
     * @param crossConnectionName The name of the ExpressRouteCrossConnection.
     * @param parameters Parameters supplied to the update express route crossConnection operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return expressRouteCrossConnection resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(
        String resourceGroupName, String crossConnectionName, ExpressRouteCrossConnectionInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (crossConnectionName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter crossConnectionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String apiVersion = "2021-02-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .createOrUpdate(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            crossConnectionName,
                            apiVersion,
                            this.client.getSubscriptionId(),
                            parameters,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Update the specified ExpressRouteCrossConnection.
     *
     * @param resourceGroupName The name of the resource group.
     * @param crossConnectionName The name of the ExpressRouteCrossConnection.
     * @param parameters Parameters supplied to the update express route crossConnection operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return expressRouteCrossConnection resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(
        String resourceGroupName,
        String crossConnectionName,
        ExpressRouteCrossConnectionInner parameters,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (crossConnectionName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter crossConnectionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String apiVersion = "2021-02-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .createOrUpdate(
                this.client.getEndpoint(),
                resourceGroupName,
                crossConnectionName,
                apiVersion,
                this.client.getSubscriptionId(),
                parameters,
                accept,
                context);
    }

    /**
     * Update the specified ExpressRouteCrossConnection.
     *
     * @param resourceGroupName The name of the resource group.
     * @param crossConnectionName The name of the ExpressRouteCrossConnection.
     * @param parameters Parameters supplied to the update express route crossConnection operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return expressRouteCrossConnection resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PollerFlux<PollResult<ExpressRouteCrossConnectionInner>, ExpressRouteCrossConnectionInner>
        beginCreateOrUpdateAsync(
            String resourceGroupName, String crossConnectionName, ExpressRouteCrossConnectionInner parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            createOrUpdateWithResponseAsync(resourceGroupName, crossConnectionName, parameters);
        return this
            .client
            .<ExpressRouteCrossConnectionInner, ExpressRouteCrossConnectionInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                ExpressRouteCrossConnectionInner.class,
                ExpressRouteCrossConnectionInner.class,
                Context.NONE);
    }

    /**
     * Update the specified ExpressRouteCrossConnection.
     *
     * @param resourceGroupName The name of the resource group.
     * @param crossConnectionName The name of the ExpressRouteCrossConnection.
     * @param parameters Parameters supplied to the update express route crossConnection operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return expressRouteCrossConnection resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private PollerFlux<PollResult<ExpressRouteCrossConnectionInner>, ExpressRouteCrossConnectionInner>
        beginCreateOrUpdateAsync(
            String resourceGroupName,
            String crossConnectionName,
            ExpressRouteCrossConnectionInner parameters,
            Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            createOrUpdateWithResponseAsync(resourceGroupName, crossConnectionName, parameters, context);
        return this
            .client
            .<ExpressRouteCrossConnectionInner, ExpressRouteCrossConnectionInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                ExpressRouteCrossConnectionInner.class,
                ExpressRouteCrossConnectionInner.class,
                context);
    }

    /**
     * Update the specified ExpressRouteCrossConnection.
     *
     * @param resourceGroupName The name of the resource group.
     * @param crossConnectionName The name of the ExpressRouteCrossConnection.
     * @param parameters Parameters supplied to the update express route crossConnection operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return expressRouteCrossConnection resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<ExpressRouteCrossConnectionInner>, ExpressRouteCrossConnectionInner>
        beginCreateOrUpdate(
            String resourceGroupName, String crossConnectionName, ExpressRouteCrossConnectionInner parameters) {
        return beginCreateOrUpdateAsync(resourceGroupName, crossConnectionName, parameters).getSyncPoller();
    }

    /**
     * Update the specified ExpressRouteCrossConnection.
     *
     * @param resourceGroupName The name of the resource group.
     * @param crossConnectionName The name of the ExpressRouteCrossConnection.
     * @param parameters Parameters supplied to the update express route crossConnection operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return expressRouteCrossConnection resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<ExpressRouteCrossConnectionInner>, ExpressRouteCrossConnectionInner>
        beginCreateOrUpdate(
            String resourceGroupName,
            String crossConnectionName,
            ExpressRouteCrossConnectionInner parameters,
            Context context) {
        return beginCreateOrUpdateAsync(resourceGroupName, crossConnectionName, parameters, context).getSyncPoller();
    }

    /**
     * Update the specified ExpressRouteCrossConnection.
     *
     * @param resourceGroupName The name of the resource group.
     * @param crossConnectionName The name of the ExpressRouteCrossConnection.
     * @param parameters Parameters supplied to the update express route crossConnection operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return expressRouteCrossConnection resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ExpressRouteCrossConnectionInner> createOrUpdateAsync(
        String resourceGroupName, String crossConnectionName, ExpressRouteCrossConnectionInner parameters) {
        return beginCreateOrUpdateAsync(resourceGroupName, crossConnectionName, parameters)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Update the specified ExpressRouteCrossConnection.
     *
     * @param resourceGroupName The name of the resource group.
     * @param crossConnectionName The name of the ExpressRouteCrossConnection.
     * @param parameters Parameters supplied to the update express route crossConnection operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return expressRouteCrossConnection resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<ExpressRouteCrossConnectionInner> createOrUpdateAsync(
        String resourceGroupName,
        String crossConnectionName,
        ExpressRouteCrossConnectionInner parameters,
        Context context) {
        return beginCreateOrUpdateAsync(resourceGroupName, crossConnectionName, parameters, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Update the specified ExpressRouteCrossConnection.
     *
     * @param resourceGroupName The name of the resource group.
     * @param crossConnectionName The name of the ExpressRouteCrossConnection.
     * @param parameters Parameters supplied to the update express route crossConnection operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return expressRouteCrossConnection resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ExpressRouteCrossConnectionInner createOrUpdate(
        String resourceGroupName, String crossConnectionName, ExpressRouteCrossConnectionInner parameters) {
        return createOrUpdateAsync(resourceGroupName, crossConnectionName, parameters).block();
    }

    /**
     * Update the specified ExpressRouteCrossConnection.
     *
     * @param resourceGroupName The name of the resource group.
     * @param crossConnectionName The name of the ExpressRouteCrossConnection.
     * @param parameters Parameters supplied to the update express route crossConnection operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return expressRouteCrossConnection resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ExpressRouteCrossConnectionInner createOrUpdate(
        String resourceGroupName,
        String crossConnectionName,
        ExpressRouteCrossConnectionInner parameters,
        Context context) {
        return createOrUpdateAsync(resourceGroupName, crossConnectionName, parameters, context).block();
    }

    /**
     * Updates an express route cross connection tags.
     *
     * @param resourceGroupName The name of the resource group.
     * @param crossConnectionName The name of the cross connection.
     * @param tags Resource tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return expressRouteCrossConnection resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<ExpressRouteCrossConnectionInner>> updateTagsWithResponseAsync(
        String resourceGroupName, String crossConnectionName, Map<String, String> tags) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (crossConnectionName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter crossConnectionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2021-02-01";
        final String accept = "application/json";
        TagsObject crossConnectionParameters = new TagsObject();
        crossConnectionParameters.withTags(tags);
        return FluxUtil
            .withContext(
                context ->
                    service
                        .updateTags(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            crossConnectionName,
                            apiVersion,
                            this.client.getSubscriptionId(),
                            crossConnectionParameters,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Updates an express route cross connection tags.
     *
     * @param resourceGroupName The name of the resource group.
     * @param crossConnectionName The name of the cross connection.
     * @param tags Resource tags.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return expressRouteCrossConnection resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<ExpressRouteCrossConnectionInner>> updateTagsWithResponseAsync(
        String resourceGroupName, String crossConnectionName, Map<String, String> tags, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (crossConnectionName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter crossConnectionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2021-02-01";
        final String accept = "application/json";
        TagsObject crossConnectionParameters = new TagsObject();
        crossConnectionParameters.withTags(tags);
        context = this.client.mergeContext(context);
        return service
            .updateTags(
                this.client.getEndpoint(),
                resourceGroupName,
                crossConnectionName,
                apiVersion,
                this.client.getSubscriptionId(),
                crossConnectionParameters,
                accept,
                context);
    }

    /**
     * Updates an express route cross connection tags.
     *
     * @param resourceGroupName The name of the resource group.
     * @param crossConnectionName The name of the cross connection.
     * @param tags Resource tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return expressRouteCrossConnection resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ExpressRouteCrossConnectionInner> updateTagsAsync(
        String resourceGroupName, String crossConnectionName, Map<String, String> tags) {
        return updateTagsWithResponseAsync(resourceGroupName, crossConnectionName, tags)
            .flatMap(
                (Response<ExpressRouteCrossConnectionInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Updates an express route cross connection tags.
     *
     * @param resourceGroupName The name of the resource group.
     * @param crossConnectionName The name of the cross connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return expressRouteCrossConnection resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ExpressRouteCrossConnectionInner> updateTagsAsync(
        String resourceGroupName, String crossConnectionName) {
        final Map<String, String> tags = null;
        return updateTagsWithResponseAsync(resourceGroupName, crossConnectionName, tags)
            .flatMap(
                (Response<ExpressRouteCrossConnectionInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Updates an express route cross connection tags.
     *
     * @param resourceGroupName The name of the resource group.
     * @param crossConnectionName The name of the cross connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return expressRouteCrossConnection resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ExpressRouteCrossConnectionInner updateTags(String resourceGroupName, String crossConnectionName) {
        final Map<String, String> tags = null;
        return updateTagsAsync(resourceGroupName, crossConnectionName, tags).block();
    }

    /**
     * Updates an express route cross connection tags.
     *
     * @param resourceGroupName The name of the resource group.
     * @param crossConnectionName The name of the cross connection.
     * @param tags Resource tags.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return expressRouteCrossConnection resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<ExpressRouteCrossConnectionInner> updateTagsWithResponse(
        String resourceGroupName, String crossConnectionName, Map<String, String> tags, Context context) {
        return updateTagsWithResponseAsync(resourceGroupName, crossConnectionName, tags, context).block();
    }

    /**
     * Gets the currently advertised ARP table associated with the express route cross connection in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param crossConnectionName The name of the ExpressRouteCrossConnection.
     * @param peeringName The name of the peering.
     * @param devicePath The path of the device.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the currently advertised ARP table associated with the express route cross connection in a resource
     *     group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> listArpTableWithResponseAsync(
        String resourceGroupName, String crossConnectionName, String peeringName, String devicePath) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (crossConnectionName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter crossConnectionName is required and cannot be null."));
        }
        if (peeringName == null) {
            return Mono.error(new IllegalArgumentException("Parameter peeringName is required and cannot be null."));
        }
        if (devicePath == null) {
            return Mono.error(new IllegalArgumentException("Parameter devicePath is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2021-02-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listArpTable(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            crossConnectionName,
                            peeringName,
                            devicePath,
                            apiVersion,
                            this.client.getSubscriptionId(),
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets the currently advertised ARP table associated with the express route cross connection in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param crossConnectionName The name of the ExpressRouteCrossConnection.
     * @param peeringName The name of the peering.
     * @param devicePath The path of the device.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the currently advertised ARP table associated with the express route cross connection in a resource
     *     group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> listArpTableWithResponseAsync(
        String resourceGroupName, String crossConnectionName, String peeringName, String devicePath, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (crossConnectionName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter crossConnectionName is required and cannot be null."));
        }
        if (peeringName == null) {
            return Mono.error(new IllegalArgumentException("Parameter peeringName is required and cannot be null."));
        }
        if (devicePath == null) {
            return Mono.error(new IllegalArgumentException("Parameter devicePath is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2021-02-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listArpTable(
                this.client.getEndpoint(),
                resourceGroupName,
                crossConnectionName,
                peeringName,
                devicePath,
                apiVersion,
                this.client.getSubscriptionId(),
                accept,
                context);
    }

    /**
     * Gets the currently advertised ARP table associated with the express route cross connection in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param crossConnectionName The name of the ExpressRouteCrossConnection.
     * @param peeringName The name of the peering.
     * @param devicePath The path of the device.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the currently advertised ARP table associated with the express route cross connection in a resource
     *     group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PollerFlux<
            PollResult<ExpressRouteCircuitsArpTableListResultInner>, ExpressRouteCircuitsArpTableListResultInner>
        beginListArpTableAsync(
            String resourceGroupName, String crossConnectionName, String peeringName, String devicePath) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            listArpTableWithResponseAsync(resourceGroupName, crossConnectionName, peeringName, devicePath);
        return this
            .client
            .<ExpressRouteCircuitsArpTableListResultInner, ExpressRouteCircuitsArpTableListResultInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                ExpressRouteCircuitsArpTableListResultInner.class,
                ExpressRouteCircuitsArpTableListResultInner.class,
                Context.NONE);
    }

    /**
     * Gets the currently advertised ARP table associated with the express route cross connection in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param crossConnectionName The name of the ExpressRouteCrossConnection.
     * @param peeringName The name of the peering.
     * @param devicePath The path of the device.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the currently advertised ARP table associated with the express route cross connection in a resource
     *     group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private PollerFlux<
            PollResult<ExpressRouteCircuitsArpTableListResultInner>, ExpressRouteCircuitsArpTableListResultInner>
        beginListArpTableAsync(
            String resourceGroupName,
            String crossConnectionName,
            String peeringName,
            String devicePath,
            Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            listArpTableWithResponseAsync(resourceGroupName, crossConnectionName, peeringName, devicePath, context);
        return this
            .client
            .<ExpressRouteCircuitsArpTableListResultInner, ExpressRouteCircuitsArpTableListResultInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                ExpressRouteCircuitsArpTableListResultInner.class,
                ExpressRouteCircuitsArpTableListResultInner.class,
                context);
    }

    /**
     * Gets the currently advertised ARP table associated with the express route cross connection in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param crossConnectionName The name of the ExpressRouteCrossConnection.
     * @param peeringName The name of the peering.
     * @param devicePath The path of the device.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the currently advertised ARP table associated with the express route cross connection in a resource
     *     group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<
            PollResult<ExpressRouteCircuitsArpTableListResultInner>, ExpressRouteCircuitsArpTableListResultInner>
        beginListArpTable(String resourceGroupName, String crossConnectionName, String peeringName, String devicePath) {
        return beginListArpTableAsync(resourceGroupName, crossConnectionName, peeringName, devicePath).getSyncPoller();
    }

    /**
     * Gets the currently advertised ARP table associated with the express route cross connection in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param crossConnectionName The name of the ExpressRouteCrossConnection.
     * @param peeringName The name of the peering.
     * @param devicePath The path of the device.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the currently advertised ARP table associated with the express route cross connection in a resource
     *     group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<
            PollResult<ExpressRouteCircuitsArpTableListResultInner>, ExpressRouteCircuitsArpTableListResultInner>
        beginListArpTable(
            String resourceGroupName,
            String crossConnectionName,
            String peeringName,
            String devicePath,
            Context context) {
        return beginListArpTableAsync(resourceGroupName, crossConnectionName, peeringName, devicePath, context)
            .getSyncPoller();
    }

    /**
     * Gets the currently advertised ARP table associated with the express route cross connection in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param crossConnectionName The name of the ExpressRouteCrossConnection.
     * @param peeringName The name of the peering.
     * @param devicePath The path of the device.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the currently advertised ARP table associated with the express route cross connection in a resource
     *     group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ExpressRouteCircuitsArpTableListResultInner> listArpTableAsync(
        String resourceGroupName, String crossConnectionName, String peeringName, String devicePath) {
        return beginListArpTableAsync(resourceGroupName, crossConnectionName, peeringName, devicePath)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Gets the currently advertised ARP table associated with the express route cross connection in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param crossConnectionName The name of the ExpressRouteCrossConnection.
     * @param peeringName The name of the peering.
     * @param devicePath The path of the device.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the currently advertised ARP table associated with the express route cross connection in a resource
     *     group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<ExpressRouteCircuitsArpTableListResultInner> listArpTableAsync(
        String resourceGroupName, String crossConnectionName, String peeringName, String devicePath, Context context) {
        return beginListArpTableAsync(resourceGroupName, crossConnectionName, peeringName, devicePath, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Gets the currently advertised ARP table associated with the express route cross connection in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param crossConnectionName The name of the ExpressRouteCrossConnection.
     * @param peeringName The name of the peering.
     * @param devicePath The path of the device.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the currently advertised ARP table associated with the express route cross connection in a resource
     *     group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ExpressRouteCircuitsArpTableListResultInner listArpTable(
        String resourceGroupName, String crossConnectionName, String peeringName, String devicePath) {
        return listArpTableAsync(resourceGroupName, crossConnectionName, peeringName, devicePath).block();
    }

    /**
     * Gets the currently advertised ARP table associated with the express route cross connection in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param crossConnectionName The name of the ExpressRouteCrossConnection.
     * @param peeringName The name of the peering.
     * @param devicePath The path of the device.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the currently advertised ARP table associated with the express route cross connection in a resource
     *     group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ExpressRouteCircuitsArpTableListResultInner listArpTable(
        String resourceGroupName, String crossConnectionName, String peeringName, String devicePath, Context context) {
        return listArpTableAsync(resourceGroupName, crossConnectionName, peeringName, devicePath, context).block();
    }

    /**
     * Gets the route table summary associated with the express route cross connection in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param crossConnectionName The name of the ExpressRouteCrossConnection.
     * @param peeringName The name of the peering.
     * @param devicePath The path of the device.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the route table summary associated with the express route cross connection in a resource group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> listRoutesTableSummaryWithResponseAsync(
        String resourceGroupName, String crossConnectionName, String peeringName, String devicePath) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (crossConnectionName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter crossConnectionName is required and cannot be null."));
        }
        if (peeringName == null) {
            return Mono.error(new IllegalArgumentException("Parameter peeringName is required and cannot be null."));
        }
        if (devicePath == null) {
            return Mono.error(new IllegalArgumentException("Parameter devicePath is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2021-02-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listRoutesTableSummary(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            crossConnectionName,
                            peeringName,
                            devicePath,
                            apiVersion,
                            this.client.getSubscriptionId(),
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets the route table summary associated with the express route cross connection in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param crossConnectionName The name of the ExpressRouteCrossConnection.
     * @param peeringName The name of the peering.
     * @param devicePath The path of the device.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the route table summary associated with the express route cross connection in a resource group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> listRoutesTableSummaryWithResponseAsync(
        String resourceGroupName, String crossConnectionName, String peeringName, String devicePath, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (crossConnectionName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter crossConnectionName is required and cannot be null."));
        }
        if (peeringName == null) {
            return Mono.error(new IllegalArgumentException("Parameter peeringName is required and cannot be null."));
        }
        if (devicePath == null) {
            return Mono.error(new IllegalArgumentException("Parameter devicePath is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2021-02-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listRoutesTableSummary(
                this.client.getEndpoint(),
                resourceGroupName,
                crossConnectionName,
                peeringName,
                devicePath,
                apiVersion,
                this.client.getSubscriptionId(),
                accept,
                context);
    }

    /**
     * Gets the route table summary associated with the express route cross connection in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param crossConnectionName The name of the ExpressRouteCrossConnection.
     * @param peeringName The name of the peering.
     * @param devicePath The path of the device.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the route table summary associated with the express route cross connection in a resource group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PollerFlux<
            PollResult<ExpressRouteCrossConnectionsRoutesTableSummaryListResultInner>,
            ExpressRouteCrossConnectionsRoutesTableSummaryListResultInner>
        beginListRoutesTableSummaryAsync(
            String resourceGroupName, String crossConnectionName, String peeringName, String devicePath) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            listRoutesTableSummaryWithResponseAsync(resourceGroupName, crossConnectionName, peeringName, devicePath);
        return this
            .client
            .<ExpressRouteCrossConnectionsRoutesTableSummaryListResultInner,
                ExpressRouteCrossConnectionsRoutesTableSummaryListResultInner>
                getLroResult(
                    mono,
                    this.client.getHttpPipeline(),
                    ExpressRouteCrossConnectionsRoutesTableSummaryListResultInner.class,
                    ExpressRouteCrossConnectionsRoutesTableSummaryListResultInner.class,
                    Context.NONE);
    }

    /**
     * Gets the route table summary associated with the express route cross connection in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param crossConnectionName The name of the ExpressRouteCrossConnection.
     * @param peeringName The name of the peering.
     * @param devicePath The path of the device.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the route table summary associated with the express route cross connection in a resource group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private PollerFlux<
            PollResult<ExpressRouteCrossConnectionsRoutesTableSummaryListResultInner>,
            ExpressRouteCrossConnectionsRoutesTableSummaryListResultInner>
        beginListRoutesTableSummaryAsync(
            String resourceGroupName,
            String crossConnectionName,
            String peeringName,
            String devicePath,
            Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            listRoutesTableSummaryWithResponseAsync(
                resourceGroupName, crossConnectionName, peeringName, devicePath, context);
        return this
            .client
            .<ExpressRouteCrossConnectionsRoutesTableSummaryListResultInner,
                ExpressRouteCrossConnectionsRoutesTableSummaryListResultInner>
                getLroResult(
                    mono,
                    this.client.getHttpPipeline(),
                    ExpressRouteCrossConnectionsRoutesTableSummaryListResultInner.class,
                    ExpressRouteCrossConnectionsRoutesTableSummaryListResultInner.class,
                    context);
    }

    /**
     * Gets the route table summary associated with the express route cross connection in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param crossConnectionName The name of the ExpressRouteCrossConnection.
     * @param peeringName The name of the peering.
     * @param devicePath The path of the device.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the route table summary associated with the express route cross connection in a resource group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<
            PollResult<ExpressRouteCrossConnectionsRoutesTableSummaryListResultInner>,
            ExpressRouteCrossConnectionsRoutesTableSummaryListResultInner>
        beginListRoutesTableSummary(
            String resourceGroupName, String crossConnectionName, String peeringName, String devicePath) {
        return beginListRoutesTableSummaryAsync(resourceGroupName, crossConnectionName, peeringName, devicePath)
            .getSyncPoller();
    }

    /**
     * Gets the route table summary associated with the express route cross connection in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param crossConnectionName The name of the ExpressRouteCrossConnection.
     * @param peeringName The name of the peering.
     * @param devicePath The path of the device.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the route table summary associated with the express route cross connection in a resource group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<
            PollResult<ExpressRouteCrossConnectionsRoutesTableSummaryListResultInner>,
            ExpressRouteCrossConnectionsRoutesTableSummaryListResultInner>
        beginListRoutesTableSummary(
            String resourceGroupName,
            String crossConnectionName,
            String peeringName,
            String devicePath,
            Context context) {
        return beginListRoutesTableSummaryAsync(
                resourceGroupName, crossConnectionName, peeringName, devicePath, context)
            .getSyncPoller();
    }

    /**
     * Gets the route table summary associated with the express route cross connection in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param crossConnectionName The name of the ExpressRouteCrossConnection.
     * @param peeringName The name of the peering.
     * @param devicePath The path of the device.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the route table summary associated with the express route cross connection in a resource group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ExpressRouteCrossConnectionsRoutesTableSummaryListResultInner> listRoutesTableSummaryAsync(
        String resourceGroupName, String crossConnectionName, String peeringName, String devicePath) {
        return beginListRoutesTableSummaryAsync(resourceGroupName, crossConnectionName, peeringName, devicePath)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Gets the route table summary associated with the express route cross connection in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param crossConnectionName The name of the ExpressRouteCrossConnection.
     * @param peeringName The name of the peering.
     * @param devicePath The path of the device.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the route table summary associated with the express route cross connection in a resource group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<ExpressRouteCrossConnectionsRoutesTableSummaryListResultInner> listRoutesTableSummaryAsync(
        String resourceGroupName, String crossConnectionName, String peeringName, String devicePath, Context context) {
        return beginListRoutesTableSummaryAsync(
                resourceGroupName, crossConnectionName, peeringName, devicePath, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Gets the route table summary associated with the express route cross connection in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param crossConnectionName The name of the ExpressRouteCrossConnection.
     * @param peeringName The name of the peering.
     * @param devicePath The path of the device.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the route table summary associated with the express route cross connection in a resource group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ExpressRouteCrossConnectionsRoutesTableSummaryListResultInner listRoutesTableSummary(
        String resourceGroupName, String crossConnectionName, String peeringName, String devicePath) {
        return listRoutesTableSummaryAsync(resourceGroupName, crossConnectionName, peeringName, devicePath).block();
    }

    /**
     * Gets the route table summary associated with the express route cross connection in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param crossConnectionName The name of the ExpressRouteCrossConnection.
     * @param peeringName The name of the peering.
     * @param devicePath The path of the device.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the route table summary associated with the express route cross connection in a resource group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ExpressRouteCrossConnectionsRoutesTableSummaryListResultInner listRoutesTableSummary(
        String resourceGroupName, String crossConnectionName, String peeringName, String devicePath, Context context) {
        return listRoutesTableSummaryAsync(resourceGroupName, crossConnectionName, peeringName, devicePath, context)
            .block();
    }

    /**
     * Gets the currently advertised routes table associated with the express route cross connection in a resource
     * group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param crossConnectionName The name of the ExpressRouteCrossConnection.
     * @param peeringName The name of the peering.
     * @param devicePath The path of the device.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the currently advertised routes table associated with the express route cross connection in a resource
     *     group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> listRoutesTableWithResponseAsync(
        String resourceGroupName, String crossConnectionName, String peeringName, String devicePath) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (crossConnectionName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter crossConnectionName is required and cannot be null."));
        }
        if (peeringName == null) {
            return Mono.error(new IllegalArgumentException("Parameter peeringName is required and cannot be null."));
        }
        if (devicePath == null) {
            return Mono.error(new IllegalArgumentException("Parameter devicePath is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2021-02-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listRoutesTable(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            crossConnectionName,
                            peeringName,
                            devicePath,
                            apiVersion,
                            this.client.getSubscriptionId(),
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets the currently advertised routes table associated with the express route cross connection in a resource
     * group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param crossConnectionName The name of the ExpressRouteCrossConnection.
     * @param peeringName The name of the peering.
     * @param devicePath The path of the device.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the currently advertised routes table associated with the express route cross connection in a resource
     *     group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> listRoutesTableWithResponseAsync(
        String resourceGroupName, String crossConnectionName, String peeringName, String devicePath, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (crossConnectionName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter crossConnectionName is required and cannot be null."));
        }
        if (peeringName == null) {
            return Mono.error(new IllegalArgumentException("Parameter peeringName is required and cannot be null."));
        }
        if (devicePath == null) {
            return Mono.error(new IllegalArgumentException("Parameter devicePath is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2021-02-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listRoutesTable(
                this.client.getEndpoint(),
                resourceGroupName,
                crossConnectionName,
                peeringName,
                devicePath,
                apiVersion,
                this.client.getSubscriptionId(),
                accept,
                context);
    }

    /**
     * Gets the currently advertised routes table associated with the express route cross connection in a resource
     * group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param crossConnectionName The name of the ExpressRouteCrossConnection.
     * @param peeringName The name of the peering.
     * @param devicePath The path of the device.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the currently advertised routes table associated with the express route cross connection in a resource
     *     group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PollerFlux<
            PollResult<ExpressRouteCircuitsRoutesTableListResultInner>, ExpressRouteCircuitsRoutesTableListResultInner>
        beginListRoutesTableAsync(
            String resourceGroupName, String crossConnectionName, String peeringName, String devicePath) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            listRoutesTableWithResponseAsync(resourceGroupName, crossConnectionName, peeringName, devicePath);
        return this
            .client
            .<ExpressRouteCircuitsRoutesTableListResultInner, ExpressRouteCircuitsRoutesTableListResultInner>
                getLroResult(
                    mono,
                    this.client.getHttpPipeline(),
                    ExpressRouteCircuitsRoutesTableListResultInner.class,
                    ExpressRouteCircuitsRoutesTableListResultInner.class,
                    Context.NONE);
    }

    /**
     * Gets the currently advertised routes table associated with the express route cross connection in a resource
     * group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param crossConnectionName The name of the ExpressRouteCrossConnection.
     * @param peeringName The name of the peering.
     * @param devicePath The path of the device.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the currently advertised routes table associated with the express route cross connection in a resource
     *     group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private PollerFlux<
            PollResult<ExpressRouteCircuitsRoutesTableListResultInner>, ExpressRouteCircuitsRoutesTableListResultInner>
        beginListRoutesTableAsync(
            String resourceGroupName,
            String crossConnectionName,
            String peeringName,
            String devicePath,
            Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            listRoutesTableWithResponseAsync(resourceGroupName, crossConnectionName, peeringName, devicePath, context);
        return this
            .client
            .<ExpressRouteCircuitsRoutesTableListResultInner, ExpressRouteCircuitsRoutesTableListResultInner>
                getLroResult(
                    mono,
                    this.client.getHttpPipeline(),
                    ExpressRouteCircuitsRoutesTableListResultInner.class,
                    ExpressRouteCircuitsRoutesTableListResultInner.class,
                    context);
    }

    /**
     * Gets the currently advertised routes table associated with the express route cross connection in a resource
     * group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param crossConnectionName The name of the ExpressRouteCrossConnection.
     * @param peeringName The name of the peering.
     * @param devicePath The path of the device.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the currently advertised routes table associated with the express route cross connection in a resource
     *     group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<
            PollResult<ExpressRouteCircuitsRoutesTableListResultInner>, ExpressRouteCircuitsRoutesTableListResultInner>
        beginListRoutesTable(
            String resourceGroupName, String crossConnectionName, String peeringName, String devicePath) {
        return beginListRoutesTableAsync(resourceGroupName, crossConnectionName, peeringName, devicePath)
            .getSyncPoller();
    }

    /**
     * Gets the currently advertised routes table associated with the express route cross connection in a resource
     * group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param crossConnectionName The name of the ExpressRouteCrossConnection.
     * @param peeringName The name of the peering.
     * @param devicePath The path of the device.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the currently advertised routes table associated with the express route cross connection in a resource
     *     group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<
            PollResult<ExpressRouteCircuitsRoutesTableListResultInner>, ExpressRouteCircuitsRoutesTableListResultInner>
        beginListRoutesTable(
            String resourceGroupName,
            String crossConnectionName,
            String peeringName,
            String devicePath,
            Context context) {
        return beginListRoutesTableAsync(resourceGroupName, crossConnectionName, peeringName, devicePath, context)
            .getSyncPoller();
    }

    /**
     * Gets the currently advertised routes table associated with the express route cross connection in a resource
     * group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param crossConnectionName The name of the ExpressRouteCrossConnection.
     * @param peeringName The name of the peering.
     * @param devicePath The path of the device.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the currently advertised routes table associated with the express route cross connection in a resource
     *     group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ExpressRouteCircuitsRoutesTableListResultInner> listRoutesTableAsync(
        String resourceGroupName, String crossConnectionName, String peeringName, String devicePath) {
        return beginListRoutesTableAsync(resourceGroupName, crossConnectionName, peeringName, devicePath)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Gets the currently advertised routes table associated with the express route cross connection in a resource
     * group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param crossConnectionName The name of the ExpressRouteCrossConnection.
     * @param peeringName The name of the peering.
     * @param devicePath The path of the device.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the currently advertised routes table associated with the express route cross connection in a resource
     *     group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<ExpressRouteCircuitsRoutesTableListResultInner> listRoutesTableAsync(
        String resourceGroupName, String crossConnectionName, String peeringName, String devicePath, Context context) {
        return beginListRoutesTableAsync(resourceGroupName, crossConnectionName, peeringName, devicePath, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Gets the currently advertised routes table associated with the express route cross connection in a resource
     * group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param crossConnectionName The name of the ExpressRouteCrossConnection.
     * @param peeringName The name of the peering.
     * @param devicePath The path of the device.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the currently advertised routes table associated with the express route cross connection in a resource
     *     group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ExpressRouteCircuitsRoutesTableListResultInner listRoutesTable(
        String resourceGroupName, String crossConnectionName, String peeringName, String devicePath) {
        return listRoutesTableAsync(resourceGroupName, crossConnectionName, peeringName, devicePath).block();
    }

    /**
     * Gets the currently advertised routes table associated with the express route cross connection in a resource
     * group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param crossConnectionName The name of the ExpressRouteCrossConnection.
     * @param peeringName The name of the peering.
     * @param devicePath The path of the device.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the currently advertised routes table associated with the express route cross connection in a resource
     *     group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ExpressRouteCircuitsRoutesTableListResultInner listRoutesTable(
        String resourceGroupName, String crossConnectionName, String peeringName, String devicePath, Context context) {
        return listRoutesTableAsync(resourceGroupName, crossConnectionName, peeringName, devicePath, context).block();
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response for ListExpressRouteCrossConnection API service call.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ExpressRouteCrossConnectionInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<ExpressRouteCrossConnectionInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response for ListExpressRouteCrossConnection API service call.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ExpressRouteCrossConnectionInner>> listNextSinglePageAsync(
        String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response for ListExpressRouteCrossConnection API service call.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ExpressRouteCrossConnectionInner>> listByResourceGroupNextSinglePageAsync(
        String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.listByResourceGroupNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<ExpressRouteCrossConnectionInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response for ListExpressRouteCrossConnection API service call.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ExpressRouteCrossConnectionInner>> listByResourceGroupNextSinglePageAsync(
        String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listByResourceGroupNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }
}
