// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** VIP swap request's frontend IP configuration object. */
@JsonFlatten
@Fluent
public class LoadBalancerVipSwapRequestFrontendIpConfiguration {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(LoadBalancerVipSwapRequestFrontendIpConfiguration.class);

    /*
     * The ID of frontend IP configuration resource.
     */
    @JsonProperty(value = "id")
    private String id;

    /*
     * A reference to public IP address resource.
     */
    @JsonProperty(value = "properties.publicIPAddress")
    private SubResource publicIpAddress;

    /**
     * Get the id property: The ID of frontend IP configuration resource.
     *
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: The ID of frontend IP configuration resource.
     *
     * @param id the id value to set.
     * @return the LoadBalancerVipSwapRequestFrontendIpConfiguration object itself.
     */
    public LoadBalancerVipSwapRequestFrontendIpConfiguration withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the publicIpAddress property: A reference to public IP address resource.
     *
     * @return the publicIpAddress value.
     */
    public SubResource publicIpAddress() {
        return this.publicIpAddress;
    }

    /**
     * Set the publicIpAddress property: A reference to public IP address resource.
     *
     * @param publicIpAddress the publicIpAddress value to set.
     * @return the LoadBalancerVipSwapRequestFrontendIpConfiguration object itself.
     */
    public LoadBalancerVipSwapRequestFrontendIpConfiguration withPublicIpAddress(SubResource publicIpAddress) {
        this.publicIpAddress = publicIpAddress;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
