/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.fluent.models.NetworkInterfaceIpConfigurationInner;
import com.azure.resourcemanager.network.models.GatewayLoadBalancerTunnelInterface;
import com.azure.resourcemanager.network.models.LoadBalancerBackendAddress;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

@JsonFlatten
public class BackendAddressPoolInner
extends SubResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(BackendAddressPoolInner.class);
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="type", access=JsonProperty.Access.WRITE_ONLY)
    private String type;
    @JsonProperty(value="properties.location")
    private String location;
    @JsonProperty(value="properties.tunnelInterfaces")
    private List<GatewayLoadBalancerTunnelInterface> tunnelInterfaces;
    @JsonProperty(value="properties.loadBalancerBackendAddresses")
    private List<LoadBalancerBackendAddress> loadBalancerBackendAddresses;
    @JsonProperty(value="properties.backendIPConfigurations", access=JsonProperty.Access.WRITE_ONLY)
    private List<NetworkInterfaceIpConfigurationInner> backendIpConfigurations;
    @JsonProperty(value="properties.loadBalancingRules", access=JsonProperty.Access.WRITE_ONLY)
    private List<SubResource> loadBalancingRules;
    @JsonProperty(value="properties.outboundRule", access=JsonProperty.Access.WRITE_ONLY)
    private SubResource outboundRule;
    @JsonProperty(value="properties.outboundRules", access=JsonProperty.Access.WRITE_ONLY)
    private List<SubResource> outboundRules;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;

    public String name() {
        return this.name;
    }

    public BackendAddressPoolInner withName(String name) {
        this.name = name;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public String type() {
        return this.type;
    }

    public String location() {
        return this.location;
    }

    public BackendAddressPoolInner withLocation(String location) {
        this.location = location;
        return this;
    }

    public List<GatewayLoadBalancerTunnelInterface> tunnelInterfaces() {
        return this.tunnelInterfaces;
    }

    public BackendAddressPoolInner withTunnelInterfaces(List<GatewayLoadBalancerTunnelInterface> tunnelInterfaces) {
        this.tunnelInterfaces = tunnelInterfaces;
        return this;
    }

    public List<LoadBalancerBackendAddress> loadBalancerBackendAddresses() {
        return this.loadBalancerBackendAddresses;
    }

    public BackendAddressPoolInner withLoadBalancerBackendAddresses(List<LoadBalancerBackendAddress> loadBalancerBackendAddresses) {
        this.loadBalancerBackendAddresses = loadBalancerBackendAddresses;
        return this;
    }

    public List<NetworkInterfaceIpConfigurationInner> backendIpConfigurations() {
        return this.backendIpConfigurations;
    }

    public List<SubResource> loadBalancingRules() {
        return this.loadBalancingRules;
    }

    public SubResource outboundRule() {
        return this.outboundRule;
    }

    public List<SubResource> outboundRules() {
        return this.outboundRules;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public BackendAddressPoolInner withId(String id) {
        super.withId(id);
        return this;
    }

    public void validate() {
        if (this.tunnelInterfaces() != null) {
            this.tunnelInterfaces().forEach(e -> e.validate());
        }
        if (this.loadBalancerBackendAddresses() != null) {
            this.loadBalancerBackendAddresses().forEach(e -> e.validate());
        }
        if (this.backendIpConfigurations() != null) {
            this.backendIpConfigurations().forEach(e -> e.validate());
        }
    }
}

