/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.PacketCaptureFilter;
import com.azure.resourcemanager.network.models.PacketCaptureStorageLocation;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

@JsonFlatten
public class PacketCaptureInner {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(PacketCaptureInner.class);
    @JsonProperty(value="properties.target", required=true)
    private String target;
    @JsonProperty(value="properties.bytesToCapturePerPacket")
    private Long bytesToCapturePerPacket;
    @JsonProperty(value="properties.totalBytesPerSession")
    private Long totalBytesPerSession;
    @JsonProperty(value="properties.timeLimitInSeconds")
    private Integer timeLimitInSeconds;
    @JsonProperty(value="properties.storageLocation", required=true)
    private PacketCaptureStorageLocation storageLocation;
    @JsonProperty(value="properties.filters")
    private List<PacketCaptureFilter> filters;

    public String target() {
        return this.target;
    }

    public PacketCaptureInner withTarget(String target) {
        this.target = target;
        return this;
    }

    public Long bytesToCapturePerPacket() {
        return this.bytesToCapturePerPacket;
    }

    public PacketCaptureInner withBytesToCapturePerPacket(Long bytesToCapturePerPacket) {
        this.bytesToCapturePerPacket = bytesToCapturePerPacket;
        return this;
    }

    public Long totalBytesPerSession() {
        return this.totalBytesPerSession;
    }

    public PacketCaptureInner withTotalBytesPerSession(Long totalBytesPerSession) {
        this.totalBytesPerSession = totalBytesPerSession;
        return this;
    }

    public Integer timeLimitInSeconds() {
        return this.timeLimitInSeconds;
    }

    public PacketCaptureInner withTimeLimitInSeconds(Integer timeLimitInSeconds) {
        this.timeLimitInSeconds = timeLimitInSeconds;
        return this;
    }

    public PacketCaptureStorageLocation storageLocation() {
        return this.storageLocation;
    }

    public PacketCaptureInner withStorageLocation(PacketCaptureStorageLocation storageLocation) {
        this.storageLocation = storageLocation;
        return this;
    }

    public List<PacketCaptureFilter> filters() {
        return this.filters;
    }

    public PacketCaptureInner withFilters(List<PacketCaptureFilter> filters) {
        this.filters = filters;
        return this;
    }

    public void validate() {
        if (this.target() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property target in model PacketCaptureInner"));
        }
        if (this.storageLocation() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property storageLocation in model PacketCaptureInner"));
        }
        this.storageLocation().validate();
        if (this.filters() != null) {
            this.filters().forEach(e -> e.validate());
        }
    }
}

