/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.Resource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.fluent.models.ExpressRouteCircuitPeeringInner;
import com.azure.resourcemanager.network.fluent.models.RouteFilterRuleInner;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

@JsonFlatten
public class RouteFilterInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(RouteFilterInner.class);
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="properties.rules")
    private List<RouteFilterRuleInner> rules;
    @JsonProperty(value="properties.peerings", access=JsonProperty.Access.WRITE_ONLY)
    private List<ExpressRouteCircuitPeeringInner> peerings;
    @JsonProperty(value="properties.ipv6Peerings", access=JsonProperty.Access.WRITE_ONLY)
    private List<ExpressRouteCircuitPeeringInner> ipv6Peerings;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="id")
    private String id;

    public String etag() {
        return this.etag;
    }

    public List<RouteFilterRuleInner> rules() {
        return this.rules;
    }

    public RouteFilterInner withRules(List<RouteFilterRuleInner> rules) {
        this.rules = rules;
        return this;
    }

    public List<ExpressRouteCircuitPeeringInner> peerings() {
        return this.peerings;
    }

    public List<ExpressRouteCircuitPeeringInner> ipv6Peerings() {
        return this.ipv6Peerings;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String id() {
        return this.id;
    }

    public RouteFilterInner withId(String id) {
        this.id = id;
        return this;
    }

    public RouteFilterInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public RouteFilterInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.rules() != null) {
            this.rules().forEach(e -> e.validate());
        }
        if (this.peerings() != null) {
            this.peerings().forEach(e -> e.validate());
        }
        if (this.ipv6Peerings() != null) {
            this.ipv6Peerings().forEach(e -> e.validate());
        }
    }
}

