/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.Resource;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.IpsecPolicy;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.TrafficSelectorPolicy;
import com.azure.resourcemanager.network.models.TunnelConnectionHealth;
import com.azure.resourcemanager.network.models.VirtualNetworkConnectionGatewayReference;
import com.azure.resourcemanager.network.models.VirtualNetworkGatewayConnectionMode;
import com.azure.resourcemanager.network.models.VirtualNetworkGatewayConnectionProtocol;
import com.azure.resourcemanager.network.models.VirtualNetworkGatewayConnectionStatus;
import com.azure.resourcemanager.network.models.VirtualNetworkGatewayConnectionType;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

@JsonFlatten
public class VirtualNetworkGatewayConnectionListEntityInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(VirtualNetworkGatewayConnectionListEntityInner.class);
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="properties.authorizationKey")
    private String authorizationKey;
    @JsonProperty(value="properties.virtualNetworkGateway1", required=true)
    private VirtualNetworkConnectionGatewayReference virtualNetworkGateway1;
    @JsonProperty(value="properties.virtualNetworkGateway2")
    private VirtualNetworkConnectionGatewayReference virtualNetworkGateway2;
    @JsonProperty(value="properties.localNetworkGateway2")
    private VirtualNetworkConnectionGatewayReference localNetworkGateway2;
    @JsonProperty(value="properties.connectionType", required=true)
    private VirtualNetworkGatewayConnectionType connectionType;
    @JsonProperty(value="properties.connectionProtocol")
    private VirtualNetworkGatewayConnectionProtocol connectionProtocol;
    @JsonProperty(value="properties.routingWeight")
    private Integer routingWeight;
    @JsonProperty(value="properties.connectionMode")
    private VirtualNetworkGatewayConnectionMode connectionMode;
    @JsonProperty(value="properties.sharedKey")
    private String sharedKey;
    @JsonProperty(value="properties.connectionStatus", access=JsonProperty.Access.WRITE_ONLY)
    private VirtualNetworkGatewayConnectionStatus connectionStatus;
    @JsonProperty(value="properties.tunnelConnectionStatus", access=JsonProperty.Access.WRITE_ONLY)
    private List<TunnelConnectionHealth> tunnelConnectionStatus;
    @JsonProperty(value="properties.egressBytesTransferred", access=JsonProperty.Access.WRITE_ONLY)
    private Long egressBytesTransferred;
    @JsonProperty(value="properties.ingressBytesTransferred", access=JsonProperty.Access.WRITE_ONLY)
    private Long ingressBytesTransferred;
    @JsonProperty(value="properties.peer")
    private SubResource peer;
    @JsonProperty(value="properties.enableBgp")
    private Boolean enableBgp;
    @JsonProperty(value="properties.usePolicyBasedTrafficSelectors")
    private Boolean usePolicyBasedTrafficSelectors;
    @JsonProperty(value="properties.ipsecPolicies")
    private List<IpsecPolicy> ipsecPolicies;
    @JsonProperty(value="properties.trafficSelectorPolicies")
    private List<TrafficSelectorPolicy> trafficSelectorPolicies;
    @JsonProperty(value="properties.resourceGuid", access=JsonProperty.Access.WRITE_ONLY)
    private String resourceGuid;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="properties.expressRouteGatewayBypass")
    private Boolean expressRouteGatewayBypass;
    @JsonProperty(value="id")
    private String id;

    public String etag() {
        return this.etag;
    }

    public String authorizationKey() {
        return this.authorizationKey;
    }

    public VirtualNetworkGatewayConnectionListEntityInner withAuthorizationKey(String authorizationKey) {
        this.authorizationKey = authorizationKey;
        return this;
    }

    public VirtualNetworkConnectionGatewayReference virtualNetworkGateway1() {
        return this.virtualNetworkGateway1;
    }

    public VirtualNetworkGatewayConnectionListEntityInner withVirtualNetworkGateway1(VirtualNetworkConnectionGatewayReference virtualNetworkGateway1) {
        this.virtualNetworkGateway1 = virtualNetworkGateway1;
        return this;
    }

    public VirtualNetworkConnectionGatewayReference virtualNetworkGateway2() {
        return this.virtualNetworkGateway2;
    }

    public VirtualNetworkGatewayConnectionListEntityInner withVirtualNetworkGateway2(VirtualNetworkConnectionGatewayReference virtualNetworkGateway2) {
        this.virtualNetworkGateway2 = virtualNetworkGateway2;
        return this;
    }

    public VirtualNetworkConnectionGatewayReference localNetworkGateway2() {
        return this.localNetworkGateway2;
    }

    public VirtualNetworkGatewayConnectionListEntityInner withLocalNetworkGateway2(VirtualNetworkConnectionGatewayReference localNetworkGateway2) {
        this.localNetworkGateway2 = localNetworkGateway2;
        return this;
    }

    public VirtualNetworkGatewayConnectionType connectionType() {
        return this.connectionType;
    }

    public VirtualNetworkGatewayConnectionListEntityInner withConnectionType(VirtualNetworkGatewayConnectionType connectionType) {
        this.connectionType = connectionType;
        return this;
    }

    public VirtualNetworkGatewayConnectionProtocol connectionProtocol() {
        return this.connectionProtocol;
    }

    public VirtualNetworkGatewayConnectionListEntityInner withConnectionProtocol(VirtualNetworkGatewayConnectionProtocol connectionProtocol) {
        this.connectionProtocol = connectionProtocol;
        return this;
    }

    public Integer routingWeight() {
        return this.routingWeight;
    }

    public VirtualNetworkGatewayConnectionListEntityInner withRoutingWeight(Integer routingWeight) {
        this.routingWeight = routingWeight;
        return this;
    }

    public VirtualNetworkGatewayConnectionMode connectionMode() {
        return this.connectionMode;
    }

    public VirtualNetworkGatewayConnectionListEntityInner withConnectionMode(VirtualNetworkGatewayConnectionMode connectionMode) {
        this.connectionMode = connectionMode;
        return this;
    }

    public String sharedKey() {
        return this.sharedKey;
    }

    public VirtualNetworkGatewayConnectionListEntityInner withSharedKey(String sharedKey) {
        this.sharedKey = sharedKey;
        return this;
    }

    public VirtualNetworkGatewayConnectionStatus connectionStatus() {
        return this.connectionStatus;
    }

    public List<TunnelConnectionHealth> tunnelConnectionStatus() {
        return this.tunnelConnectionStatus;
    }

    public Long egressBytesTransferred() {
        return this.egressBytesTransferred;
    }

    public Long ingressBytesTransferred() {
        return this.ingressBytesTransferred;
    }

    public SubResource peer() {
        return this.peer;
    }

    public VirtualNetworkGatewayConnectionListEntityInner withPeer(SubResource peer) {
        this.peer = peer;
        return this;
    }

    public Boolean enableBgp() {
        return this.enableBgp;
    }

    public VirtualNetworkGatewayConnectionListEntityInner withEnableBgp(Boolean enableBgp) {
        this.enableBgp = enableBgp;
        return this;
    }

    public Boolean usePolicyBasedTrafficSelectors() {
        return this.usePolicyBasedTrafficSelectors;
    }

    public VirtualNetworkGatewayConnectionListEntityInner withUsePolicyBasedTrafficSelectors(Boolean usePolicyBasedTrafficSelectors) {
        this.usePolicyBasedTrafficSelectors = usePolicyBasedTrafficSelectors;
        return this;
    }

    public List<IpsecPolicy> ipsecPolicies() {
        return this.ipsecPolicies;
    }

    public VirtualNetworkGatewayConnectionListEntityInner withIpsecPolicies(List<IpsecPolicy> ipsecPolicies) {
        this.ipsecPolicies = ipsecPolicies;
        return this;
    }

    public List<TrafficSelectorPolicy> trafficSelectorPolicies() {
        return this.trafficSelectorPolicies;
    }

    public VirtualNetworkGatewayConnectionListEntityInner withTrafficSelectorPolicies(List<TrafficSelectorPolicy> trafficSelectorPolicies) {
        this.trafficSelectorPolicies = trafficSelectorPolicies;
        return this;
    }

    public String resourceGuid() {
        return this.resourceGuid;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public Boolean expressRouteGatewayBypass() {
        return this.expressRouteGatewayBypass;
    }

    public VirtualNetworkGatewayConnectionListEntityInner withExpressRouteGatewayBypass(Boolean expressRouteGatewayBypass) {
        this.expressRouteGatewayBypass = expressRouteGatewayBypass;
        return this;
    }

    public String id() {
        return this.id;
    }

    public VirtualNetworkGatewayConnectionListEntityInner withId(String id) {
        this.id = id;
        return this;
    }

    public VirtualNetworkGatewayConnectionListEntityInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public VirtualNetworkGatewayConnectionListEntityInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.virtualNetworkGateway1() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property virtualNetworkGateway1 in model VirtualNetworkGatewayConnectionListEntityInner"));
        }
        this.virtualNetworkGateway1().validate();
        if (this.virtualNetworkGateway2() != null) {
            this.virtualNetworkGateway2().validate();
        }
        if (this.localNetworkGateway2() != null) {
            this.localNetworkGateway2().validate();
        }
        if (this.connectionType() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property connectionType in model VirtualNetworkGatewayConnectionListEntityInner"));
        }
        if (this.tunnelConnectionStatus() != null) {
            this.tunnelConnectionStatus().forEach(e -> e.validate());
        }
        if (this.ipsecPolicies() != null) {
            this.ipsecPolicies().forEach(e -> e.validate());
        }
        if (this.trafficSelectorPolicies() != null) {
            this.trafficSelectorPolicies().forEach(e -> e.validate());
        }
    }
}

