/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.Resource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.fluent.models.FrontendIpConfigurationInner;
import com.azure.resourcemanager.network.fluent.models.NetworkInterfaceIpConfigurationInner;
import com.azure.resourcemanager.network.fluent.models.NetworkInterfaceTapConfigurationInner;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

@JsonFlatten
public class VirtualNetworkTapInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(VirtualNetworkTapInner.class);
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="properties.networkInterfaceTapConfigurations", access=JsonProperty.Access.WRITE_ONLY)
    private List<NetworkInterfaceTapConfigurationInner> networkInterfaceTapConfigurations;
    @JsonProperty(value="properties.resourceGuid", access=JsonProperty.Access.WRITE_ONLY)
    private String resourceGuid;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="properties.destinationNetworkInterfaceIPConfiguration")
    private NetworkInterfaceIpConfigurationInner destinationNetworkInterfaceIpConfiguration;
    @JsonProperty(value="properties.destinationLoadBalancerFrontEndIPConfiguration")
    private FrontendIpConfigurationInner destinationLoadBalancerFrontEndIpConfiguration;
    @JsonProperty(value="properties.destinationPort")
    private Integer destinationPort;
    @JsonProperty(value="id")
    private String id;

    public String etag() {
        return this.etag;
    }

    public List<NetworkInterfaceTapConfigurationInner> networkInterfaceTapConfigurations() {
        return this.networkInterfaceTapConfigurations;
    }

    public String resourceGuid() {
        return this.resourceGuid;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public NetworkInterfaceIpConfigurationInner destinationNetworkInterfaceIpConfiguration() {
        return this.destinationNetworkInterfaceIpConfiguration;
    }

    public VirtualNetworkTapInner withDestinationNetworkInterfaceIpConfiguration(NetworkInterfaceIpConfigurationInner destinationNetworkInterfaceIpConfiguration) {
        this.destinationNetworkInterfaceIpConfiguration = destinationNetworkInterfaceIpConfiguration;
        return this;
    }

    public FrontendIpConfigurationInner destinationLoadBalancerFrontEndIpConfiguration() {
        return this.destinationLoadBalancerFrontEndIpConfiguration;
    }

    public VirtualNetworkTapInner withDestinationLoadBalancerFrontEndIpConfiguration(FrontendIpConfigurationInner destinationLoadBalancerFrontEndIpConfiguration) {
        this.destinationLoadBalancerFrontEndIpConfiguration = destinationLoadBalancerFrontEndIpConfiguration;
        return this;
    }

    public Integer destinationPort() {
        return this.destinationPort;
    }

    public VirtualNetworkTapInner withDestinationPort(Integer destinationPort) {
        this.destinationPort = destinationPort;
        return this;
    }

    public String id() {
        return this.id;
    }

    public VirtualNetworkTapInner withId(String id) {
        this.id = id;
        return this;
    }

    public VirtualNetworkTapInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public VirtualNetworkTapInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.networkInterfaceTapConfigurations() != null) {
            this.networkInterfaceTapConfigurations().forEach(e -> e.validate());
        }
        if (this.destinationNetworkInterfaceIpConfiguration() != null) {
            this.destinationNetworkInterfaceIpConfiguration().validate();
        }
        if (this.destinationLoadBalancerFrontEndIpConfiguration() != null) {
            this.destinationLoadBalancerFrontEndIpConfiguration().validate();
        }
    }
}

