/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.Resource;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.fluent.models.VpnConnectionInner;
import com.azure.resourcemanager.network.fluent.models.VpnGatewayNatRuleInner;
import com.azure.resourcemanager.network.models.BgpSettings;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.VpnGatewayIpConfiguration;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

@JsonFlatten
public class VpnGatewayInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(VpnGatewayInner.class);
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="properties.virtualHub")
    private SubResource virtualHub;
    @JsonProperty(value="properties.connections")
    private List<VpnConnectionInner> connections;
    @JsonProperty(value="properties.bgpSettings")
    private BgpSettings bgpSettings;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="properties.vpnGatewayScaleUnit")
    private Integer vpnGatewayScaleUnit;
    @JsonProperty(value="properties.ipConfigurations", access=JsonProperty.Access.WRITE_ONLY)
    private List<VpnGatewayIpConfiguration> ipConfigurations;
    @JsonProperty(value="properties.isRoutingPreferenceInternet")
    private Boolean isRoutingPreferenceInternet;
    @JsonProperty(value="properties.natRules")
    private List<VpnGatewayNatRuleInner> natRules;
    @JsonProperty(value="id")
    private String id;

    public String etag() {
        return this.etag;
    }

    public SubResource virtualHub() {
        return this.virtualHub;
    }

    public VpnGatewayInner withVirtualHub(SubResource virtualHub) {
        this.virtualHub = virtualHub;
        return this;
    }

    public List<VpnConnectionInner> connections() {
        return this.connections;
    }

    public VpnGatewayInner withConnections(List<VpnConnectionInner> connections) {
        this.connections = connections;
        return this;
    }

    public BgpSettings bgpSettings() {
        return this.bgpSettings;
    }

    public VpnGatewayInner withBgpSettings(BgpSettings bgpSettings) {
        this.bgpSettings = bgpSettings;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public Integer vpnGatewayScaleUnit() {
        return this.vpnGatewayScaleUnit;
    }

    public VpnGatewayInner withVpnGatewayScaleUnit(Integer vpnGatewayScaleUnit) {
        this.vpnGatewayScaleUnit = vpnGatewayScaleUnit;
        return this;
    }

    public List<VpnGatewayIpConfiguration> ipConfigurations() {
        return this.ipConfigurations;
    }

    public Boolean isRoutingPreferenceInternet() {
        return this.isRoutingPreferenceInternet;
    }

    public VpnGatewayInner withIsRoutingPreferenceInternet(Boolean isRoutingPreferenceInternet) {
        this.isRoutingPreferenceInternet = isRoutingPreferenceInternet;
        return this;
    }

    public List<VpnGatewayNatRuleInner> natRules() {
        return this.natRules;
    }

    public VpnGatewayInner withNatRules(List<VpnGatewayNatRuleInner> natRules) {
        this.natRules = natRules;
        return this;
    }

    public String id() {
        return this.id;
    }

    public VpnGatewayInner withId(String id) {
        this.id = id;
        return this;
    }

    public VpnGatewayInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public VpnGatewayInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.connections() != null) {
            this.connections().forEach(e -> e.validate());
        }
        if (this.bgpSettings() != null) {
            this.bgpSettings().validate();
        }
        if (this.ipConfigurations() != null) {
            this.ipConfigurations().forEach(e -> e.validate());
        }
        if (this.natRules() != null) {
            this.natRules().forEach(e -> e.validate());
        }
    }
}

