/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.core.management.SubResource;
import com.azure.resourcemanager.network.NetworkManager;
import com.azure.resourcemanager.network.fluent.models.FrontendIpConfigurationInner;
import com.azure.resourcemanager.network.fluent.models.PublicIpAddressInner;
import com.azure.resourcemanager.network.fluent.models.SubnetInner;
import com.azure.resourcemanager.network.implementation.LoadBalancerImpl;
import com.azure.resourcemanager.network.implementation.Utils;
import com.azure.resourcemanager.network.models.IpAllocationMethod;
import com.azure.resourcemanager.network.models.LoadBalancer;
import com.azure.resourcemanager.network.models.LoadBalancerFrontend;
import com.azure.resourcemanager.network.models.LoadBalancerInboundNatPool;
import com.azure.resourcemanager.network.models.LoadBalancerInboundNatRule;
import com.azure.resourcemanager.network.models.LoadBalancerPrivateFrontend;
import com.azure.resourcemanager.network.models.LoadBalancerPublicFrontend;
import com.azure.resourcemanager.network.models.LoadBalancingRule;
import com.azure.resourcemanager.network.models.Network;
import com.azure.resourcemanager.network.models.PublicIpAddress;
import com.azure.resourcemanager.network.models.Subnet;
import com.azure.resourcemanager.resources.fluentcore.arm.AvailabilityZoneId;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ChildResourceImpl;
import com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import reactor.core.publisher.Mono;

class LoadBalancerFrontendImpl
extends ChildResourceImpl<FrontendIpConfigurationInner, LoadBalancerImpl, LoadBalancer>
implements LoadBalancerFrontend,
LoadBalancerPrivateFrontend,
LoadBalancerPrivateFrontend.Definition<LoadBalancer.DefinitionStages.WithCreate>,
LoadBalancerPrivateFrontend.UpdateDefinition<LoadBalancer.Update>,
LoadBalancerPrivateFrontend.Update,
LoadBalancerPublicFrontend,
LoadBalancerPublicFrontend.Definition<LoadBalancer.DefinitionStages.WithCreate>,
LoadBalancerPublicFrontend.UpdateDefinition<LoadBalancer.Update>,
LoadBalancerPublicFrontend.Update {
    LoadBalancerFrontendImpl(FrontendIpConfigurationInner inner, LoadBalancerImpl parent) {
        super((Object)inner, (Object)parent);
    }

    public String networkId() {
        SubnetInner subnetRef = ((FrontendIpConfigurationInner)((Object)this.innerModel())).subnet();
        if (subnetRef != null) {
            return ResourceUtils.parentResourceIdFromResourceId((String)subnetRef.id());
        }
        return null;
    }

    public String subnetName() {
        SubnetInner subnetRef = ((FrontendIpConfigurationInner)((Object)this.innerModel())).subnet();
        if (subnetRef != null) {
            return ResourceUtils.nameFromResourceId((String)subnetRef.id());
        }
        return null;
    }

    @Override
    public String privateIpAddress() {
        return ((FrontendIpConfigurationInner)((Object)this.innerModel())).privateIpAddress();
    }

    @Override
    public IpAllocationMethod privateIpAllocationMethod() {
        return ((FrontendIpConfigurationInner)((Object)this.innerModel())).privateIpAllocationMethod();
    }

    public String name() {
        return ((FrontendIpConfigurationInner)((Object)this.innerModel())).name();
    }

    @Override
    public String publicIpAddressId() {
        return ((FrontendIpConfigurationInner)((Object)this.innerModel())).publicIpAddress().id();
    }

    @Override
    public boolean isPublic() {
        return ((FrontendIpConfigurationInner)((Object)this.innerModel())).publicIpAddress() != null;
    }

    @Override
    public Map<String, LoadBalancingRule> loadBalancingRules() {
        TreeMap<String, LoadBalancingRule> rules = new TreeMap<String, LoadBalancingRule>();
        if (((FrontendIpConfigurationInner)((Object)this.innerModel())).loadBalancingRules() != null) {
            for (SubResource innerRef : ((FrontendIpConfigurationInner)((Object)this.innerModel())).loadBalancingRules()) {
                String name = ResourceUtils.nameFromResourceId((String)innerRef.id());
                LoadBalancingRule rule = ((LoadBalancerImpl)this.parent()).loadBalancingRules().get(name);
                if (rule == null) continue;
                rules.put(name, rule);
            }
        }
        return Collections.unmodifiableMap(rules);
    }

    @Override
    public Map<String, LoadBalancerInboundNatPool> inboundNatPools() {
        TreeMap<String, LoadBalancerInboundNatPool> pools = new TreeMap<String, LoadBalancerInboundNatPool>();
        if (((FrontendIpConfigurationInner)((Object)this.innerModel())).inboundNatPools() != null) {
            for (SubResource innerRef : ((FrontendIpConfigurationInner)((Object)this.innerModel())).inboundNatPools()) {
                String name = ResourceUtils.nameFromResourceId((String)innerRef.id());
                LoadBalancerInboundNatPool pool = ((LoadBalancerImpl)this.parent()).inboundNatPools().get(name);
                if (pool == null) continue;
                pools.put(name, pool);
            }
        }
        return Collections.unmodifiableMap(pools);
    }

    @Override
    public Map<String, LoadBalancerInboundNatRule> inboundNatRules() {
        TreeMap<String, LoadBalancerInboundNatRule> rules = new TreeMap<String, LoadBalancerInboundNatRule>();
        if (((FrontendIpConfigurationInner)((Object)this.innerModel())).inboundNatRules() != null) {
            for (SubResource innerRef : ((FrontendIpConfigurationInner)((Object)this.innerModel())).inboundNatRules()) {
                String name = ResourceUtils.nameFromResourceId((String)innerRef.id());
                LoadBalancerInboundNatRule rule = ((LoadBalancerImpl)this.parent()).inboundNatRules().get(name);
                if (rule == null) continue;
                rules.put(name, rule);
            }
        }
        return Collections.unmodifiableMap(rules);
    }

    @Override
    public LoadBalancerFrontendImpl withExistingSubnet(Network network, String subnetName) {
        return this.withExistingSubnet(network.id(), subnetName);
    }

    public LoadBalancerFrontendImpl withExistingSubnet(String parentNetworkResourceId, String subnetName) {
        SubnetInner subnetRef = new SubnetInner();
        subnetRef.withId(parentNetworkResourceId + "/subnets/" + subnetName);
        ((FrontendIpConfigurationInner)((Object)this.innerModel())).withSubnet(subnetRef).withPublicIpAddress(null);
        return this;
    }

    public LoadBalancerFrontendImpl withAvailabilityZone(AvailabilityZoneId zoneId) {
        if (((FrontendIpConfigurationInner)((Object)this.innerModel())).zones() == null) {
            ((FrontendIpConfigurationInner)((Object)this.innerModel())).withZones(new ArrayList<String>());
        }
        ((FrontendIpConfigurationInner)((Object)this.innerModel())).zones().add(zoneId.toString());
        return this;
    }

    @Override
    public LoadBalancerFrontendImpl withExistingPublicIpAddress(PublicIpAddress pip) {
        return this.withExistingPublicIpAddress(pip.id());
    }

    @Override
    public LoadBalancerFrontendImpl withExistingPublicIpAddress(String resourceId) {
        PublicIpAddressInner pipRef = new PublicIpAddressInner().withId(resourceId);
        ((FrontendIpConfigurationInner)((Object)this.innerModel())).withPublicIpAddress(pipRef).withSubnet(null).withPrivateIpAddress(null).withPrivateIpAllocationMethod(null);
        return this;
    }

    @Override
    public LoadBalancerFrontendImpl withoutPublicIpAddress() {
        ((FrontendIpConfigurationInner)((Object)this.innerModel())).withPublicIpAddress(null);
        return this;
    }

    @Override
    public LoadBalancerFrontendImpl withPrivateIpAddressDynamic() {
        ((FrontendIpConfigurationInner)((Object)this.innerModel())).withPrivateIpAddress(null).withPrivateIpAllocationMethod(IpAllocationMethod.DYNAMIC).withPublicIpAddress(null);
        return this;
    }

    @Override
    public LoadBalancerFrontendImpl withPrivateIpAddressStatic(String ipAddress) {
        ((FrontendIpConfigurationInner)((Object)this.innerModel())).withPrivateIpAddress(ipAddress).withPrivateIpAllocationMethod(IpAllocationMethod.STATIC).withPublicIpAddress(null);
        return this;
    }

    @Override
    public LoadBalancerFrontendImpl withNewPublicIpAddress(String leafDnsLabel) {
        ((LoadBalancerImpl)this.parent()).withNewPublicIPAddress(leafDnsLabel, this.name());
        return this;
    }

    @Override
    public LoadBalancerFrontendImpl withNewPublicIpAddress(Creatable<PublicIpAddress> creatable) {
        ((LoadBalancerImpl)this.parent()).withNewPublicIPAddress(creatable, this.name());
        return this;
    }

    @Override
    public LoadBalancerFrontendImpl withNewPublicIpAddress() {
        String dnsLabel = ((NetworkManager)((LoadBalancerImpl)this.parent()).manager()).resourceManager().internalContext().randomResourceName("fe", 20);
        return this.withNewPublicIpAddress(dnsLabel);
    }

    public LoadBalancerImpl attach() {
        return ((LoadBalancerImpl)this.parent()).withFrontend(this);
    }

    @Override
    public PublicIpAddress getPublicIpAddress() {
        return (PublicIpAddress)this.getPublicIpAddressAsync().block();
    }

    @Override
    public Mono<PublicIpAddress> getPublicIpAddressAsync() {
        String pipId = this.publicIpAddressId();
        return pipId == null ? Mono.empty() : ((NetworkManager)((LoadBalancerImpl)this.parent()).manager()).publicIpAddresses().getByIdAsync(pipId);
    }

    @Override
    public Subnet getSubnet() {
        return Utils.getAssociatedSubnet((NetworkManager)((LoadBalancerImpl)this.parent()).manager(), ((FrontendIpConfigurationInner)((Object)this.innerModel())).subnet());
    }

    @Override
    public Set<AvailabilityZoneId> availabilityZones() {
        HashSet<AvailabilityZoneId> zones = new HashSet<AvailabilityZoneId>();
        if (((FrontendIpConfigurationInner)((Object)this.innerModel())).zones() != null) {
            for (String zone : ((FrontendIpConfigurationInner)((Object)this.innerModel())).zones()) {
                zones.add(AvailabilityZoneId.fromString((String)zone));
            }
        }
        return Collections.unmodifiableSet(zones);
    }
}

