/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.AzureFirewallApplicationRule;
import com.azure.resourcemanager.network.models.AzureFirewallRCAction;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class AzureFirewallApplicationRuleCollectionPropertiesFormat {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(AzureFirewallApplicationRuleCollectionPropertiesFormat.class);
    @JsonProperty(value="priority")
    private Integer priority;
    @JsonProperty(value="action")
    private AzureFirewallRCAction action;
    @JsonProperty(value="rules")
    private List<AzureFirewallApplicationRule> rules;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;

    public Integer priority() {
        return this.priority;
    }

    public AzureFirewallApplicationRuleCollectionPropertiesFormat withPriority(Integer priority) {
        this.priority = priority;
        return this;
    }

    public AzureFirewallRCAction action() {
        return this.action;
    }

    public AzureFirewallApplicationRuleCollectionPropertiesFormat withAction(AzureFirewallRCAction action) {
        this.action = action;
        return this;
    }

    public List<AzureFirewallApplicationRule> rules() {
        return this.rules;
    }

    public AzureFirewallApplicationRuleCollectionPropertiesFormat withRules(List<AzureFirewallApplicationRule> rules) {
        this.rules = rules;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.action() != null) {
            this.action().validate();
        }
        if (this.rules() != null) {
            this.rules().forEach(e -> e.validate());
        }
    }
}

