/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.fluent.models.FlowLogProperties;
import com.azure.resourcemanager.network.models.FlowLogFormatParameters;
import com.azure.resourcemanager.network.models.RetentionPolicyParameters;
import com.azure.resourcemanager.network.models.TrafficAnalyticsProperties;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class FlowLogInformationInner {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(FlowLogInformationInner.class);
    @JsonProperty(value="targetResourceId", required=true)
    private String targetResourceId;
    @JsonProperty(value="properties", required=true)
    private FlowLogProperties innerProperties = new FlowLogProperties();
    @JsonProperty(value="flowAnalyticsConfiguration")
    private TrafficAnalyticsProperties flowAnalyticsConfiguration;

    public String targetResourceId() {
        return this.targetResourceId;
    }

    public FlowLogInformationInner withTargetResourceId(String targetResourceId) {
        this.targetResourceId = targetResourceId;
        return this;
    }

    private FlowLogProperties innerProperties() {
        return this.innerProperties;
    }

    public TrafficAnalyticsProperties flowAnalyticsConfiguration() {
        return this.flowAnalyticsConfiguration;
    }

    public FlowLogInformationInner withFlowAnalyticsConfiguration(TrafficAnalyticsProperties flowAnalyticsConfiguration) {
        this.flowAnalyticsConfiguration = flowAnalyticsConfiguration;
        return this;
    }

    public String storageId() {
        return this.innerProperties() == null ? null : this.innerProperties().storageId();
    }

    public FlowLogInformationInner withStorageId(String storageId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FlowLogProperties();
        }
        this.innerProperties().withStorageId(storageId);
        return this;
    }

    public boolean enabled() {
        return this.innerProperties() == null ? false : this.innerProperties().enabled();
    }

    public FlowLogInformationInner withEnabled(boolean enabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FlowLogProperties();
        }
        this.innerProperties().withEnabled(enabled);
        return this;
    }

    public RetentionPolicyParameters retentionPolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().retentionPolicy();
    }

    public FlowLogInformationInner withRetentionPolicy(RetentionPolicyParameters retentionPolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FlowLogProperties();
        }
        this.innerProperties().withRetentionPolicy(retentionPolicy);
        return this;
    }

    public FlowLogFormatParameters format() {
        return this.innerProperties() == null ? null : this.innerProperties().format();
    }

    public FlowLogInformationInner withFormat(FlowLogFormatParameters format) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FlowLogProperties();
        }
        this.innerProperties().withFormat(format);
        return this;
    }

    public void validate() {
        if (this.targetResourceId() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property targetResourceId in model FlowLogInformationInner"));
        }
        if (this.innerProperties() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model FlowLogInformationInner"));
        }
        this.innerProperties().validate();
        if (this.flowAnalyticsConfiguration() != null) {
            this.flowAnalyticsConfiguration().validate();
        }
    }
}

