/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.fluent.models.FlowLogInner;
import com.azure.resourcemanager.network.fluent.models.NetworkInterfaceInner;
import com.azure.resourcemanager.network.fluent.models.NetworkSecurityGroupPropertiesFormat;
import com.azure.resourcemanager.network.fluent.models.SecurityRuleInner;
import com.azure.resourcemanager.network.fluent.models.SubnetInner;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

public final class NetworkSecurityGroupInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(NetworkSecurityGroupInner.class);
    @JsonProperty(value="properties")
    private NetworkSecurityGroupPropertiesFormat innerProperties;
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="id")
    private String id;

    private NetworkSecurityGroupPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    public String etag() {
        return this.etag;
    }

    public String id() {
        return this.id;
    }

    public NetworkSecurityGroupInner withId(String id) {
        this.id = id;
        return this;
    }

    public NetworkSecurityGroupInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public NetworkSecurityGroupInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public List<SecurityRuleInner> securityRules() {
        return this.innerProperties() == null ? null : this.innerProperties().securityRules();
    }

    public NetworkSecurityGroupInner withSecurityRules(List<SecurityRuleInner> securityRules) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NetworkSecurityGroupPropertiesFormat();
        }
        this.innerProperties().withSecurityRules(securityRules);
        return this;
    }

    public List<SecurityRuleInner> defaultSecurityRules() {
        return this.innerProperties() == null ? null : this.innerProperties().defaultSecurityRules();
    }

    public List<NetworkInterfaceInner> networkInterfaces() {
        return this.innerProperties() == null ? null : this.innerProperties().networkInterfaces();
    }

    public List<SubnetInner> subnets() {
        return this.innerProperties() == null ? null : this.innerProperties().subnets();
    }

    public List<FlowLogInner> flowLogs() {
        return this.innerProperties() == null ? null : this.innerProperties().flowLogs();
    }

    public String resourceGuid() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceGuid();
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

