/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.fluent.models.VpnSiteLinkInner;
import com.azure.resourcemanager.network.fluent.models.VpnSiteProperties;
import com.azure.resourcemanager.network.models.AddressSpace;
import com.azure.resourcemanager.network.models.BgpSettings;
import com.azure.resourcemanager.network.models.DeviceProperties;
import com.azure.resourcemanager.network.models.O365PolicyProperties;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

public final class VpnSiteInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(VpnSiteInner.class);
    @JsonProperty(value="properties")
    private VpnSiteProperties innerProperties;
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="id")
    private String id;

    private VpnSiteProperties innerProperties() {
        return this.innerProperties;
    }

    public String etag() {
        return this.etag;
    }

    public String id() {
        return this.id;
    }

    public VpnSiteInner withId(String id) {
        this.id = id;
        return this;
    }

    public VpnSiteInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public VpnSiteInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public SubResource virtualWan() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualWan();
    }

    public VpnSiteInner withVirtualWan(SubResource virtualWan) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VpnSiteProperties();
        }
        this.innerProperties().withVirtualWan(virtualWan);
        return this;
    }

    public DeviceProperties deviceProperties() {
        return this.innerProperties() == null ? null : this.innerProperties().deviceProperties();
    }

    public VpnSiteInner withDeviceProperties(DeviceProperties deviceProperties) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VpnSiteProperties();
        }
        this.innerProperties().withDeviceProperties(deviceProperties);
        return this;
    }

    public String ipAddress() {
        return this.innerProperties() == null ? null : this.innerProperties().ipAddress();
    }

    public VpnSiteInner withIpAddress(String ipAddress) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VpnSiteProperties();
        }
        this.innerProperties().withIpAddress(ipAddress);
        return this;
    }

    public String siteKey() {
        return this.innerProperties() == null ? null : this.innerProperties().siteKey();
    }

    public VpnSiteInner withSiteKey(String siteKey) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VpnSiteProperties();
        }
        this.innerProperties().withSiteKey(siteKey);
        return this;
    }

    public AddressSpace addressSpace() {
        return this.innerProperties() == null ? null : this.innerProperties().addressSpace();
    }

    public VpnSiteInner withAddressSpace(AddressSpace addressSpace) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VpnSiteProperties();
        }
        this.innerProperties().withAddressSpace(addressSpace);
        return this;
    }

    public BgpSettings bgpProperties() {
        return this.innerProperties() == null ? null : this.innerProperties().bgpProperties();
    }

    public VpnSiteInner withBgpProperties(BgpSettings bgpProperties) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VpnSiteProperties();
        }
        this.innerProperties().withBgpProperties(bgpProperties);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public Boolean isSecuritySite() {
        return this.innerProperties() == null ? null : this.innerProperties().isSecuritySite();
    }

    public VpnSiteInner withIsSecuritySite(Boolean isSecuritySite) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VpnSiteProperties();
        }
        this.innerProperties().withIsSecuritySite(isSecuritySite);
        return this;
    }

    public List<VpnSiteLinkInner> vpnSiteLinks() {
        return this.innerProperties() == null ? null : this.innerProperties().vpnSiteLinks();
    }

    public VpnSiteInner withVpnSiteLinks(List<VpnSiteLinkInner> vpnSiteLinks) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VpnSiteProperties();
        }
        this.innerProperties().withVpnSiteLinks(vpnSiteLinks);
        return this;
    }

    public O365PolicyProperties o365Policy() {
        return this.innerProperties() == null ? null : this.innerProperties().o365Policy();
    }

    public VpnSiteInner withO365Policy(O365PolicyProperties o365Policy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VpnSiteProperties();
        }
        this.innerProperties().withO365Policy(o365Policy);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

