/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.network.fluent.ConnectionMonitorsClient;
import com.azure.resourcemanager.network.fluent.models.ConnectionMonitorInner;
import com.azure.resourcemanager.network.fluent.models.ConnectionMonitorQueryResultInner;
import com.azure.resourcemanager.network.fluent.models.ConnectionMonitorResultInner;
import com.azure.resourcemanager.network.implementation.NetworkManagementClientImpl;
import com.azure.resourcemanager.network.models.ConnectionMonitorListResult;
import com.azure.resourcemanager.network.models.TagsObject;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ConnectionMonitorsClientImpl
implements ConnectionMonitorsClient {
    private final ClientLogger logger = new ClientLogger(ConnectionMonitorsClientImpl.class);
    private final ConnectionMonitorsService service;
    private final NetworkManagementClientImpl client;

    ConnectionMonitorsClientImpl(NetworkManagementClientImpl client) {
        this.service = (ConnectionMonitorsService)RestProxy.create(ConnectionMonitorsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String networkWatcherName, String connectionMonitorName, ConnectionMonitorInner parameters, String migrate) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkWatcherName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null."));
        }
        if (connectionMonitorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectionMonitorName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2021-03-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, networkWatcherName, connectionMonitorName, "2021-03-01", this.client.getSubscriptionId(), migrate, parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String networkWatcherName, String connectionMonitorName, ConnectionMonitorInner parameters, String migrate, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkWatcherName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null."));
        }
        if (connectionMonitorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectionMonitorName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2021-03-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, networkWatcherName, connectionMonitorName, "2021-03-01", this.client.getSubscriptionId(), migrate, parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PollerFlux<PollResult<ConnectionMonitorResultInner>, ConnectionMonitorResultInner> beginCreateOrUpdateAsync(String resourceGroupName, String networkWatcherName, String connectionMonitorName, ConnectionMonitorInner parameters, String migrate) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, networkWatcherName, connectionMonitorName, parameters, migrate);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)ConnectionMonitorResultInner.class), (Type)((Object)ConnectionMonitorResultInner.class), Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PollerFlux<PollResult<ConnectionMonitorResultInner>, ConnectionMonitorResultInner> beginCreateOrUpdateAsync(String resourceGroupName, String networkWatcherName, String connectionMonitorName, ConnectionMonitorInner parameters, String migrate, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, networkWatcherName, connectionMonitorName, parameters, migrate, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)ConnectionMonitorResultInner.class), (Type)((Object)ConnectionMonitorResultInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<ConnectionMonitorResultInner>, ConnectionMonitorResultInner> beginCreateOrUpdate(String resourceGroupName, String networkWatcherName, String connectionMonitorName, ConnectionMonitorInner parameters, String migrate) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, networkWatcherName, connectionMonitorName, parameters, migrate).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<ConnectionMonitorResultInner>, ConnectionMonitorResultInner> beginCreateOrUpdate(String resourceGroupName, String networkWatcherName, String connectionMonitorName, ConnectionMonitorInner parameters, String migrate, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, networkWatcherName, connectionMonitorName, parameters, migrate, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ConnectionMonitorResultInner> createOrUpdateAsync(String resourceGroupName, String networkWatcherName, String connectionMonitorName, ConnectionMonitorInner parameters, String migrate) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, networkWatcherName, connectionMonitorName, parameters, migrate).last().flatMap(arg_0 -> ((NetworkManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ConnectionMonitorResultInner> createOrUpdateAsync(String resourceGroupName, String networkWatcherName, String connectionMonitorName, ConnectionMonitorInner parameters) {
        String migrate = null;
        return this.beginCreateOrUpdateAsync(resourceGroupName, networkWatcherName, connectionMonitorName, parameters, migrate).last().flatMap(arg_0 -> ((NetworkManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ConnectionMonitorResultInner> createOrUpdateAsync(String resourceGroupName, String networkWatcherName, String connectionMonitorName, ConnectionMonitorInner parameters, String migrate, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, networkWatcherName, connectionMonitorName, parameters, migrate, context).last().flatMap(arg_0 -> ((NetworkManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ConnectionMonitorResultInner createOrUpdate(String resourceGroupName, String networkWatcherName, String connectionMonitorName, ConnectionMonitorInner parameters, String migrate) {
        return (ConnectionMonitorResultInner)((Object)this.createOrUpdateAsync(resourceGroupName, networkWatcherName, connectionMonitorName, parameters, migrate).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ConnectionMonitorResultInner createOrUpdate(String resourceGroupName, String networkWatcherName, String connectionMonitorName, ConnectionMonitorInner parameters) {
        String migrate = null;
        return (ConnectionMonitorResultInner)((Object)this.createOrUpdateAsync(resourceGroupName, networkWatcherName, connectionMonitorName, parameters, migrate).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ConnectionMonitorResultInner createOrUpdate(String resourceGroupName, String networkWatcherName, String connectionMonitorName, ConnectionMonitorInner parameters, String migrate, Context context) {
        return (ConnectionMonitorResultInner)((Object)this.createOrUpdateAsync(resourceGroupName, networkWatcherName, connectionMonitorName, parameters, migrate, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ConnectionMonitorResultInner>> getWithResponseAsync(String resourceGroupName, String networkWatcherName, String connectionMonitorName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkWatcherName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null."));
        }
        if (connectionMonitorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectionMonitorName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-03-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, networkWatcherName, connectionMonitorName, "2021-03-01", this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ConnectionMonitorResultInner>> getWithResponseAsync(String resourceGroupName, String networkWatcherName, String connectionMonitorName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkWatcherName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null."));
        }
        if (connectionMonitorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectionMonitorName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-03-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, networkWatcherName, connectionMonitorName, "2021-03-01", this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ConnectionMonitorResultInner> getAsync(String resourceGroupName, String networkWatcherName, String connectionMonitorName) {
        return this.getWithResponseAsync(resourceGroupName, networkWatcherName, connectionMonitorName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((ConnectionMonitorResultInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ConnectionMonitorResultInner get(String resourceGroupName, String networkWatcherName, String connectionMonitorName) {
        return (ConnectionMonitorResultInner)((Object)this.getAsync(resourceGroupName, networkWatcherName, connectionMonitorName).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ConnectionMonitorResultInner> getWithResponse(String resourceGroupName, String networkWatcherName, String connectionMonitorName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, networkWatcherName, connectionMonitorName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String networkWatcherName, String connectionMonitorName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkWatcherName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null."));
        }
        if (connectionMonitorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectionMonitorName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-03-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, networkWatcherName, connectionMonitorName, "2021-03-01", this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String networkWatcherName, String connectionMonitorName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkWatcherName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null."));
        }
        if (connectionMonitorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectionMonitorName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-03-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, networkWatcherName, connectionMonitorName, "2021-03-01", this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String networkWatcherName, String connectionMonitorName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, networkWatcherName, connectionMonitorName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String networkWatcherName, String connectionMonitorName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, networkWatcherName, connectionMonitorName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String networkWatcherName, String connectionMonitorName) {
        return this.beginDeleteAsync(resourceGroupName, networkWatcherName, connectionMonitorName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String networkWatcherName, String connectionMonitorName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, networkWatcherName, connectionMonitorName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String networkWatcherName, String connectionMonitorName) {
        return this.beginDeleteAsync(resourceGroupName, networkWatcherName, connectionMonitorName).last().flatMap(arg_0 -> ((NetworkManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String networkWatcherName, String connectionMonitorName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, networkWatcherName, connectionMonitorName, context).last().flatMap(arg_0 -> ((NetworkManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String networkWatcherName, String connectionMonitorName) {
        this.deleteAsync(resourceGroupName, networkWatcherName, connectionMonitorName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String networkWatcherName, String connectionMonitorName, Context context) {
        this.deleteAsync(resourceGroupName, networkWatcherName, connectionMonitorName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ConnectionMonitorResultInner>> updateTagsWithResponseAsync(String resourceGroupName, String networkWatcherName, String connectionMonitorName, TagsObject parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkWatcherName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null."));
        }
        if (connectionMonitorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectionMonitorName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2021-03-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateTags(this.client.getEndpoint(), resourceGroupName, networkWatcherName, connectionMonitorName, "2021-03-01", this.client.getSubscriptionId(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ConnectionMonitorResultInner>> updateTagsWithResponseAsync(String resourceGroupName, String networkWatcherName, String connectionMonitorName, TagsObject parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkWatcherName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null."));
        }
        if (connectionMonitorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectionMonitorName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2021-03-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateTags(this.client.getEndpoint(), resourceGroupName, networkWatcherName, connectionMonitorName, "2021-03-01", this.client.getSubscriptionId(), parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ConnectionMonitorResultInner> updateTagsAsync(String resourceGroupName, String networkWatcherName, String connectionMonitorName, TagsObject parameters) {
        return this.updateTagsWithResponseAsync(resourceGroupName, networkWatcherName, connectionMonitorName, parameters).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((ConnectionMonitorResultInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ConnectionMonitorResultInner updateTags(String resourceGroupName, String networkWatcherName, String connectionMonitorName, TagsObject parameters) {
        return (ConnectionMonitorResultInner)((Object)this.updateTagsAsync(resourceGroupName, networkWatcherName, connectionMonitorName, parameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ConnectionMonitorResultInner> updateTagsWithResponse(String resourceGroupName, String networkWatcherName, String connectionMonitorName, TagsObject parameters, Context context) {
        return (Response)this.updateTagsWithResponseAsync(resourceGroupName, networkWatcherName, connectionMonitorName, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> stopWithResponseAsync(String resourceGroupName, String networkWatcherName, String connectionMonitorName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkWatcherName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null."));
        }
        if (connectionMonitorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectionMonitorName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-03-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.stop(this.client.getEndpoint(), resourceGroupName, networkWatcherName, connectionMonitorName, "2021-03-01", this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> stopWithResponseAsync(String resourceGroupName, String networkWatcherName, String connectionMonitorName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkWatcherName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null."));
        }
        if (connectionMonitorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectionMonitorName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-03-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.stop(this.client.getEndpoint(), resourceGroupName, networkWatcherName, connectionMonitorName, "2021-03-01", this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PollerFlux<PollResult<Void>, Void> beginStopAsync(String resourceGroupName, String networkWatcherName, String connectionMonitorName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.stopWithResponseAsync(resourceGroupName, networkWatcherName, connectionMonitorName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PollerFlux<PollResult<Void>, Void> beginStopAsync(String resourceGroupName, String networkWatcherName, String connectionMonitorName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.stopWithResponseAsync(resourceGroupName, networkWatcherName, connectionMonitorName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<Void>, Void> beginStop(String resourceGroupName, String networkWatcherName, String connectionMonitorName) {
        return this.beginStopAsync(resourceGroupName, networkWatcherName, connectionMonitorName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<Void>, Void> beginStop(String resourceGroupName, String networkWatcherName, String connectionMonitorName, Context context) {
        return this.beginStopAsync(resourceGroupName, networkWatcherName, connectionMonitorName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> stopAsync(String resourceGroupName, String networkWatcherName, String connectionMonitorName) {
        return this.beginStopAsync(resourceGroupName, networkWatcherName, connectionMonitorName).last().flatMap(arg_0 -> ((NetworkManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> stopAsync(String resourceGroupName, String networkWatcherName, String connectionMonitorName, Context context) {
        return this.beginStopAsync(resourceGroupName, networkWatcherName, connectionMonitorName, context).last().flatMap(arg_0 -> ((NetworkManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void stop(String resourceGroupName, String networkWatcherName, String connectionMonitorName) {
        this.stopAsync(resourceGroupName, networkWatcherName, connectionMonitorName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void stop(String resourceGroupName, String networkWatcherName, String connectionMonitorName, Context context) {
        this.stopAsync(resourceGroupName, networkWatcherName, connectionMonitorName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> startWithResponseAsync(String resourceGroupName, String networkWatcherName, String connectionMonitorName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkWatcherName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null."));
        }
        if (connectionMonitorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectionMonitorName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-03-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.start(this.client.getEndpoint(), resourceGroupName, networkWatcherName, connectionMonitorName, "2021-03-01", this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> startWithResponseAsync(String resourceGroupName, String networkWatcherName, String connectionMonitorName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkWatcherName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null."));
        }
        if (connectionMonitorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectionMonitorName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-03-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.start(this.client.getEndpoint(), resourceGroupName, networkWatcherName, connectionMonitorName, "2021-03-01", this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PollerFlux<PollResult<Void>, Void> beginStartAsync(String resourceGroupName, String networkWatcherName, String connectionMonitorName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.startWithResponseAsync(resourceGroupName, networkWatcherName, connectionMonitorName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PollerFlux<PollResult<Void>, Void> beginStartAsync(String resourceGroupName, String networkWatcherName, String connectionMonitorName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.startWithResponseAsync(resourceGroupName, networkWatcherName, connectionMonitorName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<Void>, Void> beginStart(String resourceGroupName, String networkWatcherName, String connectionMonitorName) {
        return this.beginStartAsync(resourceGroupName, networkWatcherName, connectionMonitorName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<Void>, Void> beginStart(String resourceGroupName, String networkWatcherName, String connectionMonitorName, Context context) {
        return this.beginStartAsync(resourceGroupName, networkWatcherName, connectionMonitorName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> startAsync(String resourceGroupName, String networkWatcherName, String connectionMonitorName) {
        return this.beginStartAsync(resourceGroupName, networkWatcherName, connectionMonitorName).last().flatMap(arg_0 -> ((NetworkManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> startAsync(String resourceGroupName, String networkWatcherName, String connectionMonitorName, Context context) {
        return this.beginStartAsync(resourceGroupName, networkWatcherName, connectionMonitorName, context).last().flatMap(arg_0 -> ((NetworkManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void start(String resourceGroupName, String networkWatcherName, String connectionMonitorName) {
        this.startAsync(resourceGroupName, networkWatcherName, connectionMonitorName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void start(String resourceGroupName, String networkWatcherName, String connectionMonitorName, Context context) {
        this.startAsync(resourceGroupName, networkWatcherName, connectionMonitorName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> queryWithResponseAsync(String resourceGroupName, String networkWatcherName, String connectionMonitorName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkWatcherName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null."));
        }
        if (connectionMonitorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectionMonitorName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-03-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.query(this.client.getEndpoint(), resourceGroupName, networkWatcherName, connectionMonitorName, "2021-03-01", this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> queryWithResponseAsync(String resourceGroupName, String networkWatcherName, String connectionMonitorName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkWatcherName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null."));
        }
        if (connectionMonitorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectionMonitorName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-03-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.query(this.client.getEndpoint(), resourceGroupName, networkWatcherName, connectionMonitorName, "2021-03-01", this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PollerFlux<PollResult<ConnectionMonitorQueryResultInner>, ConnectionMonitorQueryResultInner> beginQueryAsync(String resourceGroupName, String networkWatcherName, String connectionMonitorName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.queryWithResponseAsync(resourceGroupName, networkWatcherName, connectionMonitorName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)ConnectionMonitorQueryResultInner.class), (Type)((Object)ConnectionMonitorQueryResultInner.class), Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PollerFlux<PollResult<ConnectionMonitorQueryResultInner>, ConnectionMonitorQueryResultInner> beginQueryAsync(String resourceGroupName, String networkWatcherName, String connectionMonitorName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.queryWithResponseAsync(resourceGroupName, networkWatcherName, connectionMonitorName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)ConnectionMonitorQueryResultInner.class), (Type)((Object)ConnectionMonitorQueryResultInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<ConnectionMonitorQueryResultInner>, ConnectionMonitorQueryResultInner> beginQuery(String resourceGroupName, String networkWatcherName, String connectionMonitorName) {
        return this.beginQueryAsync(resourceGroupName, networkWatcherName, connectionMonitorName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<ConnectionMonitorQueryResultInner>, ConnectionMonitorQueryResultInner> beginQuery(String resourceGroupName, String networkWatcherName, String connectionMonitorName, Context context) {
        return this.beginQueryAsync(resourceGroupName, networkWatcherName, connectionMonitorName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ConnectionMonitorQueryResultInner> queryAsync(String resourceGroupName, String networkWatcherName, String connectionMonitorName) {
        return this.beginQueryAsync(resourceGroupName, networkWatcherName, connectionMonitorName).last().flatMap(arg_0 -> ((NetworkManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ConnectionMonitorQueryResultInner> queryAsync(String resourceGroupName, String networkWatcherName, String connectionMonitorName, Context context) {
        return this.beginQueryAsync(resourceGroupName, networkWatcherName, connectionMonitorName, context).last().flatMap(arg_0 -> ((NetworkManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ConnectionMonitorQueryResultInner query(String resourceGroupName, String networkWatcherName, String connectionMonitorName) {
        return (ConnectionMonitorQueryResultInner)this.queryAsync(resourceGroupName, networkWatcherName, connectionMonitorName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ConnectionMonitorQueryResultInner query(String resourceGroupName, String networkWatcherName, String connectionMonitorName, Context context) {
        return (ConnectionMonitorQueryResultInner)this.queryAsync(resourceGroupName, networkWatcherName, connectionMonitorName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ConnectionMonitorResultInner>> listSinglePageAsync(String resourceGroupName, String networkWatcherName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkWatcherName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-03-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), resourceGroupName, networkWatcherName, "2021-03-01", this.client.getSubscriptionId(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ConnectionMonitorListResult)res.getValue()).value(), null, null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ConnectionMonitorResultInner>> listSinglePageAsync(String resourceGroupName, String networkWatcherName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkWatcherName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-03-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), resourceGroupName, networkWatcherName, "2021-03-01", this.client.getSubscriptionId(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ConnectionMonitorListResult)res.getValue()).value(), null, null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ConnectionMonitorResultInner> listAsync(String resourceGroupName, String networkWatcherName) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, networkWatcherName));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ConnectionMonitorResultInner> listAsync(String resourceGroupName, String networkWatcherName, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, networkWatcherName, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ConnectionMonitorResultInner> list(String resourceGroupName, String networkWatcherName) {
        return new PagedIterable(this.listAsync(resourceGroupName, networkWatcherName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ConnectionMonitorResultInner> list(String resourceGroupName, String networkWatcherName, Context context) {
        return new PagedIterable(this.listAsync(resourceGroupName, networkWatcherName, context));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="NetworkManagementCli")
    private static interface ConnectionMonitorsService {
        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/connectionMonitors/{connectionMonitorName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="networkWatcherName") String var3, @PathParam(value="connectionMonitorName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="migrate") String var7, @BodyParam(value="application/json") ConnectionMonitorInner var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/connectionMonitors/{connectionMonitorName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ConnectionMonitorResultInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="networkWatcherName") String var3, @PathParam(value="connectionMonitorName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/connectionMonitors/{connectionMonitorName}")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="networkWatcherName") String var3, @PathParam(value="connectionMonitorName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/connectionMonitors/{connectionMonitorName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ConnectionMonitorResultInner>> updateTags(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="networkWatcherName") String var3, @PathParam(value="connectionMonitorName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @BodyParam(value="application/json") TagsObject var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/connectionMonitors/{connectionMonitorName}/stop")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> stop(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="networkWatcherName") String var3, @PathParam(value="connectionMonitorName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/connectionMonitors/{connectionMonitorName}/start")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> start(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="networkWatcherName") String var3, @PathParam(value="connectionMonitorName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/connectionMonitors/{connectionMonitorName}/query")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> query(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="networkWatcherName") String var3, @PathParam(value="connectionMonitorName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/connectionMonitors")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ConnectionMonitorListResult>> list(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="networkWatcherName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @HeaderParam(value="Accept") String var6, Context var7);
    }
}

