/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.network.fluent.InboundSecurityRuleOperationsClient;
import com.azure.resourcemanager.network.fluent.models.InboundSecurityRuleInner;
import com.azure.resourcemanager.network.implementation.NetworkManagementClientImpl;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class InboundSecurityRuleOperationsClientImpl
implements InboundSecurityRuleOperationsClient {
    private final ClientLogger logger = new ClientLogger(InboundSecurityRuleOperationsClientImpl.class);
    private final InboundSecurityRuleOperationsService service;
    private final NetworkManagementClientImpl client;

    InboundSecurityRuleOperationsClientImpl(NetworkManagementClientImpl client) {
        this.service = (InboundSecurityRuleOperationsService)RestProxy.create(InboundSecurityRuleOperationsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String networkVirtualApplianceName, String ruleCollectionName, InboundSecurityRuleInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkVirtualApplianceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkVirtualApplianceName is required and cannot be null."));
        }
        if (ruleCollectionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ruleCollectionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2021-03-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, networkVirtualApplianceName, ruleCollectionName, "2021-03-01", this.client.getSubscriptionId(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String networkVirtualApplianceName, String ruleCollectionName, InboundSecurityRuleInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkVirtualApplianceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkVirtualApplianceName is required and cannot be null."));
        }
        if (ruleCollectionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ruleCollectionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2021-03-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, networkVirtualApplianceName, ruleCollectionName, "2021-03-01", this.client.getSubscriptionId(), parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PollerFlux<PollResult<InboundSecurityRuleInner>, InboundSecurityRuleInner> beginCreateOrUpdateAsync(String resourceGroupName, String networkVirtualApplianceName, String ruleCollectionName, InboundSecurityRuleInner parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, networkVirtualApplianceName, ruleCollectionName, parameters);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)InboundSecurityRuleInner.class), (Type)((Object)InboundSecurityRuleInner.class), Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PollerFlux<PollResult<InboundSecurityRuleInner>, InboundSecurityRuleInner> beginCreateOrUpdateAsync(String resourceGroupName, String networkVirtualApplianceName, String ruleCollectionName, InboundSecurityRuleInner parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, networkVirtualApplianceName, ruleCollectionName, parameters, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)InboundSecurityRuleInner.class), (Type)((Object)InboundSecurityRuleInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<InboundSecurityRuleInner>, InboundSecurityRuleInner> beginCreateOrUpdate(String resourceGroupName, String networkVirtualApplianceName, String ruleCollectionName, InboundSecurityRuleInner parameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, networkVirtualApplianceName, ruleCollectionName, parameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<InboundSecurityRuleInner>, InboundSecurityRuleInner> beginCreateOrUpdate(String resourceGroupName, String networkVirtualApplianceName, String ruleCollectionName, InboundSecurityRuleInner parameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, networkVirtualApplianceName, ruleCollectionName, parameters, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<InboundSecurityRuleInner> createOrUpdateAsync(String resourceGroupName, String networkVirtualApplianceName, String ruleCollectionName, InboundSecurityRuleInner parameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, networkVirtualApplianceName, ruleCollectionName, parameters).last().flatMap(arg_0 -> ((NetworkManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<InboundSecurityRuleInner> createOrUpdateAsync(String resourceGroupName, String networkVirtualApplianceName, String ruleCollectionName, InboundSecurityRuleInner parameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, networkVirtualApplianceName, ruleCollectionName, parameters, context).last().flatMap(arg_0 -> ((NetworkManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public InboundSecurityRuleInner createOrUpdate(String resourceGroupName, String networkVirtualApplianceName, String ruleCollectionName, InboundSecurityRuleInner parameters) {
        return (InboundSecurityRuleInner)((Object)this.createOrUpdateAsync(resourceGroupName, networkVirtualApplianceName, ruleCollectionName, parameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public InboundSecurityRuleInner createOrUpdate(String resourceGroupName, String networkVirtualApplianceName, String ruleCollectionName, InboundSecurityRuleInner parameters, Context context) {
        return (InboundSecurityRuleInner)((Object)this.createOrUpdateAsync(resourceGroupName, networkVirtualApplianceName, ruleCollectionName, parameters, context).block());
    }

    @Host(value="{$host}")
    @ServiceInterface(name="NetworkManagementCli")
    private static interface InboundSecurityRuleOperationsService {
        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkVirtualAppliances/{networkVirtualApplianceName}/inboundSecurityRules/{ruleCollectionName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="networkVirtualApplianceName") String var3, @PathParam(value="ruleCollectionName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @BodyParam(value="application/json") InboundSecurityRuleInner var7, @HeaderParam(value="Accept") String var8, Context var9);
    }
}

