/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.fluent.models.HopLinkProperties;
import com.azure.resourcemanager.network.models.ConnectivityIssue;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

public final class HopLink {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(HopLink.class);
    @JsonProperty(value="nextHopId", access=JsonProperty.Access.WRITE_ONLY)
    private String nextHopId;
    @JsonProperty(value="linkType", access=JsonProperty.Access.WRITE_ONLY)
    private String linkType;
    @JsonProperty(value="properties")
    private HopLinkProperties innerProperties;
    @JsonProperty(value="issues", access=JsonProperty.Access.WRITE_ONLY)
    private List<ConnectivityIssue> issues;
    @JsonProperty(value="context", access=JsonProperty.Access.WRITE_ONLY)
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, String> context;
    @JsonProperty(value="resourceId", access=JsonProperty.Access.WRITE_ONLY)
    private String resourceId;

    public String nextHopId() {
        return this.nextHopId;
    }

    public String linkType() {
        return this.linkType;
    }

    private HopLinkProperties innerProperties() {
        return this.innerProperties;
    }

    public List<ConnectivityIssue> issues() {
        return this.issues;
    }

    public Map<String, String> context() {
        return this.context;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public Long roundTripTimeMin() {
        return this.innerProperties() == null ? null : this.innerProperties().roundTripTimeMin();
    }

    public Long roundTripTimeAvg() {
        return this.innerProperties() == null ? null : this.innerProperties().roundTripTimeAvg();
    }

    public Long roundTripTimeMax() {
        return this.innerProperties() == null ? null : this.innerProperties().roundTripTimeMax();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.issues() != null) {
            this.issues().forEach(e -> e.validate());
        }
    }
}

