// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.network.fluent.models.ConnectionMonitorInner;
import com.azure.resourcemanager.network.fluent.models.ConnectionMonitorQueryResultInner;
import com.azure.resourcemanager.network.fluent.models.ConnectionMonitorResultInner;
import com.azure.resourcemanager.network.models.TagsObject;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in ConnectionMonitorsClient. */
public interface ConnectionMonitorsClient {
    /**
     * Create or update a connection monitor.
     *
     * @param resourceGroupName The name of the resource group containing Network Watcher.
     * @param networkWatcherName The name of the Network Watcher resource.
     * @param connectionMonitorName The name of the connection monitor.
     * @param parameters Parameters that define the operation to create a connection monitor.
     * @param migrate Value indicating whether connection monitor V1 should be migrated to V2 format.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about the connection monitor.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(
        String resourceGroupName,
        String networkWatcherName,
        String connectionMonitorName,
        ConnectionMonitorInner parameters,
        String migrate);

    /**
     * Create or update a connection monitor.
     *
     * @param resourceGroupName The name of the resource group containing Network Watcher.
     * @param networkWatcherName The name of the Network Watcher resource.
     * @param connectionMonitorName The name of the connection monitor.
     * @param parameters Parameters that define the operation to create a connection monitor.
     * @param migrate Value indicating whether connection monitor V1 should be migrated to V2 format.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about the connection monitor.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<ConnectionMonitorResultInner>, ConnectionMonitorResultInner> beginCreateOrUpdateAsync(
        String resourceGroupName,
        String networkWatcherName,
        String connectionMonitorName,
        ConnectionMonitorInner parameters,
        String migrate);

    /**
     * Create or update a connection monitor.
     *
     * @param resourceGroupName The name of the resource group containing Network Watcher.
     * @param networkWatcherName The name of the Network Watcher resource.
     * @param connectionMonitorName The name of the connection monitor.
     * @param parameters Parameters that define the operation to create a connection monitor.
     * @param migrate Value indicating whether connection monitor V1 should be migrated to V2 format.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about the connection monitor.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<ConnectionMonitorResultInner>, ConnectionMonitorResultInner> beginCreateOrUpdate(
        String resourceGroupName,
        String networkWatcherName,
        String connectionMonitorName,
        ConnectionMonitorInner parameters,
        String migrate);

    /**
     * Create or update a connection monitor.
     *
     * @param resourceGroupName The name of the resource group containing Network Watcher.
     * @param networkWatcherName The name of the Network Watcher resource.
     * @param connectionMonitorName The name of the connection monitor.
     * @param parameters Parameters that define the operation to create a connection monitor.
     * @param migrate Value indicating whether connection monitor V1 should be migrated to V2 format.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about the connection monitor.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<ConnectionMonitorResultInner>, ConnectionMonitorResultInner> beginCreateOrUpdate(
        String resourceGroupName,
        String networkWatcherName,
        String connectionMonitorName,
        ConnectionMonitorInner parameters,
        String migrate,
        Context context);

    /**
     * Create or update a connection monitor.
     *
     * @param resourceGroupName The name of the resource group containing Network Watcher.
     * @param networkWatcherName The name of the Network Watcher resource.
     * @param connectionMonitorName The name of the connection monitor.
     * @param parameters Parameters that define the operation to create a connection monitor.
     * @param migrate Value indicating whether connection monitor V1 should be migrated to V2 format.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about the connection monitor.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ConnectionMonitorResultInner> createOrUpdateAsync(
        String resourceGroupName,
        String networkWatcherName,
        String connectionMonitorName,
        ConnectionMonitorInner parameters,
        String migrate);

    /**
     * Create or update a connection monitor.
     *
     * @param resourceGroupName The name of the resource group containing Network Watcher.
     * @param networkWatcherName The name of the Network Watcher resource.
     * @param connectionMonitorName The name of the connection monitor.
     * @param parameters Parameters that define the operation to create a connection monitor.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about the connection monitor.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ConnectionMonitorResultInner> createOrUpdateAsync(
        String resourceGroupName,
        String networkWatcherName,
        String connectionMonitorName,
        ConnectionMonitorInner parameters);

    /**
     * Create or update a connection monitor.
     *
     * @param resourceGroupName The name of the resource group containing Network Watcher.
     * @param networkWatcherName The name of the Network Watcher resource.
     * @param connectionMonitorName The name of the connection monitor.
     * @param parameters Parameters that define the operation to create a connection monitor.
     * @param migrate Value indicating whether connection monitor V1 should be migrated to V2 format.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about the connection monitor.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ConnectionMonitorResultInner createOrUpdate(
        String resourceGroupName,
        String networkWatcherName,
        String connectionMonitorName,
        ConnectionMonitorInner parameters,
        String migrate);

    /**
     * Create or update a connection monitor.
     *
     * @param resourceGroupName The name of the resource group containing Network Watcher.
     * @param networkWatcherName The name of the Network Watcher resource.
     * @param connectionMonitorName The name of the connection monitor.
     * @param parameters Parameters that define the operation to create a connection monitor.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about the connection monitor.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ConnectionMonitorResultInner createOrUpdate(
        String resourceGroupName,
        String networkWatcherName,
        String connectionMonitorName,
        ConnectionMonitorInner parameters);

    /**
     * Create or update a connection monitor.
     *
     * @param resourceGroupName The name of the resource group containing Network Watcher.
     * @param networkWatcherName The name of the Network Watcher resource.
     * @param connectionMonitorName The name of the connection monitor.
     * @param parameters Parameters that define the operation to create a connection monitor.
     * @param migrate Value indicating whether connection monitor V1 should be migrated to V2 format.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about the connection monitor.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ConnectionMonitorResultInner createOrUpdate(
        String resourceGroupName,
        String networkWatcherName,
        String connectionMonitorName,
        ConnectionMonitorInner parameters,
        String migrate,
        Context context);

    /**
     * Gets a connection monitor by name.
     *
     * @param resourceGroupName The name of the resource group containing Network Watcher.
     * @param networkWatcherName The name of the Network Watcher resource.
     * @param connectionMonitorName The name of the connection monitor.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a connection monitor by name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<ConnectionMonitorResultInner>> getWithResponseAsync(
        String resourceGroupName, String networkWatcherName, String connectionMonitorName);

    /**
     * Gets a connection monitor by name.
     *
     * @param resourceGroupName The name of the resource group containing Network Watcher.
     * @param networkWatcherName The name of the Network Watcher resource.
     * @param connectionMonitorName The name of the connection monitor.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a connection monitor by name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ConnectionMonitorResultInner> getAsync(
        String resourceGroupName, String networkWatcherName, String connectionMonitorName);

    /**
     * Gets a connection monitor by name.
     *
     * @param resourceGroupName The name of the resource group containing Network Watcher.
     * @param networkWatcherName The name of the Network Watcher resource.
     * @param connectionMonitorName The name of the connection monitor.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a connection monitor by name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ConnectionMonitorResultInner get(String resourceGroupName, String networkWatcherName, String connectionMonitorName);

    /**
     * Gets a connection monitor by name.
     *
     * @param resourceGroupName The name of the resource group containing Network Watcher.
     * @param networkWatcherName The name of the Network Watcher resource.
     * @param connectionMonitorName The name of the connection monitor.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a connection monitor by name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ConnectionMonitorResultInner> getWithResponse(
        String resourceGroupName, String networkWatcherName, String connectionMonitorName, Context context);

    /**
     * Deletes the specified connection monitor.
     *
     * @param resourceGroupName The name of the resource group containing Network Watcher.
     * @param networkWatcherName The name of the Network Watcher resource.
     * @param connectionMonitorName The name of the connection monitor.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(
        String resourceGroupName, String networkWatcherName, String connectionMonitorName);

    /**
     * Deletes the specified connection monitor.
     *
     * @param resourceGroupName The name of the resource group containing Network Watcher.
     * @param networkWatcherName The name of the Network Watcher resource.
     * @param connectionMonitorName The name of the connection monitor.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginDeleteAsync(
        String resourceGroupName, String networkWatcherName, String connectionMonitorName);

    /**
     * Deletes the specified connection monitor.
     *
     * @param resourceGroupName The name of the resource group containing Network Watcher.
     * @param networkWatcherName The name of the Network Watcher resource.
     * @param connectionMonitorName The name of the connection monitor.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(
        String resourceGroupName, String networkWatcherName, String connectionMonitorName);

    /**
     * Deletes the specified connection monitor.
     *
     * @param resourceGroupName The name of the resource group containing Network Watcher.
     * @param networkWatcherName The name of the Network Watcher resource.
     * @param connectionMonitorName The name of the connection monitor.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(
        String resourceGroupName, String networkWatcherName, String connectionMonitorName, Context context);

    /**
     * Deletes the specified connection monitor.
     *
     * @param resourceGroupName The name of the resource group containing Network Watcher.
     * @param networkWatcherName The name of the Network Watcher resource.
     * @param connectionMonitorName The name of the connection monitor.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAsync(String resourceGroupName, String networkWatcherName, String connectionMonitorName);

    /**
     * Deletes the specified connection monitor.
     *
     * @param resourceGroupName The name of the resource group containing Network Watcher.
     * @param networkWatcherName The name of the Network Watcher resource.
     * @param connectionMonitorName The name of the connection monitor.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String networkWatcherName, String connectionMonitorName);

    /**
     * Deletes the specified connection monitor.
     *
     * @param resourceGroupName The name of the resource group containing Network Watcher.
     * @param networkWatcherName The name of the Network Watcher resource.
     * @param connectionMonitorName The name of the connection monitor.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String networkWatcherName, String connectionMonitorName, Context context);

    /**
     * Update tags of the specified connection monitor.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param connectionMonitorName The name of the connection monitor.
     * @param parameters Parameters supplied to update connection monitor tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about the connection monitor.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<ConnectionMonitorResultInner>> updateTagsWithResponseAsync(
        String resourceGroupName, String networkWatcherName, String connectionMonitorName, TagsObject parameters);

    /**
     * Update tags of the specified connection monitor.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param connectionMonitorName The name of the connection monitor.
     * @param parameters Parameters supplied to update connection monitor tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about the connection monitor.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ConnectionMonitorResultInner> updateTagsAsync(
        String resourceGroupName, String networkWatcherName, String connectionMonitorName, TagsObject parameters);

    /**
     * Update tags of the specified connection monitor.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param connectionMonitorName The name of the connection monitor.
     * @param parameters Parameters supplied to update connection monitor tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about the connection monitor.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ConnectionMonitorResultInner updateTags(
        String resourceGroupName, String networkWatcherName, String connectionMonitorName, TagsObject parameters);

    /**
     * Update tags of the specified connection monitor.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param connectionMonitorName The name of the connection monitor.
     * @param parameters Parameters supplied to update connection monitor tags.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about the connection monitor.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ConnectionMonitorResultInner> updateTagsWithResponse(
        String resourceGroupName,
        String networkWatcherName,
        String connectionMonitorName,
        TagsObject parameters,
        Context context);

    /**
     * Stops the specified connection monitor.
     *
     * @param resourceGroupName The name of the resource group containing Network Watcher.
     * @param networkWatcherName The name of the Network Watcher resource.
     * @param connectionMonitorName The name of the connection monitor.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> stopWithResponseAsync(
        String resourceGroupName, String networkWatcherName, String connectionMonitorName);

    /**
     * Stops the specified connection monitor.
     *
     * @param resourceGroupName The name of the resource group containing Network Watcher.
     * @param networkWatcherName The name of the Network Watcher resource.
     * @param connectionMonitorName The name of the connection monitor.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginStopAsync(
        String resourceGroupName, String networkWatcherName, String connectionMonitorName);

    /**
     * Stops the specified connection monitor.
     *
     * @param resourceGroupName The name of the resource group containing Network Watcher.
     * @param networkWatcherName The name of the Network Watcher resource.
     * @param connectionMonitorName The name of the connection monitor.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginStop(
        String resourceGroupName, String networkWatcherName, String connectionMonitorName);

    /**
     * Stops the specified connection monitor.
     *
     * @param resourceGroupName The name of the resource group containing Network Watcher.
     * @param networkWatcherName The name of the Network Watcher resource.
     * @param connectionMonitorName The name of the connection monitor.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginStop(
        String resourceGroupName, String networkWatcherName, String connectionMonitorName, Context context);

    /**
     * Stops the specified connection monitor.
     *
     * @param resourceGroupName The name of the resource group containing Network Watcher.
     * @param networkWatcherName The name of the Network Watcher resource.
     * @param connectionMonitorName The name of the connection monitor.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> stopAsync(String resourceGroupName, String networkWatcherName, String connectionMonitorName);

    /**
     * Stops the specified connection monitor.
     *
     * @param resourceGroupName The name of the resource group containing Network Watcher.
     * @param networkWatcherName The name of the Network Watcher resource.
     * @param connectionMonitorName The name of the connection monitor.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void stop(String resourceGroupName, String networkWatcherName, String connectionMonitorName);

    /**
     * Stops the specified connection monitor.
     *
     * @param resourceGroupName The name of the resource group containing Network Watcher.
     * @param networkWatcherName The name of the Network Watcher resource.
     * @param connectionMonitorName The name of the connection monitor.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void stop(String resourceGroupName, String networkWatcherName, String connectionMonitorName, Context context);

    /**
     * Starts the specified connection monitor.
     *
     * @param resourceGroupName The name of the resource group containing Network Watcher.
     * @param networkWatcherName The name of the Network Watcher resource.
     * @param connectionMonitorName The name of the connection monitor.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> startWithResponseAsync(
        String resourceGroupName, String networkWatcherName, String connectionMonitorName);

    /**
     * Starts the specified connection monitor.
     *
     * @param resourceGroupName The name of the resource group containing Network Watcher.
     * @param networkWatcherName The name of the Network Watcher resource.
     * @param connectionMonitorName The name of the connection monitor.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginStartAsync(
        String resourceGroupName, String networkWatcherName, String connectionMonitorName);

    /**
     * Starts the specified connection monitor.
     *
     * @param resourceGroupName The name of the resource group containing Network Watcher.
     * @param networkWatcherName The name of the Network Watcher resource.
     * @param connectionMonitorName The name of the connection monitor.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginStart(
        String resourceGroupName, String networkWatcherName, String connectionMonitorName);

    /**
     * Starts the specified connection monitor.
     *
     * @param resourceGroupName The name of the resource group containing Network Watcher.
     * @param networkWatcherName The name of the Network Watcher resource.
     * @param connectionMonitorName The name of the connection monitor.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginStart(
        String resourceGroupName, String networkWatcherName, String connectionMonitorName, Context context);

    /**
     * Starts the specified connection monitor.
     *
     * @param resourceGroupName The name of the resource group containing Network Watcher.
     * @param networkWatcherName The name of the Network Watcher resource.
     * @param connectionMonitorName The name of the connection monitor.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> startAsync(String resourceGroupName, String networkWatcherName, String connectionMonitorName);

    /**
     * Starts the specified connection monitor.
     *
     * @param resourceGroupName The name of the resource group containing Network Watcher.
     * @param networkWatcherName The name of the Network Watcher resource.
     * @param connectionMonitorName The name of the connection monitor.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void start(String resourceGroupName, String networkWatcherName, String connectionMonitorName);

    /**
     * Starts the specified connection monitor.
     *
     * @param resourceGroupName The name of the resource group containing Network Watcher.
     * @param networkWatcherName The name of the Network Watcher resource.
     * @param connectionMonitorName The name of the connection monitor.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void start(String resourceGroupName, String networkWatcherName, String connectionMonitorName, Context context);

    /**
     * Query a snapshot of the most recent connection states.
     *
     * @param resourceGroupName The name of the resource group containing Network Watcher.
     * @param networkWatcherName The name of the Network Watcher resource.
     * @param connectionMonitorName The name given to the connection monitor.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of connection states snapshots.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> queryWithResponseAsync(
        String resourceGroupName, String networkWatcherName, String connectionMonitorName);

    /**
     * Query a snapshot of the most recent connection states.
     *
     * @param resourceGroupName The name of the resource group containing Network Watcher.
     * @param networkWatcherName The name of the Network Watcher resource.
     * @param connectionMonitorName The name given to the connection monitor.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of connection states snapshots.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<ConnectionMonitorQueryResultInner>, ConnectionMonitorQueryResultInner> beginQueryAsync(
        String resourceGroupName, String networkWatcherName, String connectionMonitorName);

    /**
     * Query a snapshot of the most recent connection states.
     *
     * @param resourceGroupName The name of the resource group containing Network Watcher.
     * @param networkWatcherName The name of the Network Watcher resource.
     * @param connectionMonitorName The name given to the connection monitor.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of connection states snapshots.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<ConnectionMonitorQueryResultInner>, ConnectionMonitorQueryResultInner> beginQuery(
        String resourceGroupName, String networkWatcherName, String connectionMonitorName);

    /**
     * Query a snapshot of the most recent connection states.
     *
     * @param resourceGroupName The name of the resource group containing Network Watcher.
     * @param networkWatcherName The name of the Network Watcher resource.
     * @param connectionMonitorName The name given to the connection monitor.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of connection states snapshots.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<ConnectionMonitorQueryResultInner>, ConnectionMonitorQueryResultInner> beginQuery(
        String resourceGroupName, String networkWatcherName, String connectionMonitorName, Context context);

    /**
     * Query a snapshot of the most recent connection states.
     *
     * @param resourceGroupName The name of the resource group containing Network Watcher.
     * @param networkWatcherName The name of the Network Watcher resource.
     * @param connectionMonitorName The name given to the connection monitor.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of connection states snapshots.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ConnectionMonitorQueryResultInner> queryAsync(
        String resourceGroupName, String networkWatcherName, String connectionMonitorName);

    /**
     * Query a snapshot of the most recent connection states.
     *
     * @param resourceGroupName The name of the resource group containing Network Watcher.
     * @param networkWatcherName The name of the Network Watcher resource.
     * @param connectionMonitorName The name given to the connection monitor.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of connection states snapshots.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ConnectionMonitorQueryResultInner query(
        String resourceGroupName, String networkWatcherName, String connectionMonitorName);

    /**
     * Query a snapshot of the most recent connection states.
     *
     * @param resourceGroupName The name of the resource group containing Network Watcher.
     * @param networkWatcherName The name of the Network Watcher resource.
     * @param connectionMonitorName The name given to the connection monitor.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of connection states snapshots.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ConnectionMonitorQueryResultInner query(
        String resourceGroupName, String networkWatcherName, String connectionMonitorName, Context context);

    /**
     * Lists all connection monitors for the specified Network Watcher.
     *
     * @param resourceGroupName The name of the resource group containing Network Watcher.
     * @param networkWatcherName The name of the Network Watcher resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of connection monitors.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<ConnectionMonitorResultInner> listAsync(String resourceGroupName, String networkWatcherName);

    /**
     * Lists all connection monitors for the specified Network Watcher.
     *
     * @param resourceGroupName The name of the resource group containing Network Watcher.
     * @param networkWatcherName The name of the Network Watcher resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of connection monitors.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ConnectionMonitorResultInner> list(String resourceGroupName, String networkWatcherName);

    /**
     * Lists all connection monitors for the specified Network Watcher.
     *
     * @param resourceGroupName The name of the resource group containing Network Watcher.
     * @param networkWatcherName The name of the Network Watcher resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of connection monitors.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ConnectionMonitorResultInner> list(
        String resourceGroupName, String networkWatcherName, Context context);
}
