// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.network.fluent.models.ExpressRouteCircuitsArpTableListResultInner;
import com.azure.resourcemanager.network.fluent.models.ExpressRouteCircuitsRoutesTableListResultInner;
import com.azure.resourcemanager.network.fluent.models.ExpressRouteCrossConnectionInner;
import com.azure.resourcemanager.network.fluent.models.ExpressRouteCrossConnectionsRoutesTableSummaryListResultInner;
import com.azure.resourcemanager.network.models.TagsObject;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsGet;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in ExpressRouteCrossConnectionsClient. */
public interface ExpressRouteCrossConnectionsClient
    extends InnerSupportsGet<ExpressRouteCrossConnectionInner>, InnerSupportsListing<ExpressRouteCrossConnectionInner> {
    /**
     * Retrieves all the ExpressRouteCrossConnections in a subscription.
     *
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response for ListExpressRouteCrossConnection API service call.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<ExpressRouteCrossConnectionInner> listAsync();

    /**
     * Retrieves all the ExpressRouteCrossConnections in a subscription.
     *
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response for ListExpressRouteCrossConnection API service call.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ExpressRouteCrossConnectionInner> list();

    /**
     * Retrieves all the ExpressRouteCrossConnections in a subscription.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response for ListExpressRouteCrossConnection API service call.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ExpressRouteCrossConnectionInner> list(Context context);

    /**
     * Retrieves all the ExpressRouteCrossConnections in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response for ListExpressRouteCrossConnection API service call.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<ExpressRouteCrossConnectionInner> listByResourceGroupAsync(String resourceGroupName);

    /**
     * Retrieves all the ExpressRouteCrossConnections in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response for ListExpressRouteCrossConnection API service call.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ExpressRouteCrossConnectionInner> listByResourceGroup(String resourceGroupName);

    /**
     * Retrieves all the ExpressRouteCrossConnections in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response for ListExpressRouteCrossConnection API service call.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ExpressRouteCrossConnectionInner> listByResourceGroup(String resourceGroupName, Context context);

    /**
     * Gets details about the specified ExpressRouteCrossConnection.
     *
     * @param resourceGroupName The name of the resource group (peering location of the circuit).
     * @param crossConnectionName The name of the ExpressRouteCrossConnection (service key of the circuit).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return details about the specified ExpressRouteCrossConnection.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<ExpressRouteCrossConnectionInner>> getByResourceGroupWithResponseAsync(
        String resourceGroupName, String crossConnectionName);

    /**
     * Gets details about the specified ExpressRouteCrossConnection.
     *
     * @param resourceGroupName The name of the resource group (peering location of the circuit).
     * @param crossConnectionName The name of the ExpressRouteCrossConnection (service key of the circuit).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return details about the specified ExpressRouteCrossConnection.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ExpressRouteCrossConnectionInner> getByResourceGroupAsync(
        String resourceGroupName, String crossConnectionName);

    /**
     * Gets details about the specified ExpressRouteCrossConnection.
     *
     * @param resourceGroupName The name of the resource group (peering location of the circuit).
     * @param crossConnectionName The name of the ExpressRouteCrossConnection (service key of the circuit).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return details about the specified ExpressRouteCrossConnection.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ExpressRouteCrossConnectionInner getByResourceGroup(String resourceGroupName, String crossConnectionName);

    /**
     * Gets details about the specified ExpressRouteCrossConnection.
     *
     * @param resourceGroupName The name of the resource group (peering location of the circuit).
     * @param crossConnectionName The name of the ExpressRouteCrossConnection (service key of the circuit).
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return details about the specified ExpressRouteCrossConnection.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ExpressRouteCrossConnectionInner> getByResourceGroupWithResponse(
        String resourceGroupName, String crossConnectionName, Context context);

    /**
     * Update the specified ExpressRouteCrossConnection.
     *
     * @param resourceGroupName The name of the resource group.
     * @param crossConnectionName The name of the ExpressRouteCrossConnection.
     * @param parameters Parameters supplied to the update express route crossConnection operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return expressRouteCrossConnection resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(
        String resourceGroupName, String crossConnectionName, ExpressRouteCrossConnectionInner parameters);

    /**
     * Update the specified ExpressRouteCrossConnection.
     *
     * @param resourceGroupName The name of the resource group.
     * @param crossConnectionName The name of the ExpressRouteCrossConnection.
     * @param parameters Parameters supplied to the update express route crossConnection operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return expressRouteCrossConnection resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<ExpressRouteCrossConnectionInner>, ExpressRouteCrossConnectionInner> beginCreateOrUpdateAsync(
        String resourceGroupName, String crossConnectionName, ExpressRouteCrossConnectionInner parameters);

    /**
     * Update the specified ExpressRouteCrossConnection.
     *
     * @param resourceGroupName The name of the resource group.
     * @param crossConnectionName The name of the ExpressRouteCrossConnection.
     * @param parameters Parameters supplied to the update express route crossConnection operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return expressRouteCrossConnection resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<ExpressRouteCrossConnectionInner>, ExpressRouteCrossConnectionInner> beginCreateOrUpdate(
        String resourceGroupName, String crossConnectionName, ExpressRouteCrossConnectionInner parameters);

    /**
     * Update the specified ExpressRouteCrossConnection.
     *
     * @param resourceGroupName The name of the resource group.
     * @param crossConnectionName The name of the ExpressRouteCrossConnection.
     * @param parameters Parameters supplied to the update express route crossConnection operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return expressRouteCrossConnection resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<ExpressRouteCrossConnectionInner>, ExpressRouteCrossConnectionInner> beginCreateOrUpdate(
        String resourceGroupName,
        String crossConnectionName,
        ExpressRouteCrossConnectionInner parameters,
        Context context);

    /**
     * Update the specified ExpressRouteCrossConnection.
     *
     * @param resourceGroupName The name of the resource group.
     * @param crossConnectionName The name of the ExpressRouteCrossConnection.
     * @param parameters Parameters supplied to the update express route crossConnection operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return expressRouteCrossConnection resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ExpressRouteCrossConnectionInner> createOrUpdateAsync(
        String resourceGroupName, String crossConnectionName, ExpressRouteCrossConnectionInner parameters);

    /**
     * Update the specified ExpressRouteCrossConnection.
     *
     * @param resourceGroupName The name of the resource group.
     * @param crossConnectionName The name of the ExpressRouteCrossConnection.
     * @param parameters Parameters supplied to the update express route crossConnection operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return expressRouteCrossConnection resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ExpressRouteCrossConnectionInner createOrUpdate(
        String resourceGroupName, String crossConnectionName, ExpressRouteCrossConnectionInner parameters);

    /**
     * Update the specified ExpressRouteCrossConnection.
     *
     * @param resourceGroupName The name of the resource group.
     * @param crossConnectionName The name of the ExpressRouteCrossConnection.
     * @param parameters Parameters supplied to the update express route crossConnection operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return expressRouteCrossConnection resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ExpressRouteCrossConnectionInner createOrUpdate(
        String resourceGroupName,
        String crossConnectionName,
        ExpressRouteCrossConnectionInner parameters,
        Context context);

    /**
     * Updates an express route cross connection tags.
     *
     * @param resourceGroupName The name of the resource group.
     * @param crossConnectionName The name of the cross connection.
     * @param crossConnectionParameters Parameters supplied to update express route cross connection tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return expressRouteCrossConnection resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<ExpressRouteCrossConnectionInner>> updateTagsWithResponseAsync(
        String resourceGroupName, String crossConnectionName, TagsObject crossConnectionParameters);

    /**
     * Updates an express route cross connection tags.
     *
     * @param resourceGroupName The name of the resource group.
     * @param crossConnectionName The name of the cross connection.
     * @param crossConnectionParameters Parameters supplied to update express route cross connection tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return expressRouteCrossConnection resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ExpressRouteCrossConnectionInner> updateTagsAsync(
        String resourceGroupName, String crossConnectionName, TagsObject crossConnectionParameters);

    /**
     * Updates an express route cross connection tags.
     *
     * @param resourceGroupName The name of the resource group.
     * @param crossConnectionName The name of the cross connection.
     * @param crossConnectionParameters Parameters supplied to update express route cross connection tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return expressRouteCrossConnection resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ExpressRouteCrossConnectionInner updateTags(
        String resourceGroupName, String crossConnectionName, TagsObject crossConnectionParameters);

    /**
     * Updates an express route cross connection tags.
     *
     * @param resourceGroupName The name of the resource group.
     * @param crossConnectionName The name of the cross connection.
     * @param crossConnectionParameters Parameters supplied to update express route cross connection tags.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return expressRouteCrossConnection resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ExpressRouteCrossConnectionInner> updateTagsWithResponse(
        String resourceGroupName, String crossConnectionName, TagsObject crossConnectionParameters, Context context);

    /**
     * Gets the currently advertised ARP table associated with the express route cross connection in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param crossConnectionName The name of the ExpressRouteCrossConnection.
     * @param peeringName The name of the peering.
     * @param devicePath The path of the device.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the currently advertised ARP table associated with the express route cross connection in a resource
     *     group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> listArpTableWithResponseAsync(
        String resourceGroupName, String crossConnectionName, String peeringName, String devicePath);

    /**
     * Gets the currently advertised ARP table associated with the express route cross connection in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param crossConnectionName The name of the ExpressRouteCrossConnection.
     * @param peeringName The name of the peering.
     * @param devicePath The path of the device.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the currently advertised ARP table associated with the express route cross connection in a resource
     *     group.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<ExpressRouteCircuitsArpTableListResultInner>, ExpressRouteCircuitsArpTableListResultInner>
        beginListArpTableAsync(
            String resourceGroupName, String crossConnectionName, String peeringName, String devicePath);

    /**
     * Gets the currently advertised ARP table associated with the express route cross connection in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param crossConnectionName The name of the ExpressRouteCrossConnection.
     * @param peeringName The name of the peering.
     * @param devicePath The path of the device.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the currently advertised ARP table associated with the express route cross connection in a resource
     *     group.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<ExpressRouteCircuitsArpTableListResultInner>, ExpressRouteCircuitsArpTableListResultInner>
        beginListArpTable(String resourceGroupName, String crossConnectionName, String peeringName, String devicePath);

    /**
     * Gets the currently advertised ARP table associated with the express route cross connection in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param crossConnectionName The name of the ExpressRouteCrossConnection.
     * @param peeringName The name of the peering.
     * @param devicePath The path of the device.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the currently advertised ARP table associated with the express route cross connection in a resource
     *     group.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<ExpressRouteCircuitsArpTableListResultInner>, ExpressRouteCircuitsArpTableListResultInner>
        beginListArpTable(
            String resourceGroupName,
            String crossConnectionName,
            String peeringName,
            String devicePath,
            Context context);

    /**
     * Gets the currently advertised ARP table associated with the express route cross connection in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param crossConnectionName The name of the ExpressRouteCrossConnection.
     * @param peeringName The name of the peering.
     * @param devicePath The path of the device.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the currently advertised ARP table associated with the express route cross connection in a resource
     *     group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ExpressRouteCircuitsArpTableListResultInner> listArpTableAsync(
        String resourceGroupName, String crossConnectionName, String peeringName, String devicePath);

    /**
     * Gets the currently advertised ARP table associated with the express route cross connection in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param crossConnectionName The name of the ExpressRouteCrossConnection.
     * @param peeringName The name of the peering.
     * @param devicePath The path of the device.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the currently advertised ARP table associated with the express route cross connection in a resource
     *     group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ExpressRouteCircuitsArpTableListResultInner listArpTable(
        String resourceGroupName, String crossConnectionName, String peeringName, String devicePath);

    /**
     * Gets the currently advertised ARP table associated with the express route cross connection in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param crossConnectionName The name of the ExpressRouteCrossConnection.
     * @param peeringName The name of the peering.
     * @param devicePath The path of the device.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the currently advertised ARP table associated with the express route cross connection in a resource
     *     group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ExpressRouteCircuitsArpTableListResultInner listArpTable(
        String resourceGroupName, String crossConnectionName, String peeringName, String devicePath, Context context);

    /**
     * Gets the route table summary associated with the express route cross connection in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param crossConnectionName The name of the ExpressRouteCrossConnection.
     * @param peeringName The name of the peering.
     * @param devicePath The path of the device.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the route table summary associated with the express route cross connection in a resource group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> listRoutesTableSummaryWithResponseAsync(
        String resourceGroupName, String crossConnectionName, String peeringName, String devicePath);

    /**
     * Gets the route table summary associated with the express route cross connection in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param crossConnectionName The name of the ExpressRouteCrossConnection.
     * @param peeringName The name of the peering.
     * @param devicePath The path of the device.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the route table summary associated with the express route cross connection in a resource group.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<
            PollResult<ExpressRouteCrossConnectionsRoutesTableSummaryListResultInner>,
            ExpressRouteCrossConnectionsRoutesTableSummaryListResultInner>
        beginListRoutesTableSummaryAsync(
            String resourceGroupName, String crossConnectionName, String peeringName, String devicePath);

    /**
     * Gets the route table summary associated with the express route cross connection in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param crossConnectionName The name of the ExpressRouteCrossConnection.
     * @param peeringName The name of the peering.
     * @param devicePath The path of the device.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the route table summary associated with the express route cross connection in a resource group.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<
            PollResult<ExpressRouteCrossConnectionsRoutesTableSummaryListResultInner>,
            ExpressRouteCrossConnectionsRoutesTableSummaryListResultInner>
        beginListRoutesTableSummary(
            String resourceGroupName, String crossConnectionName, String peeringName, String devicePath);

    /**
     * Gets the route table summary associated with the express route cross connection in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param crossConnectionName The name of the ExpressRouteCrossConnection.
     * @param peeringName The name of the peering.
     * @param devicePath The path of the device.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the route table summary associated with the express route cross connection in a resource group.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<
            PollResult<ExpressRouteCrossConnectionsRoutesTableSummaryListResultInner>,
            ExpressRouteCrossConnectionsRoutesTableSummaryListResultInner>
        beginListRoutesTableSummary(
            String resourceGroupName,
            String crossConnectionName,
            String peeringName,
            String devicePath,
            Context context);

    /**
     * Gets the route table summary associated with the express route cross connection in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param crossConnectionName The name of the ExpressRouteCrossConnection.
     * @param peeringName The name of the peering.
     * @param devicePath The path of the device.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the route table summary associated with the express route cross connection in a resource group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ExpressRouteCrossConnectionsRoutesTableSummaryListResultInner> listRoutesTableSummaryAsync(
        String resourceGroupName, String crossConnectionName, String peeringName, String devicePath);

    /**
     * Gets the route table summary associated with the express route cross connection in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param crossConnectionName The name of the ExpressRouteCrossConnection.
     * @param peeringName The name of the peering.
     * @param devicePath The path of the device.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the route table summary associated with the express route cross connection in a resource group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ExpressRouteCrossConnectionsRoutesTableSummaryListResultInner listRoutesTableSummary(
        String resourceGroupName, String crossConnectionName, String peeringName, String devicePath);

    /**
     * Gets the route table summary associated with the express route cross connection in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param crossConnectionName The name of the ExpressRouteCrossConnection.
     * @param peeringName The name of the peering.
     * @param devicePath The path of the device.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the route table summary associated with the express route cross connection in a resource group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ExpressRouteCrossConnectionsRoutesTableSummaryListResultInner listRoutesTableSummary(
        String resourceGroupName, String crossConnectionName, String peeringName, String devicePath, Context context);

    /**
     * Gets the currently advertised routes table associated with the express route cross connection in a resource
     * group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param crossConnectionName The name of the ExpressRouteCrossConnection.
     * @param peeringName The name of the peering.
     * @param devicePath The path of the device.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the currently advertised routes table associated with the express route cross connection in a resource
     *     group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> listRoutesTableWithResponseAsync(
        String resourceGroupName, String crossConnectionName, String peeringName, String devicePath);

    /**
     * Gets the currently advertised routes table associated with the express route cross connection in a resource
     * group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param crossConnectionName The name of the ExpressRouteCrossConnection.
     * @param peeringName The name of the peering.
     * @param devicePath The path of the device.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the currently advertised routes table associated with the express route cross connection in a resource
     *     group.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<
            PollResult<ExpressRouteCircuitsRoutesTableListResultInner>, ExpressRouteCircuitsRoutesTableListResultInner>
        beginListRoutesTableAsync(
            String resourceGroupName, String crossConnectionName, String peeringName, String devicePath);

    /**
     * Gets the currently advertised routes table associated with the express route cross connection in a resource
     * group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param crossConnectionName The name of the ExpressRouteCrossConnection.
     * @param peeringName The name of the peering.
     * @param devicePath The path of the device.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the currently advertised routes table associated with the express route cross connection in a resource
     *     group.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<
            PollResult<ExpressRouteCircuitsRoutesTableListResultInner>, ExpressRouteCircuitsRoutesTableListResultInner>
        beginListRoutesTable(
            String resourceGroupName, String crossConnectionName, String peeringName, String devicePath);

    /**
     * Gets the currently advertised routes table associated with the express route cross connection in a resource
     * group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param crossConnectionName The name of the ExpressRouteCrossConnection.
     * @param peeringName The name of the peering.
     * @param devicePath The path of the device.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the currently advertised routes table associated with the express route cross connection in a resource
     *     group.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<
            PollResult<ExpressRouteCircuitsRoutesTableListResultInner>, ExpressRouteCircuitsRoutesTableListResultInner>
        beginListRoutesTable(
            String resourceGroupName,
            String crossConnectionName,
            String peeringName,
            String devicePath,
            Context context);

    /**
     * Gets the currently advertised routes table associated with the express route cross connection in a resource
     * group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param crossConnectionName The name of the ExpressRouteCrossConnection.
     * @param peeringName The name of the peering.
     * @param devicePath The path of the device.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the currently advertised routes table associated with the express route cross connection in a resource
     *     group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ExpressRouteCircuitsRoutesTableListResultInner> listRoutesTableAsync(
        String resourceGroupName, String crossConnectionName, String peeringName, String devicePath);

    /**
     * Gets the currently advertised routes table associated with the express route cross connection in a resource
     * group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param crossConnectionName The name of the ExpressRouteCrossConnection.
     * @param peeringName The name of the peering.
     * @param devicePath The path of the device.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the currently advertised routes table associated with the express route cross connection in a resource
     *     group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ExpressRouteCircuitsRoutesTableListResultInner listRoutesTable(
        String resourceGroupName, String crossConnectionName, String peeringName, String devicePath);

    /**
     * Gets the currently advertised routes table associated with the express route cross connection in a resource
     * group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param crossConnectionName The name of the ExpressRouteCrossConnection.
     * @param peeringName The name of the peering.
     * @param devicePath The path of the device.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the currently advertised routes table associated with the express route cross connection in a resource
     *     group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ExpressRouteCircuitsRoutesTableListResultInner listRoutesTable(
        String resourceGroupName, String crossConnectionName, String peeringName, String devicePath, Context context);
}
