// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.network.fluent.models.FirewallPolicyRuleCollectionGroupInner;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in FirewallPolicyRuleCollectionGroupsClient.
 */
public interface FirewallPolicyRuleCollectionGroupsClient {
    /**
     * Deletes the specified FirewallPolicyRuleCollectionGroup.
     *
     * @param resourceGroupName The name of the resource group.
     * @param firewallPolicyName The name of the Firewall Policy.
     * @param ruleCollectionGroupName The name of the FirewallPolicyRuleCollectionGroup.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(
        String resourceGroupName, String firewallPolicyName, String ruleCollectionGroupName);

    /**
     * Deletes the specified FirewallPolicyRuleCollectionGroup.
     *
     * @param resourceGroupName The name of the resource group.
     * @param firewallPolicyName The name of the Firewall Policy.
     * @param ruleCollectionGroupName The name of the FirewallPolicyRuleCollectionGroup.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginDeleteAsync(
        String resourceGroupName, String firewallPolicyName, String ruleCollectionGroupName);

    /**
     * Deletes the specified FirewallPolicyRuleCollectionGroup.
     *
     * @param resourceGroupName The name of the resource group.
     * @param firewallPolicyName The name of the Firewall Policy.
     * @param ruleCollectionGroupName The name of the FirewallPolicyRuleCollectionGroup.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(
        String resourceGroupName, String firewallPolicyName, String ruleCollectionGroupName);

    /**
     * Deletes the specified FirewallPolicyRuleCollectionGroup.
     *
     * @param resourceGroupName The name of the resource group.
     * @param firewallPolicyName The name of the Firewall Policy.
     * @param ruleCollectionGroupName The name of the FirewallPolicyRuleCollectionGroup.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(
        String resourceGroupName, String firewallPolicyName, String ruleCollectionGroupName, Context context);

    /**
     * Deletes the specified FirewallPolicyRuleCollectionGroup.
     *
     * @param resourceGroupName The name of the resource group.
     * @param firewallPolicyName The name of the Firewall Policy.
     * @param ruleCollectionGroupName The name of the FirewallPolicyRuleCollectionGroup.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAsync(String resourceGroupName, String firewallPolicyName, String ruleCollectionGroupName);

    /**
     * Deletes the specified FirewallPolicyRuleCollectionGroup.
     *
     * @param resourceGroupName The name of the resource group.
     * @param firewallPolicyName The name of the Firewall Policy.
     * @param ruleCollectionGroupName The name of the FirewallPolicyRuleCollectionGroup.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String firewallPolicyName, String ruleCollectionGroupName);

    /**
     * Deletes the specified FirewallPolicyRuleCollectionGroup.
     *
     * @param resourceGroupName The name of the resource group.
     * @param firewallPolicyName The name of the Firewall Policy.
     * @param ruleCollectionGroupName The name of the FirewallPolicyRuleCollectionGroup.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String firewallPolicyName, String ruleCollectionGroupName, Context context);

    /**
     * Gets the specified FirewallPolicyRuleCollectionGroup.
     *
     * @param resourceGroupName The name of the resource group.
     * @param firewallPolicyName The name of the Firewall Policy.
     * @param ruleCollectionGroupName The name of the FirewallPolicyRuleCollectionGroup.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified FirewallPolicyRuleCollectionGroup.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<FirewallPolicyRuleCollectionGroupInner>> getWithResponseAsync(
        String resourceGroupName, String firewallPolicyName, String ruleCollectionGroupName);

    /**
     * Gets the specified FirewallPolicyRuleCollectionGroup.
     *
     * @param resourceGroupName The name of the resource group.
     * @param firewallPolicyName The name of the Firewall Policy.
     * @param ruleCollectionGroupName The name of the FirewallPolicyRuleCollectionGroup.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified FirewallPolicyRuleCollectionGroup.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<FirewallPolicyRuleCollectionGroupInner> getAsync(
        String resourceGroupName, String firewallPolicyName, String ruleCollectionGroupName);

    /**
     * Gets the specified FirewallPolicyRuleCollectionGroup.
     *
     * @param resourceGroupName The name of the resource group.
     * @param firewallPolicyName The name of the Firewall Policy.
     * @param ruleCollectionGroupName The name of the FirewallPolicyRuleCollectionGroup.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified FirewallPolicyRuleCollectionGroup.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    FirewallPolicyRuleCollectionGroupInner get(
        String resourceGroupName, String firewallPolicyName, String ruleCollectionGroupName);

    /**
     * Gets the specified FirewallPolicyRuleCollectionGroup.
     *
     * @param resourceGroupName The name of the resource group.
     * @param firewallPolicyName The name of the Firewall Policy.
     * @param ruleCollectionGroupName The name of the FirewallPolicyRuleCollectionGroup.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified FirewallPolicyRuleCollectionGroup.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<FirewallPolicyRuleCollectionGroupInner> getWithResponse(
        String resourceGroupName, String firewallPolicyName, String ruleCollectionGroupName, Context context);

    /**
     * Creates or updates the specified FirewallPolicyRuleCollectionGroup.
     *
     * @param resourceGroupName The name of the resource group.
     * @param firewallPolicyName The name of the Firewall Policy.
     * @param ruleCollectionGroupName The name of the FirewallPolicyRuleCollectionGroup.
     * @param parameters Parameters supplied to the create or update FirewallPolicyRuleCollectionGroup operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return rule Collection Group resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(
        String resourceGroupName,
        String firewallPolicyName,
        String ruleCollectionGroupName,
        FirewallPolicyRuleCollectionGroupInner parameters);

    /**
     * Creates or updates the specified FirewallPolicyRuleCollectionGroup.
     *
     * @param resourceGroupName The name of the resource group.
     * @param firewallPolicyName The name of the Firewall Policy.
     * @param ruleCollectionGroupName The name of the FirewallPolicyRuleCollectionGroup.
     * @param parameters Parameters supplied to the create or update FirewallPolicyRuleCollectionGroup operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return rule Collection Group resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<FirewallPolicyRuleCollectionGroupInner>, FirewallPolicyRuleCollectionGroupInner>
        beginCreateOrUpdateAsync(
            String resourceGroupName,
            String firewallPolicyName,
            String ruleCollectionGroupName,
            FirewallPolicyRuleCollectionGroupInner parameters);

    /**
     * Creates or updates the specified FirewallPolicyRuleCollectionGroup.
     *
     * @param resourceGroupName The name of the resource group.
     * @param firewallPolicyName The name of the Firewall Policy.
     * @param ruleCollectionGroupName The name of the FirewallPolicyRuleCollectionGroup.
     * @param parameters Parameters supplied to the create or update FirewallPolicyRuleCollectionGroup operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return rule Collection Group resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<FirewallPolicyRuleCollectionGroupInner>, FirewallPolicyRuleCollectionGroupInner>
        beginCreateOrUpdate(
            String resourceGroupName,
            String firewallPolicyName,
            String ruleCollectionGroupName,
            FirewallPolicyRuleCollectionGroupInner parameters);

    /**
     * Creates or updates the specified FirewallPolicyRuleCollectionGroup.
     *
     * @param resourceGroupName The name of the resource group.
     * @param firewallPolicyName The name of the Firewall Policy.
     * @param ruleCollectionGroupName The name of the FirewallPolicyRuleCollectionGroup.
     * @param parameters Parameters supplied to the create or update FirewallPolicyRuleCollectionGroup operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return rule Collection Group resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<FirewallPolicyRuleCollectionGroupInner>, FirewallPolicyRuleCollectionGroupInner>
        beginCreateOrUpdate(
            String resourceGroupName,
            String firewallPolicyName,
            String ruleCollectionGroupName,
            FirewallPolicyRuleCollectionGroupInner parameters,
            Context context);

    /**
     * Creates or updates the specified FirewallPolicyRuleCollectionGroup.
     *
     * @param resourceGroupName The name of the resource group.
     * @param firewallPolicyName The name of the Firewall Policy.
     * @param ruleCollectionGroupName The name of the FirewallPolicyRuleCollectionGroup.
     * @param parameters Parameters supplied to the create or update FirewallPolicyRuleCollectionGroup operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return rule Collection Group resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<FirewallPolicyRuleCollectionGroupInner> createOrUpdateAsync(
        String resourceGroupName,
        String firewallPolicyName,
        String ruleCollectionGroupName,
        FirewallPolicyRuleCollectionGroupInner parameters);

    /**
     * Creates or updates the specified FirewallPolicyRuleCollectionGroup.
     *
     * @param resourceGroupName The name of the resource group.
     * @param firewallPolicyName The name of the Firewall Policy.
     * @param ruleCollectionGroupName The name of the FirewallPolicyRuleCollectionGroup.
     * @param parameters Parameters supplied to the create or update FirewallPolicyRuleCollectionGroup operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return rule Collection Group resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    FirewallPolicyRuleCollectionGroupInner createOrUpdate(
        String resourceGroupName,
        String firewallPolicyName,
        String ruleCollectionGroupName,
        FirewallPolicyRuleCollectionGroupInner parameters);

    /**
     * Creates or updates the specified FirewallPolicyRuleCollectionGroup.
     *
     * @param resourceGroupName The name of the resource group.
     * @param firewallPolicyName The name of the Firewall Policy.
     * @param ruleCollectionGroupName The name of the FirewallPolicyRuleCollectionGroup.
     * @param parameters Parameters supplied to the create or update FirewallPolicyRuleCollectionGroup operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return rule Collection Group resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    FirewallPolicyRuleCollectionGroupInner createOrUpdate(
        String resourceGroupName,
        String firewallPolicyName,
        String ruleCollectionGroupName,
        FirewallPolicyRuleCollectionGroupInner parameters,
        Context context);

    /**
     * Lists all FirewallPolicyRuleCollectionGroups in a FirewallPolicy resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param firewallPolicyName The name of the Firewall Policy.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response for ListFirewallPolicyRuleCollectionGroups API service call.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<FirewallPolicyRuleCollectionGroupInner> listAsync(String resourceGroupName, String firewallPolicyName);

    /**
     * Lists all FirewallPolicyRuleCollectionGroups in a FirewallPolicy resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param firewallPolicyName The name of the Firewall Policy.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response for ListFirewallPolicyRuleCollectionGroups API service call.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<FirewallPolicyRuleCollectionGroupInner> list(String resourceGroupName, String firewallPolicyName);

    /**
     * Lists all FirewallPolicyRuleCollectionGroups in a FirewallPolicy resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param firewallPolicyName The name of the Firewall Policy.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response for ListFirewallPolicyRuleCollectionGroups API service call.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<FirewallPolicyRuleCollectionGroupInner> list(
        String resourceGroupName, String firewallPolicyName, Context context);
}
