// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.network.fluent.models.PacketCaptureInner;
import com.azure.resourcemanager.network.fluent.models.PacketCaptureQueryStatusResultInner;
import com.azure.resourcemanager.network.fluent.models.PacketCaptureResultInner;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in PacketCapturesClient. */
public interface PacketCapturesClient {
    /**
     * Create and start a packet capture on the specified VM.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param packetCaptureName The name of the packet capture session.
     * @param parameters Parameters that define the create packet capture operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about packet capture session.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(
        String resourceGroupName, String networkWatcherName, String packetCaptureName, PacketCaptureInner parameters);

    /**
     * Create and start a packet capture on the specified VM.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param packetCaptureName The name of the packet capture session.
     * @param parameters Parameters that define the create packet capture operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about packet capture session.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<PacketCaptureResultInner>, PacketCaptureResultInner> beginCreateAsync(
        String resourceGroupName, String networkWatcherName, String packetCaptureName, PacketCaptureInner parameters);

    /**
     * Create and start a packet capture on the specified VM.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param packetCaptureName The name of the packet capture session.
     * @param parameters Parameters that define the create packet capture operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about packet capture session.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<PacketCaptureResultInner>, PacketCaptureResultInner> beginCreate(
        String resourceGroupName, String networkWatcherName, String packetCaptureName, PacketCaptureInner parameters);

    /**
     * Create and start a packet capture on the specified VM.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param packetCaptureName The name of the packet capture session.
     * @param parameters Parameters that define the create packet capture operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about packet capture session.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<PacketCaptureResultInner>, PacketCaptureResultInner> beginCreate(
        String resourceGroupName,
        String networkWatcherName,
        String packetCaptureName,
        PacketCaptureInner parameters,
        Context context);

    /**
     * Create and start a packet capture on the specified VM.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param packetCaptureName The name of the packet capture session.
     * @param parameters Parameters that define the create packet capture operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about packet capture session.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<PacketCaptureResultInner> createAsync(
        String resourceGroupName, String networkWatcherName, String packetCaptureName, PacketCaptureInner parameters);

    /**
     * Create and start a packet capture on the specified VM.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param packetCaptureName The name of the packet capture session.
     * @param parameters Parameters that define the create packet capture operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about packet capture session.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PacketCaptureResultInner create(
        String resourceGroupName, String networkWatcherName, String packetCaptureName, PacketCaptureInner parameters);

    /**
     * Create and start a packet capture on the specified VM.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param packetCaptureName The name of the packet capture session.
     * @param parameters Parameters that define the create packet capture operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about packet capture session.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PacketCaptureResultInner create(
        String resourceGroupName,
        String networkWatcherName,
        String packetCaptureName,
        PacketCaptureInner parameters,
        Context context);

    /**
     * Gets a packet capture session by name.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param packetCaptureName The name of the packet capture session.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a packet capture session by name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<PacketCaptureResultInner>> getWithResponseAsync(
        String resourceGroupName, String networkWatcherName, String packetCaptureName);

    /**
     * Gets a packet capture session by name.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param packetCaptureName The name of the packet capture session.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a packet capture session by name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<PacketCaptureResultInner> getAsync(
        String resourceGroupName, String networkWatcherName, String packetCaptureName);

    /**
     * Gets a packet capture session by name.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param packetCaptureName The name of the packet capture session.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a packet capture session by name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PacketCaptureResultInner get(String resourceGroupName, String networkWatcherName, String packetCaptureName);

    /**
     * Gets a packet capture session by name.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param packetCaptureName The name of the packet capture session.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a packet capture session by name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<PacketCaptureResultInner> getWithResponse(
        String resourceGroupName, String networkWatcherName, String packetCaptureName, Context context);

    /**
     * Deletes the specified packet capture session.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param packetCaptureName The name of the packet capture session.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(
        String resourceGroupName, String networkWatcherName, String packetCaptureName);

    /**
     * Deletes the specified packet capture session.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param packetCaptureName The name of the packet capture session.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginDeleteAsync(
        String resourceGroupName, String networkWatcherName, String packetCaptureName);

    /**
     * Deletes the specified packet capture session.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param packetCaptureName The name of the packet capture session.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(
        String resourceGroupName, String networkWatcherName, String packetCaptureName);

    /**
     * Deletes the specified packet capture session.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param packetCaptureName The name of the packet capture session.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(
        String resourceGroupName, String networkWatcherName, String packetCaptureName, Context context);

    /**
     * Deletes the specified packet capture session.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param packetCaptureName The name of the packet capture session.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAsync(String resourceGroupName, String networkWatcherName, String packetCaptureName);

    /**
     * Deletes the specified packet capture session.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param packetCaptureName The name of the packet capture session.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String networkWatcherName, String packetCaptureName);

    /**
     * Deletes the specified packet capture session.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param packetCaptureName The name of the packet capture session.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String networkWatcherName, String packetCaptureName, Context context);

    /**
     * Stops a specified packet capture session.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param packetCaptureName The name of the packet capture session.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> stopWithResponseAsync(
        String resourceGroupName, String networkWatcherName, String packetCaptureName);

    /**
     * Stops a specified packet capture session.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param packetCaptureName The name of the packet capture session.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginStopAsync(
        String resourceGroupName, String networkWatcherName, String packetCaptureName);

    /**
     * Stops a specified packet capture session.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param packetCaptureName The name of the packet capture session.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginStop(
        String resourceGroupName, String networkWatcherName, String packetCaptureName);

    /**
     * Stops a specified packet capture session.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param packetCaptureName The name of the packet capture session.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginStop(
        String resourceGroupName, String networkWatcherName, String packetCaptureName, Context context);

    /**
     * Stops a specified packet capture session.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param packetCaptureName The name of the packet capture session.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> stopAsync(String resourceGroupName, String networkWatcherName, String packetCaptureName);

    /**
     * Stops a specified packet capture session.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param packetCaptureName The name of the packet capture session.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void stop(String resourceGroupName, String networkWatcherName, String packetCaptureName);

    /**
     * Stops a specified packet capture session.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param packetCaptureName The name of the packet capture session.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void stop(String resourceGroupName, String networkWatcherName, String packetCaptureName, Context context);

    /**
     * Query the status of a running packet capture session.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the Network Watcher resource.
     * @param packetCaptureName The name given to the packet capture session.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status of packet capture session.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> getStatusWithResponseAsync(
        String resourceGroupName, String networkWatcherName, String packetCaptureName);

    /**
     * Query the status of a running packet capture session.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the Network Watcher resource.
     * @param packetCaptureName The name given to the packet capture session.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status of packet capture session.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<PacketCaptureQueryStatusResultInner>, PacketCaptureQueryStatusResultInner>
        beginGetStatusAsync(String resourceGroupName, String networkWatcherName, String packetCaptureName);

    /**
     * Query the status of a running packet capture session.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the Network Watcher resource.
     * @param packetCaptureName The name given to the packet capture session.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status of packet capture session.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<PacketCaptureQueryStatusResultInner>, PacketCaptureQueryStatusResultInner> beginGetStatus(
        String resourceGroupName, String networkWatcherName, String packetCaptureName);

    /**
     * Query the status of a running packet capture session.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the Network Watcher resource.
     * @param packetCaptureName The name given to the packet capture session.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status of packet capture session.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<PacketCaptureQueryStatusResultInner>, PacketCaptureQueryStatusResultInner> beginGetStatus(
        String resourceGroupName, String networkWatcherName, String packetCaptureName, Context context);

    /**
     * Query the status of a running packet capture session.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the Network Watcher resource.
     * @param packetCaptureName The name given to the packet capture session.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status of packet capture session.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<PacketCaptureQueryStatusResultInner> getStatusAsync(
        String resourceGroupName, String networkWatcherName, String packetCaptureName);

    /**
     * Query the status of a running packet capture session.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the Network Watcher resource.
     * @param packetCaptureName The name given to the packet capture session.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status of packet capture session.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PacketCaptureQueryStatusResultInner getStatus(
        String resourceGroupName, String networkWatcherName, String packetCaptureName);

    /**
     * Query the status of a running packet capture session.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the Network Watcher resource.
     * @param packetCaptureName The name given to the packet capture session.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status of packet capture session.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PacketCaptureQueryStatusResultInner getStatus(
        String resourceGroupName, String networkWatcherName, String packetCaptureName, Context context);

    /**
     * Lists all packet capture sessions within the specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the Network Watcher resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of packet capture sessions.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<PacketCaptureResultInner> listAsync(String resourceGroupName, String networkWatcherName);

    /**
     * Lists all packet capture sessions within the specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the Network Watcher resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of packet capture sessions.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<PacketCaptureResultInner> list(String resourceGroupName, String networkWatcherName);

    /**
     * Lists all packet capture sessions within the specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the Network Watcher resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of packet capture sessions.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<PacketCaptureResultInner> list(String resourceGroupName, String networkWatcherName, Context context);
}
