// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.ApplicationGatewayClientAuthConfiguration;
import com.azure.resourcemanager.network.models.ApplicationGatewaySslPolicy;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Properties of SSL profile of an application gateway. */
@Fluent
public final class ApplicationGatewaySslProfilePropertiesFormat {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ApplicationGatewaySslProfilePropertiesFormat.class);

    /*
     * Array of references to application gateway trusted client certificates.
     */
    @JsonProperty(value = "trustedClientCertificates")
    private List<SubResource> trustedClientCertificates;

    /*
     * SSL policy of the application gateway resource.
     */
    @JsonProperty(value = "sslPolicy")
    private ApplicationGatewaySslPolicy sslPolicy;

    /*
     * Client authentication configuration of the application gateway resource.
     */
    @JsonProperty(value = "clientAuthConfiguration")
    private ApplicationGatewayClientAuthConfiguration clientAuthConfiguration;

    /*
     * The provisioning state of the HTTP listener resource.
     */
    @JsonProperty(value = "provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;

    /**
     * Get the trustedClientCertificates property: Array of references to application gateway trusted client
     * certificates.
     *
     * @return the trustedClientCertificates value.
     */
    public List<SubResource> trustedClientCertificates() {
        return this.trustedClientCertificates;
    }

    /**
     * Set the trustedClientCertificates property: Array of references to application gateway trusted client
     * certificates.
     *
     * @param trustedClientCertificates the trustedClientCertificates value to set.
     * @return the ApplicationGatewaySslProfilePropertiesFormat object itself.
     */
    public ApplicationGatewaySslProfilePropertiesFormat withTrustedClientCertificates(
        List<SubResource> trustedClientCertificates) {
        this.trustedClientCertificates = trustedClientCertificates;
        return this;
    }

    /**
     * Get the sslPolicy property: SSL policy of the application gateway resource.
     *
     * @return the sslPolicy value.
     */
    public ApplicationGatewaySslPolicy sslPolicy() {
        return this.sslPolicy;
    }

    /**
     * Set the sslPolicy property: SSL policy of the application gateway resource.
     *
     * @param sslPolicy the sslPolicy value to set.
     * @return the ApplicationGatewaySslProfilePropertiesFormat object itself.
     */
    public ApplicationGatewaySslProfilePropertiesFormat withSslPolicy(ApplicationGatewaySslPolicy sslPolicy) {
        this.sslPolicy = sslPolicy;
        return this;
    }

    /**
     * Get the clientAuthConfiguration property: Client authentication configuration of the application gateway
     * resource.
     *
     * @return the clientAuthConfiguration value.
     */
    public ApplicationGatewayClientAuthConfiguration clientAuthConfiguration() {
        return this.clientAuthConfiguration;
    }

    /**
     * Set the clientAuthConfiguration property: Client authentication configuration of the application gateway
     * resource.
     *
     * @param clientAuthConfiguration the clientAuthConfiguration value to set.
     * @return the ApplicationGatewaySslProfilePropertiesFormat object itself.
     */
    public ApplicationGatewaySslProfilePropertiesFormat withClientAuthConfiguration(
        ApplicationGatewayClientAuthConfiguration clientAuthConfiguration) {
        this.clientAuthConfiguration = clientAuthConfiguration;
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the HTTP listener resource.
     *
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (sslPolicy() != null) {
            sslPolicy().validate();
        }
        if (clientAuthConfiguration() != null) {
            clientAuthConfiguration().validate();
        }
    }
}
