// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.HubBgpConnectionStatus;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Properties of the bgp connection. */
@Fluent
public final class BgpConnectionProperties {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(BgpConnectionProperties.class);

    /*
     * Peer ASN.
     */
    @JsonProperty(value = "peerAsn")
    private Long peerAsn;

    /*
     * Peer IP.
     */
    @JsonProperty(value = "peerIp")
    private String peerIp;

    /*
     * The reference to the HubVirtualNetworkConnection resource.
     */
    @JsonProperty(value = "hubVirtualNetworkConnection")
    private SubResource hubVirtualNetworkConnection;

    /*
     * The provisioning state of the resource.
     */
    @JsonProperty(value = "provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;

    /*
     * The current state of the VirtualHub to Peer.
     */
    @JsonProperty(value = "connectionState", access = JsonProperty.Access.WRITE_ONLY)
    private HubBgpConnectionStatus connectionState;

    /**
     * Get the peerAsn property: Peer ASN.
     *
     * @return the peerAsn value.
     */
    public Long peerAsn() {
        return this.peerAsn;
    }

    /**
     * Set the peerAsn property: Peer ASN.
     *
     * @param peerAsn the peerAsn value to set.
     * @return the BgpConnectionProperties object itself.
     */
    public BgpConnectionProperties withPeerAsn(Long peerAsn) {
        this.peerAsn = peerAsn;
        return this;
    }

    /**
     * Get the peerIp property: Peer IP.
     *
     * @return the peerIp value.
     */
    public String peerIp() {
        return this.peerIp;
    }

    /**
     * Set the peerIp property: Peer IP.
     *
     * @param peerIp the peerIp value to set.
     * @return the BgpConnectionProperties object itself.
     */
    public BgpConnectionProperties withPeerIp(String peerIp) {
        this.peerIp = peerIp;
        return this;
    }

    /**
     * Get the hubVirtualNetworkConnection property: The reference to the HubVirtualNetworkConnection resource.
     *
     * @return the hubVirtualNetworkConnection value.
     */
    public SubResource hubVirtualNetworkConnection() {
        return this.hubVirtualNetworkConnection;
    }

    /**
     * Set the hubVirtualNetworkConnection property: The reference to the HubVirtualNetworkConnection resource.
     *
     * @param hubVirtualNetworkConnection the hubVirtualNetworkConnection value to set.
     * @return the BgpConnectionProperties object itself.
     */
    public BgpConnectionProperties withHubVirtualNetworkConnection(SubResource hubVirtualNetworkConnection) {
        this.hubVirtualNetworkConnection = hubVirtualNetworkConnection;
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the resource.
     *
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the connectionState property: The current state of the VirtualHub to Peer.
     *
     * @return the connectionState value.
     */
    public HubBgpConnectionStatus connectionState() {
        return this.connectionState;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
