// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.ProtocolCustomSettingsFormat;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** DDoS custom policy properties. */
@Fluent
public final class DdosCustomPolicyPropertiesFormat {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(DdosCustomPolicyPropertiesFormat.class);

    /*
     * The resource GUID property of the DDoS custom policy resource. It
     * uniquely identifies the resource, even if the user changes its name or
     * migrate the resource across subscriptions or resource groups.
     */
    @JsonProperty(value = "resourceGuid", access = JsonProperty.Access.WRITE_ONLY)
    private String resourceGuid;

    /*
     * The provisioning state of the DDoS custom policy resource.
     */
    @JsonProperty(value = "provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;

    /*
     * The list of public IPs associated with the DDoS custom policy resource.
     * This list is read-only.
     */
    @JsonProperty(value = "publicIPAddresses", access = JsonProperty.Access.WRITE_ONLY)
    private List<SubResource> publicIpAddresses;

    /*
     * The protocol-specific DDoS policy customization parameters.
     */
    @JsonProperty(value = "protocolCustomSettings")
    private List<ProtocolCustomSettingsFormat> protocolCustomSettings;

    /**
     * Get the resourceGuid property: The resource GUID property of the DDoS custom policy resource. It uniquely
     * identifies the resource, even if the user changes its name or migrate the resource across subscriptions or
     * resource groups.
     *
     * @return the resourceGuid value.
     */
    public String resourceGuid() {
        return this.resourceGuid;
    }

    /**
     * Get the provisioningState property: The provisioning state of the DDoS custom policy resource.
     *
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the publicIpAddresses property: The list of public IPs associated with the DDoS custom policy resource. This
     * list is read-only.
     *
     * @return the publicIpAddresses value.
     */
    public List<SubResource> publicIpAddresses() {
        return this.publicIpAddresses;
    }

    /**
     * Get the protocolCustomSettings property: The protocol-specific DDoS policy customization parameters.
     *
     * @return the protocolCustomSettings value.
     */
    public List<ProtocolCustomSettingsFormat> protocolCustomSettings() {
        return this.protocolCustomSettings;
    }

    /**
     * Set the protocolCustomSettings property: The protocol-specific DDoS policy customization parameters.
     *
     * @param protocolCustomSettings the protocolCustomSettings value to set.
     * @return the DdosCustomPolicyPropertiesFormat object itself.
     */
    public DdosCustomPolicyPropertiesFormat withProtocolCustomSettings(
        List<ProtocolCustomSettingsFormat> protocolCustomSettings) {
        this.protocolCustomSettings = protocolCustomSettings;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (protocolCustomSettings() != null) {
            protocolCustomSettings().forEach(e -> e.validate());
        }
    }
}
