// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.InboundSecurityRules;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Properties of the Inbound Security Rules resource. */
@Fluent
public final class InboundSecurityRuleProperties {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(InboundSecurityRuleProperties.class);

    /*
     * List of allowed rules.
     */
    @JsonProperty(value = "rules")
    private List<InboundSecurityRules> rules;

    /*
     * The provisioning state of the resource.
     */
    @JsonProperty(value = "provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;

    /**
     * Get the rules property: List of allowed rules.
     *
     * @return the rules value.
     */
    public List<InboundSecurityRules> rules() {
        return this.rules;
    }

    /**
     * Set the rules property: List of allowed rules.
     *
     * @param rules the rules value to set.
     * @return the InboundSecurityRuleProperties object itself.
     */
    public InboundSecurityRuleProperties withRules(List<InboundSecurityRules> rules) {
        this.rules = rules;
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the resource.
     *
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (rules() != null) {
            rules().forEach(e -> e.validate());
        }
    }
}
