// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.RecordSet;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Properties of the private dns zone configuration resource. */
@Fluent
public final class PrivateDnsZonePropertiesFormat {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(PrivateDnsZonePropertiesFormat.class);

    /*
     * The resource id of the private dns zone.
     */
    @JsonProperty(value = "privateDnsZoneId")
    private String privateDnsZoneId;

    /*
     * A collection of information regarding a recordSet, holding information
     * to identify private resources.
     */
    @JsonProperty(value = "recordSets", access = JsonProperty.Access.WRITE_ONLY)
    private List<RecordSet> recordSets;

    /**
     * Get the privateDnsZoneId property: The resource id of the private dns zone.
     *
     * @return the privateDnsZoneId value.
     */
    public String privateDnsZoneId() {
        return this.privateDnsZoneId;
    }

    /**
     * Set the privateDnsZoneId property: The resource id of the private dns zone.
     *
     * @param privateDnsZoneId the privateDnsZoneId value to set.
     * @return the PrivateDnsZonePropertiesFormat object itself.
     */
    public PrivateDnsZonePropertiesFormat withPrivateDnsZoneId(String privateDnsZoneId) {
        this.privateDnsZoneId = privateDnsZoneId;
        return this;
    }

    /**
     * Get the recordSets property: A collection of information regarding a recordSet, holding information to identify
     * private resources.
     *
     * @return the recordSets value.
     */
    public List<RecordSet> recordSets() {
        return this.recordSets;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (recordSets() != null) {
            recordSets().forEach(e -> e.validate());
        }
    }
}
