// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.PrivateLinkServicePropertiesAutoApproval;
import com.azure.resourcemanager.network.models.PrivateLinkServicePropertiesVisibility;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Properties of the private link service. */
@Fluent
public final class PrivateLinkServiceProperties {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(PrivateLinkServiceProperties.class);

    /*
     * An array of references to the load balancer IP configurations.
     */
    @JsonProperty(value = "loadBalancerFrontendIpConfigurations")
    private List<FrontendIpConfigurationInner> loadBalancerFrontendIpConfigurations;

    /*
     * An array of private link service IP configurations.
     */
    @JsonProperty(value = "ipConfigurations")
    private List<PrivateLinkServiceIpConfigurationInner> ipConfigurations;

    /*
     * An array of references to the network interfaces created for this
     * private link service.
     */
    @JsonProperty(value = "networkInterfaces", access = JsonProperty.Access.WRITE_ONLY)
    private List<NetworkInterfaceInner> networkInterfaces;

    /*
     * The provisioning state of the private link service resource.
     */
    @JsonProperty(value = "provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;

    /*
     * An array of list about connections to the private endpoint.
     */
    @JsonProperty(value = "privateEndpointConnections", access = JsonProperty.Access.WRITE_ONLY)
    private List<PrivateEndpointConnectionInner> privateEndpointConnections;

    /*
     * The visibility list of the private link service.
     */
    @JsonProperty(value = "visibility")
    private PrivateLinkServicePropertiesVisibility visibility;

    /*
     * The auto-approval list of the private link service.
     */
    @JsonProperty(value = "autoApproval")
    private PrivateLinkServicePropertiesAutoApproval autoApproval;

    /*
     * The list of Fqdn.
     */
    @JsonProperty(value = "fqdns")
    private List<String> fqdns;

    /*
     * The alias of the private link service.
     */
    @JsonProperty(value = "alias", access = JsonProperty.Access.WRITE_ONLY)
    private String alias;

    /*
     * Whether the private link service is enabled for proxy protocol or not.
     */
    @JsonProperty(value = "enableProxyProtocol")
    private Boolean enableProxyProtocol;

    /**
     * Get the loadBalancerFrontendIpConfigurations property: An array of references to the load balancer IP
     * configurations.
     *
     * @return the loadBalancerFrontendIpConfigurations value.
     */
    public List<FrontendIpConfigurationInner> loadBalancerFrontendIpConfigurations() {
        return this.loadBalancerFrontendIpConfigurations;
    }

    /**
     * Set the loadBalancerFrontendIpConfigurations property: An array of references to the load balancer IP
     * configurations.
     *
     * @param loadBalancerFrontendIpConfigurations the loadBalancerFrontendIpConfigurations value to set.
     * @return the PrivateLinkServiceProperties object itself.
     */
    public PrivateLinkServiceProperties withLoadBalancerFrontendIpConfigurations(
        List<FrontendIpConfigurationInner> loadBalancerFrontendIpConfigurations) {
        this.loadBalancerFrontendIpConfigurations = loadBalancerFrontendIpConfigurations;
        return this;
    }

    /**
     * Get the ipConfigurations property: An array of private link service IP configurations.
     *
     * @return the ipConfigurations value.
     */
    public List<PrivateLinkServiceIpConfigurationInner> ipConfigurations() {
        return this.ipConfigurations;
    }

    /**
     * Set the ipConfigurations property: An array of private link service IP configurations.
     *
     * @param ipConfigurations the ipConfigurations value to set.
     * @return the PrivateLinkServiceProperties object itself.
     */
    public PrivateLinkServiceProperties withIpConfigurations(
        List<PrivateLinkServiceIpConfigurationInner> ipConfigurations) {
        this.ipConfigurations = ipConfigurations;
        return this;
    }

    /**
     * Get the networkInterfaces property: An array of references to the network interfaces created for this private
     * link service.
     *
     * @return the networkInterfaces value.
     */
    public List<NetworkInterfaceInner> networkInterfaces() {
        return this.networkInterfaces;
    }

    /**
     * Get the provisioningState property: The provisioning state of the private link service resource.
     *
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the privateEndpointConnections property: An array of list about connections to the private endpoint.
     *
     * @return the privateEndpointConnections value.
     */
    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    /**
     * Get the visibility property: The visibility list of the private link service.
     *
     * @return the visibility value.
     */
    public PrivateLinkServicePropertiesVisibility visibility() {
        return this.visibility;
    }

    /**
     * Set the visibility property: The visibility list of the private link service.
     *
     * @param visibility the visibility value to set.
     * @return the PrivateLinkServiceProperties object itself.
     */
    public PrivateLinkServiceProperties withVisibility(PrivateLinkServicePropertiesVisibility visibility) {
        this.visibility = visibility;
        return this;
    }

    /**
     * Get the autoApproval property: The auto-approval list of the private link service.
     *
     * @return the autoApproval value.
     */
    public PrivateLinkServicePropertiesAutoApproval autoApproval() {
        return this.autoApproval;
    }

    /**
     * Set the autoApproval property: The auto-approval list of the private link service.
     *
     * @param autoApproval the autoApproval value to set.
     * @return the PrivateLinkServiceProperties object itself.
     */
    public PrivateLinkServiceProperties withAutoApproval(PrivateLinkServicePropertiesAutoApproval autoApproval) {
        this.autoApproval = autoApproval;
        return this;
    }

    /**
     * Get the fqdns property: The list of Fqdn.
     *
     * @return the fqdns value.
     */
    public List<String> fqdns() {
        return this.fqdns;
    }

    /**
     * Set the fqdns property: The list of Fqdn.
     *
     * @param fqdns the fqdns value to set.
     * @return the PrivateLinkServiceProperties object itself.
     */
    public PrivateLinkServiceProperties withFqdns(List<String> fqdns) {
        this.fqdns = fqdns;
        return this;
    }

    /**
     * Get the alias property: The alias of the private link service.
     *
     * @return the alias value.
     */
    public String alias() {
        return this.alias;
    }

    /**
     * Get the enableProxyProtocol property: Whether the private link service is enabled for proxy protocol or not.
     *
     * @return the enableProxyProtocol value.
     */
    public Boolean enableProxyProtocol() {
        return this.enableProxyProtocol;
    }

    /**
     * Set the enableProxyProtocol property: Whether the private link service is enabled for proxy protocol or not.
     *
     * @param enableProxyProtocol the enableProxyProtocol value to set.
     * @return the PrivateLinkServiceProperties object itself.
     */
    public PrivateLinkServiceProperties withEnableProxyProtocol(Boolean enableProxyProtocol) {
        this.enableProxyProtocol = enableProxyProtocol;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (loadBalancerFrontendIpConfigurations() != null) {
            loadBalancerFrontendIpConfigurations().forEach(e -> e.validate());
        }
        if (ipConfigurations() != null) {
            ipConfigurations().forEach(e -> e.validate());
        }
        if (networkInterfaces() != null) {
            networkInterfaces().forEach(e -> e.validate());
        }
        if (privateEndpointConnections() != null) {
            privateEndpointConnections().forEach(e -> e.validate());
        }
        if (visibility() != null) {
            visibility().validate();
        }
        if (autoApproval() != null) {
            autoApproval().validate();
        }
    }
}
