// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.network.fluent.VirtualNetworkGatewayNatRulesClient;
import com.azure.resourcemanager.network.fluent.models.VirtualNetworkGatewayNatRuleInner;
import com.azure.resourcemanager.network.models.ListVirtualNetworkGatewayNatRulesResult;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in VirtualNetworkGatewayNatRulesClient. */
public final class VirtualNetworkGatewayNatRulesClientImpl implements VirtualNetworkGatewayNatRulesClient {
    private final ClientLogger logger = new ClientLogger(VirtualNetworkGatewayNatRulesClientImpl.class);

    /** The proxy service used to perform REST calls. */
    private final VirtualNetworkGatewayNatRulesService service;

    /** The service client containing this operation class. */
    private final NetworkManagementClientImpl client;

    /**
     * Initializes an instance of VirtualNetworkGatewayNatRulesClientImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    VirtualNetworkGatewayNatRulesClientImpl(NetworkManagementClientImpl client) {
        this.service =
            RestProxy
                .create(
                    VirtualNetworkGatewayNatRulesService.class,
                    client.getHttpPipeline(),
                    client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for NetworkManagementClientVirtualNetworkGatewayNatRules to be used by
     * the proxy service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "NetworkManagementCli")
    private interface VirtualNetworkGatewayNatRulesService {
        @Headers({"Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network"
                + "/virtualNetworkGateways/{virtualNetworkGatewayName}/natRules/{natRuleName}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<VirtualNetworkGatewayNatRuleInner>> get(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("virtualNetworkGatewayName") String virtualNetworkGatewayName,
            @PathParam("natRuleName") String natRuleName,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Put(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network"
                + "/virtualNetworkGateways/{virtualNetworkGatewayName}/natRules/{natRuleName}")
        @ExpectedResponses({200, 201})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> createOrUpdate(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("virtualNetworkGatewayName") String virtualNetworkGatewayName,
            @PathParam("natRuleName") String natRuleName,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") VirtualNetworkGatewayNatRuleInner natRuleParameters,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Delete(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network"
                + "/virtualNetworkGateways/{virtualNetworkGatewayName}/natRules/{natRuleName}")
        @ExpectedResponses({200, 202, 204})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> delete(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("virtualNetworkGatewayName") String virtualNetworkGatewayName,
            @PathParam("natRuleName") String natRuleName,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network"
                + "/virtualNetworkGateways/{virtualNetworkGatewayName}/natRules")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ListVirtualNetworkGatewayNatRulesResult>> listByVirtualNetworkGateway(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("virtualNetworkGatewayName") String virtualNetworkGatewayName,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ListVirtualNetworkGatewayNatRulesResult>> listByVirtualNetworkGatewayNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept,
            Context context);
    }

    /**
     * Retrieves the details of a nat rule.
     *
     * @param resourceGroupName The resource group name of the Virtual Network Gateway.
     * @param virtualNetworkGatewayName The name of the gateway.
     * @param natRuleName The name of the nat rule.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return virtualNetworkGatewayNatRule Resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<VirtualNetworkGatewayNatRuleInner>> getWithResponseAsync(
        String resourceGroupName, String virtualNetworkGatewayName, String natRuleName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (virtualNetworkGatewayName == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter virtualNetworkGatewayName is required and cannot be null."));
        }
        if (natRuleName == null) {
            return Mono.error(new IllegalArgumentException("Parameter natRuleName is required and cannot be null."));
        }
        final String apiVersion = "2021-03-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .get(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            virtualNetworkGatewayName,
                            natRuleName,
                            apiVersion,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Retrieves the details of a nat rule.
     *
     * @param resourceGroupName The resource group name of the Virtual Network Gateway.
     * @param virtualNetworkGatewayName The name of the gateway.
     * @param natRuleName The name of the nat rule.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return virtualNetworkGatewayNatRule Resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<VirtualNetworkGatewayNatRuleInner>> getWithResponseAsync(
        String resourceGroupName, String virtualNetworkGatewayName, String natRuleName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (virtualNetworkGatewayName == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter virtualNetworkGatewayName is required and cannot be null."));
        }
        if (natRuleName == null) {
            return Mono.error(new IllegalArgumentException("Parameter natRuleName is required and cannot be null."));
        }
        final String apiVersion = "2021-03-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .get(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                virtualNetworkGatewayName,
                natRuleName,
                apiVersion,
                accept,
                context);
    }

    /**
     * Retrieves the details of a nat rule.
     *
     * @param resourceGroupName The resource group name of the Virtual Network Gateway.
     * @param virtualNetworkGatewayName The name of the gateway.
     * @param natRuleName The name of the nat rule.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return virtualNetworkGatewayNatRule Resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<VirtualNetworkGatewayNatRuleInner> getAsync(
        String resourceGroupName, String virtualNetworkGatewayName, String natRuleName) {
        return getWithResponseAsync(resourceGroupName, virtualNetworkGatewayName, natRuleName)
            .flatMap(
                (Response<VirtualNetworkGatewayNatRuleInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Retrieves the details of a nat rule.
     *
     * @param resourceGroupName The resource group name of the Virtual Network Gateway.
     * @param virtualNetworkGatewayName The name of the gateway.
     * @param natRuleName The name of the nat rule.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return virtualNetworkGatewayNatRule Resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public VirtualNetworkGatewayNatRuleInner get(
        String resourceGroupName, String virtualNetworkGatewayName, String natRuleName) {
        return getAsync(resourceGroupName, virtualNetworkGatewayName, natRuleName).block();
    }

    /**
     * Retrieves the details of a nat rule.
     *
     * @param resourceGroupName The resource group name of the Virtual Network Gateway.
     * @param virtualNetworkGatewayName The name of the gateway.
     * @param natRuleName The name of the nat rule.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return virtualNetworkGatewayNatRule Resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<VirtualNetworkGatewayNatRuleInner> getWithResponse(
        String resourceGroupName, String virtualNetworkGatewayName, String natRuleName, Context context) {
        return getWithResponseAsync(resourceGroupName, virtualNetworkGatewayName, natRuleName, context).block();
    }

    /**
     * Creates a nat rule to a scalable virtual network gateway if it doesn't exist else updates the existing nat rules.
     *
     * @param resourceGroupName The resource group name of the Virtual Network Gateway.
     * @param virtualNetworkGatewayName The name of the gateway.
     * @param natRuleName The name of the nat rule.
     * @param natRuleParameters Parameters supplied to create or Update a Nat Rule.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return virtualNetworkGatewayNatRule Resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(
        String resourceGroupName,
        String virtualNetworkGatewayName,
        String natRuleName,
        VirtualNetworkGatewayNatRuleInner natRuleParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (virtualNetworkGatewayName == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter virtualNetworkGatewayName is required and cannot be null."));
        }
        if (natRuleName == null) {
            return Mono.error(new IllegalArgumentException("Parameter natRuleName is required and cannot be null."));
        }
        if (natRuleParameters == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter natRuleParameters is required and cannot be null."));
        } else {
            natRuleParameters.validate();
        }
        final String apiVersion = "2021-03-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .createOrUpdate(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            virtualNetworkGatewayName,
                            natRuleName,
                            apiVersion,
                            natRuleParameters,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Creates a nat rule to a scalable virtual network gateway if it doesn't exist else updates the existing nat rules.
     *
     * @param resourceGroupName The resource group name of the Virtual Network Gateway.
     * @param virtualNetworkGatewayName The name of the gateway.
     * @param natRuleName The name of the nat rule.
     * @param natRuleParameters Parameters supplied to create or Update a Nat Rule.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return virtualNetworkGatewayNatRule Resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(
        String resourceGroupName,
        String virtualNetworkGatewayName,
        String natRuleName,
        VirtualNetworkGatewayNatRuleInner natRuleParameters,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (virtualNetworkGatewayName == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter virtualNetworkGatewayName is required and cannot be null."));
        }
        if (natRuleName == null) {
            return Mono.error(new IllegalArgumentException("Parameter natRuleName is required and cannot be null."));
        }
        if (natRuleParameters == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter natRuleParameters is required and cannot be null."));
        } else {
            natRuleParameters.validate();
        }
        final String apiVersion = "2021-03-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .createOrUpdate(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                virtualNetworkGatewayName,
                natRuleName,
                apiVersion,
                natRuleParameters,
                accept,
                context);
    }

    /**
     * Creates a nat rule to a scalable virtual network gateway if it doesn't exist else updates the existing nat rules.
     *
     * @param resourceGroupName The resource group name of the Virtual Network Gateway.
     * @param virtualNetworkGatewayName The name of the gateway.
     * @param natRuleName The name of the nat rule.
     * @param natRuleParameters Parameters supplied to create or Update a Nat Rule.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return virtualNetworkGatewayNatRule Resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<VirtualNetworkGatewayNatRuleInner>, VirtualNetworkGatewayNatRuleInner>
        beginCreateOrUpdateAsync(
            String resourceGroupName,
            String virtualNetworkGatewayName,
            String natRuleName,
            VirtualNetworkGatewayNatRuleInner natRuleParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            createOrUpdateWithResponseAsync(
                resourceGroupName, virtualNetworkGatewayName, natRuleName, natRuleParameters);
        return this
            .client
            .<VirtualNetworkGatewayNatRuleInner, VirtualNetworkGatewayNatRuleInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                VirtualNetworkGatewayNatRuleInner.class,
                VirtualNetworkGatewayNatRuleInner.class,
                Context.NONE);
    }

    /**
     * Creates a nat rule to a scalable virtual network gateway if it doesn't exist else updates the existing nat rules.
     *
     * @param resourceGroupName The resource group name of the Virtual Network Gateway.
     * @param virtualNetworkGatewayName The name of the gateway.
     * @param natRuleName The name of the nat rule.
     * @param natRuleParameters Parameters supplied to create or Update a Nat Rule.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return virtualNetworkGatewayNatRule Resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<VirtualNetworkGatewayNatRuleInner>, VirtualNetworkGatewayNatRuleInner>
        beginCreateOrUpdateAsync(
            String resourceGroupName,
            String virtualNetworkGatewayName,
            String natRuleName,
            VirtualNetworkGatewayNatRuleInner natRuleParameters,
            Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            createOrUpdateWithResponseAsync(
                resourceGroupName, virtualNetworkGatewayName, natRuleName, natRuleParameters, context);
        return this
            .client
            .<VirtualNetworkGatewayNatRuleInner, VirtualNetworkGatewayNatRuleInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                VirtualNetworkGatewayNatRuleInner.class,
                VirtualNetworkGatewayNatRuleInner.class,
                context);
    }

    /**
     * Creates a nat rule to a scalable virtual network gateway if it doesn't exist else updates the existing nat rules.
     *
     * @param resourceGroupName The resource group name of the Virtual Network Gateway.
     * @param virtualNetworkGatewayName The name of the gateway.
     * @param natRuleName The name of the nat rule.
     * @param natRuleParameters Parameters supplied to create or Update a Nat Rule.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return virtualNetworkGatewayNatRule Resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<VirtualNetworkGatewayNatRuleInner>, VirtualNetworkGatewayNatRuleInner>
        beginCreateOrUpdate(
            String resourceGroupName,
            String virtualNetworkGatewayName,
            String natRuleName,
            VirtualNetworkGatewayNatRuleInner natRuleParameters) {
        return beginCreateOrUpdateAsync(resourceGroupName, virtualNetworkGatewayName, natRuleName, natRuleParameters)
            .getSyncPoller();
    }

    /**
     * Creates a nat rule to a scalable virtual network gateway if it doesn't exist else updates the existing nat rules.
     *
     * @param resourceGroupName The resource group name of the Virtual Network Gateway.
     * @param virtualNetworkGatewayName The name of the gateway.
     * @param natRuleName The name of the nat rule.
     * @param natRuleParameters Parameters supplied to create or Update a Nat Rule.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return virtualNetworkGatewayNatRule Resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<VirtualNetworkGatewayNatRuleInner>, VirtualNetworkGatewayNatRuleInner>
        beginCreateOrUpdate(
            String resourceGroupName,
            String virtualNetworkGatewayName,
            String natRuleName,
            VirtualNetworkGatewayNatRuleInner natRuleParameters,
            Context context) {
        return beginCreateOrUpdateAsync(
                resourceGroupName, virtualNetworkGatewayName, natRuleName, natRuleParameters, context)
            .getSyncPoller();
    }

    /**
     * Creates a nat rule to a scalable virtual network gateway if it doesn't exist else updates the existing nat rules.
     *
     * @param resourceGroupName The resource group name of the Virtual Network Gateway.
     * @param virtualNetworkGatewayName The name of the gateway.
     * @param natRuleName The name of the nat rule.
     * @param natRuleParameters Parameters supplied to create or Update a Nat Rule.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return virtualNetworkGatewayNatRule Resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<VirtualNetworkGatewayNatRuleInner> createOrUpdateAsync(
        String resourceGroupName,
        String virtualNetworkGatewayName,
        String natRuleName,
        VirtualNetworkGatewayNatRuleInner natRuleParameters) {
        return beginCreateOrUpdateAsync(resourceGroupName, virtualNetworkGatewayName, natRuleName, natRuleParameters)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Creates a nat rule to a scalable virtual network gateway if it doesn't exist else updates the existing nat rules.
     *
     * @param resourceGroupName The resource group name of the Virtual Network Gateway.
     * @param virtualNetworkGatewayName The name of the gateway.
     * @param natRuleName The name of the nat rule.
     * @param natRuleParameters Parameters supplied to create or Update a Nat Rule.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return virtualNetworkGatewayNatRule Resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<VirtualNetworkGatewayNatRuleInner> createOrUpdateAsync(
        String resourceGroupName,
        String virtualNetworkGatewayName,
        String natRuleName,
        VirtualNetworkGatewayNatRuleInner natRuleParameters,
        Context context) {
        return beginCreateOrUpdateAsync(
                resourceGroupName, virtualNetworkGatewayName, natRuleName, natRuleParameters, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Creates a nat rule to a scalable virtual network gateway if it doesn't exist else updates the existing nat rules.
     *
     * @param resourceGroupName The resource group name of the Virtual Network Gateway.
     * @param virtualNetworkGatewayName The name of the gateway.
     * @param natRuleName The name of the nat rule.
     * @param natRuleParameters Parameters supplied to create or Update a Nat Rule.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return virtualNetworkGatewayNatRule Resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public VirtualNetworkGatewayNatRuleInner createOrUpdate(
        String resourceGroupName,
        String virtualNetworkGatewayName,
        String natRuleName,
        VirtualNetworkGatewayNatRuleInner natRuleParameters) {
        return createOrUpdateAsync(resourceGroupName, virtualNetworkGatewayName, natRuleName, natRuleParameters)
            .block();
    }

    /**
     * Creates a nat rule to a scalable virtual network gateway if it doesn't exist else updates the existing nat rules.
     *
     * @param resourceGroupName The resource group name of the Virtual Network Gateway.
     * @param virtualNetworkGatewayName The name of the gateway.
     * @param natRuleName The name of the nat rule.
     * @param natRuleParameters Parameters supplied to create or Update a Nat Rule.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return virtualNetworkGatewayNatRule Resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public VirtualNetworkGatewayNatRuleInner createOrUpdate(
        String resourceGroupName,
        String virtualNetworkGatewayName,
        String natRuleName,
        VirtualNetworkGatewayNatRuleInner natRuleParameters,
        Context context) {
        return createOrUpdateAsync(
                resourceGroupName, virtualNetworkGatewayName, natRuleName, natRuleParameters, context)
            .block();
    }

    /**
     * Deletes a nat rule.
     *
     * @param resourceGroupName The resource group name of the Virtual Network Gateway.
     * @param virtualNetworkGatewayName The name of the gateway.
     * @param natRuleName The name of the nat rule.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(
        String resourceGroupName, String virtualNetworkGatewayName, String natRuleName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (virtualNetworkGatewayName == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter virtualNetworkGatewayName is required and cannot be null."));
        }
        if (natRuleName == null) {
            return Mono.error(new IllegalArgumentException("Parameter natRuleName is required and cannot be null."));
        }
        final String apiVersion = "2021-03-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .delete(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            virtualNetworkGatewayName,
                            natRuleName,
                            apiVersion,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Deletes a nat rule.
     *
     * @param resourceGroupName The resource group name of the Virtual Network Gateway.
     * @param virtualNetworkGatewayName The name of the gateway.
     * @param natRuleName The name of the nat rule.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(
        String resourceGroupName, String virtualNetworkGatewayName, String natRuleName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (virtualNetworkGatewayName == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter virtualNetworkGatewayName is required and cannot be null."));
        }
        if (natRuleName == null) {
            return Mono.error(new IllegalArgumentException("Parameter natRuleName is required and cannot be null."));
        }
        final String apiVersion = "2021-03-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .delete(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                virtualNetworkGatewayName,
                natRuleName,
                apiVersion,
                accept,
                context);
    }

    /**
     * Deletes a nat rule.
     *
     * @param resourceGroupName The resource group name of the Virtual Network Gateway.
     * @param virtualNetworkGatewayName The name of the gateway.
     * @param natRuleName The name of the nat rule.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(
        String resourceGroupName, String virtualNetworkGatewayName, String natRuleName) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            deleteWithResponseAsync(resourceGroupName, virtualNetworkGatewayName, natRuleName);
        return this
            .client
            .<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class, Context.NONE);
    }

    /**
     * Deletes a nat rule.
     *
     * @param resourceGroupName The resource group name of the Virtual Network Gateway.
     * @param virtualNetworkGatewayName The name of the gateway.
     * @param natRuleName The name of the nat rule.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(
        String resourceGroupName, String virtualNetworkGatewayName, String natRuleName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            deleteWithResponseAsync(resourceGroupName, virtualNetworkGatewayName, natRuleName, context);
        return this
            .client
            .<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class, context);
    }

    /**
     * Deletes a nat rule.
     *
     * @param resourceGroupName The resource group name of the Virtual Network Gateway.
     * @param virtualNetworkGatewayName The name of the gateway.
     * @param natRuleName The name of the nat rule.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(
        String resourceGroupName, String virtualNetworkGatewayName, String natRuleName) {
        return beginDeleteAsync(resourceGroupName, virtualNetworkGatewayName, natRuleName).getSyncPoller();
    }

    /**
     * Deletes a nat rule.
     *
     * @param resourceGroupName The resource group name of the Virtual Network Gateway.
     * @param virtualNetworkGatewayName The name of the gateway.
     * @param natRuleName The name of the nat rule.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(
        String resourceGroupName, String virtualNetworkGatewayName, String natRuleName, Context context) {
        return beginDeleteAsync(resourceGroupName, virtualNetworkGatewayName, natRuleName, context).getSyncPoller();
    }

    /**
     * Deletes a nat rule.
     *
     * @param resourceGroupName The resource group name of the Virtual Network Gateway.
     * @param virtualNetworkGatewayName The name of the gateway.
     * @param natRuleName The name of the nat rule.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String virtualNetworkGatewayName, String natRuleName) {
        return beginDeleteAsync(resourceGroupName, virtualNetworkGatewayName, natRuleName)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes a nat rule.
     *
     * @param resourceGroupName The resource group name of the Virtual Network Gateway.
     * @param virtualNetworkGatewayName The name of the gateway.
     * @param natRuleName The name of the nat rule.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteAsync(
        String resourceGroupName, String virtualNetworkGatewayName, String natRuleName, Context context) {
        return beginDeleteAsync(resourceGroupName, virtualNetworkGatewayName, natRuleName, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes a nat rule.
     *
     * @param resourceGroupName The resource group name of the Virtual Network Gateway.
     * @param virtualNetworkGatewayName The name of the gateway.
     * @param natRuleName The name of the nat rule.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String virtualNetworkGatewayName, String natRuleName) {
        deleteAsync(resourceGroupName, virtualNetworkGatewayName, natRuleName).block();
    }

    /**
     * Deletes a nat rule.
     *
     * @param resourceGroupName The resource group name of the Virtual Network Gateway.
     * @param virtualNetworkGatewayName The name of the gateway.
     * @param natRuleName The name of the nat rule.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(
        String resourceGroupName, String virtualNetworkGatewayName, String natRuleName, Context context) {
        deleteAsync(resourceGroupName, virtualNetworkGatewayName, natRuleName, context).block();
    }

    /**
     * Retrieves all nat rules for a particular virtual network gateway.
     *
     * @param resourceGroupName The resource group name of the virtual network gateway.
     * @param virtualNetworkGatewayName The name of the gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list all nat rules to a virtual network gateway.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<VirtualNetworkGatewayNatRuleInner>> listByVirtualNetworkGatewaySinglePageAsync(
        String resourceGroupName, String virtualNetworkGatewayName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (virtualNetworkGatewayName == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter virtualNetworkGatewayName is required and cannot be null."));
        }
        final String apiVersion = "2021-03-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listByVirtualNetworkGateway(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            virtualNetworkGatewayName,
                            apiVersion,
                            accept,
                            context))
            .<PagedResponse<VirtualNetworkGatewayNatRuleInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Retrieves all nat rules for a particular virtual network gateway.
     *
     * @param resourceGroupName The resource group name of the virtual network gateway.
     * @param virtualNetworkGatewayName The name of the gateway.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list all nat rules to a virtual network gateway.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<VirtualNetworkGatewayNatRuleInner>> listByVirtualNetworkGatewaySinglePageAsync(
        String resourceGroupName, String virtualNetworkGatewayName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (virtualNetworkGatewayName == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter virtualNetworkGatewayName is required and cannot be null."));
        }
        final String apiVersion = "2021-03-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listByVirtualNetworkGateway(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                virtualNetworkGatewayName,
                apiVersion,
                accept,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Retrieves all nat rules for a particular virtual network gateway.
     *
     * @param resourceGroupName The resource group name of the virtual network gateway.
     * @param virtualNetworkGatewayName The name of the gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list all nat rules to a virtual network gateway.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<VirtualNetworkGatewayNatRuleInner> listByVirtualNetworkGatewayAsync(
        String resourceGroupName, String virtualNetworkGatewayName) {
        return new PagedFlux<>(
            () -> listByVirtualNetworkGatewaySinglePageAsync(resourceGroupName, virtualNetworkGatewayName),
            nextLink -> listByVirtualNetworkGatewayNextSinglePageAsync(nextLink));
    }

    /**
     * Retrieves all nat rules for a particular virtual network gateway.
     *
     * @param resourceGroupName The resource group name of the virtual network gateway.
     * @param virtualNetworkGatewayName The name of the gateway.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list all nat rules to a virtual network gateway.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<VirtualNetworkGatewayNatRuleInner> listByVirtualNetworkGatewayAsync(
        String resourceGroupName, String virtualNetworkGatewayName, Context context) {
        return new PagedFlux<>(
            () -> listByVirtualNetworkGatewaySinglePageAsync(resourceGroupName, virtualNetworkGatewayName, context),
            nextLink -> listByVirtualNetworkGatewayNextSinglePageAsync(nextLink, context));
    }

    /**
     * Retrieves all nat rules for a particular virtual network gateway.
     *
     * @param resourceGroupName The resource group name of the virtual network gateway.
     * @param virtualNetworkGatewayName The name of the gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list all nat rules to a virtual network gateway.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<VirtualNetworkGatewayNatRuleInner> listByVirtualNetworkGateway(
        String resourceGroupName, String virtualNetworkGatewayName) {
        return new PagedIterable<>(listByVirtualNetworkGatewayAsync(resourceGroupName, virtualNetworkGatewayName));
    }

    /**
     * Retrieves all nat rules for a particular virtual network gateway.
     *
     * @param resourceGroupName The resource group name of the virtual network gateway.
     * @param virtualNetworkGatewayName The name of the gateway.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list all nat rules to a virtual network gateway.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<VirtualNetworkGatewayNatRuleInner> listByVirtualNetworkGateway(
        String resourceGroupName, String virtualNetworkGatewayName, Context context) {
        return new PagedIterable<>(
            listByVirtualNetworkGatewayAsync(resourceGroupName, virtualNetworkGatewayName, context));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list all nat rules to a virtual network gateway.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<VirtualNetworkGatewayNatRuleInner>> listByVirtualNetworkGatewayNextSinglePageAsync(
        String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service.listByVirtualNetworkGatewayNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<VirtualNetworkGatewayNatRuleInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list all nat rules to a virtual network gateway.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<VirtualNetworkGatewayNatRuleInner>> listByVirtualNetworkGatewayNextSinglePageAsync(
        String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listByVirtualNetworkGatewayNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }
}
