// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Log Analytics Resources for Firewall Policy Insights. */
@Fluent
public final class FirewallPolicyLogAnalyticsResources {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(FirewallPolicyLogAnalyticsResources.class);

    /*
     * List of workspaces for Firewall Policy Insights.
     */
    @JsonProperty(value = "workspaces")
    private List<FirewallPolicyLogAnalyticsWorkspace> workspaces;

    /*
     * The default workspace Id for Firewall Policy Insights.
     */
    @JsonProperty(value = "defaultWorkspaceId")
    private SubResource defaultWorkspaceId;

    /**
     * Get the workspaces property: List of workspaces for Firewall Policy Insights.
     *
     * @return the workspaces value.
     */
    public List<FirewallPolicyLogAnalyticsWorkspace> workspaces() {
        return this.workspaces;
    }

    /**
     * Set the workspaces property: List of workspaces for Firewall Policy Insights.
     *
     * @param workspaces the workspaces value to set.
     * @return the FirewallPolicyLogAnalyticsResources object itself.
     */
    public FirewallPolicyLogAnalyticsResources withWorkspaces(List<FirewallPolicyLogAnalyticsWorkspace> workspaces) {
        this.workspaces = workspaces;
        return this;
    }

    /**
     * Get the defaultWorkspaceId property: The default workspace Id for Firewall Policy Insights.
     *
     * @return the defaultWorkspaceId value.
     */
    public SubResource defaultWorkspaceId() {
        return this.defaultWorkspaceId;
    }

    /**
     * Set the defaultWorkspaceId property: The default workspace Id for Firewall Policy Insights.
     *
     * @param defaultWorkspaceId the defaultWorkspaceId value to set.
     * @return the FirewallPolicyLogAnalyticsResources object itself.
     */
    public FirewallPolicyLogAnalyticsResources withDefaultWorkspaceId(SubResource defaultWorkspaceId) {
        this.defaultWorkspaceId = defaultWorkspaceId;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (workspaces() != null) {
            workspaces().forEach(e -> e.validate());
        }
    }
}
