/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.fluent.models.SubnetInner;
import com.azure.resourcemanager.network.fluent.models.VirtualNetworkPeeringInner;
import com.azure.resourcemanager.network.fluent.models.VirtualNetworkPropertiesFormat;
import com.azure.resourcemanager.network.models.AddressSpace;
import com.azure.resourcemanager.network.models.DhcpOptions;
import com.azure.resourcemanager.network.models.ExtendedLocation;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.VirtualNetworkBgpCommunities;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

public final class VirtualNetworkInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(VirtualNetworkInner.class);
    @JsonProperty(value="extendedLocation")
    private ExtendedLocation extendedLocation;
    @JsonProperty(value="properties")
    private VirtualNetworkPropertiesFormat innerProperties;
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="id")
    private String id;

    public ExtendedLocation extendedLocation() {
        return this.extendedLocation;
    }

    public VirtualNetworkInner withExtendedLocation(ExtendedLocation extendedLocation) {
        this.extendedLocation = extendedLocation;
        return this;
    }

    private VirtualNetworkPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    public String etag() {
        return this.etag;
    }

    public String id() {
        return this.id;
    }

    public VirtualNetworkInner withId(String id) {
        this.id = id;
        return this;
    }

    public VirtualNetworkInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public VirtualNetworkInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public AddressSpace addressSpace() {
        return this.innerProperties() == null ? null : this.innerProperties().addressSpace();
    }

    public VirtualNetworkInner withAddressSpace(AddressSpace addressSpace) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkPropertiesFormat();
        }
        this.innerProperties().withAddressSpace(addressSpace);
        return this;
    }

    public DhcpOptions dhcpOptions() {
        return this.innerProperties() == null ? null : this.innerProperties().dhcpOptions();
    }

    public VirtualNetworkInner withDhcpOptions(DhcpOptions dhcpOptions) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkPropertiesFormat();
        }
        this.innerProperties().withDhcpOptions(dhcpOptions);
        return this;
    }

    public Integer flowTimeoutInMinutes() {
        return this.innerProperties() == null ? null : this.innerProperties().flowTimeoutInMinutes();
    }

    public VirtualNetworkInner withFlowTimeoutInMinutes(Integer flowTimeoutInMinutes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkPropertiesFormat();
        }
        this.innerProperties().withFlowTimeoutInMinutes(flowTimeoutInMinutes);
        return this;
    }

    public List<SubnetInner> subnets() {
        return this.innerProperties() == null ? null : this.innerProperties().subnets();
    }

    public VirtualNetworkInner withSubnets(List<SubnetInner> subnets) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkPropertiesFormat();
        }
        this.innerProperties().withSubnets(subnets);
        return this;
    }

    public List<VirtualNetworkPeeringInner> virtualNetworkPeerings() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualNetworkPeerings();
    }

    public VirtualNetworkInner withVirtualNetworkPeerings(List<VirtualNetworkPeeringInner> virtualNetworkPeerings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkPropertiesFormat();
        }
        this.innerProperties().withVirtualNetworkPeerings(virtualNetworkPeerings);
        return this;
    }

    public String resourceGuid() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceGuid();
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public Boolean enableDdosProtection() {
        return this.innerProperties() == null ? null : this.innerProperties().enableDdosProtection();
    }

    public VirtualNetworkInner withEnableDdosProtection(Boolean enableDdosProtection) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkPropertiesFormat();
        }
        this.innerProperties().withEnableDdosProtection(enableDdosProtection);
        return this;
    }

    public Boolean enableVmProtection() {
        return this.innerProperties() == null ? null : this.innerProperties().enableVmProtection();
    }

    public VirtualNetworkInner withEnableVmProtection(Boolean enableVmProtection) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkPropertiesFormat();
        }
        this.innerProperties().withEnableVmProtection(enableVmProtection);
        return this;
    }

    public SubResource ddosProtectionPlan() {
        return this.innerProperties() == null ? null : this.innerProperties().ddosProtectionPlan();
    }

    public VirtualNetworkInner withDdosProtectionPlan(SubResource ddosProtectionPlan) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkPropertiesFormat();
        }
        this.innerProperties().withDdosProtectionPlan(ddosProtectionPlan);
        return this;
    }

    public VirtualNetworkBgpCommunities bgpCommunities() {
        return this.innerProperties() == null ? null : this.innerProperties().bgpCommunities();
    }

    public VirtualNetworkInner withBgpCommunities(VirtualNetworkBgpCommunities bgpCommunities) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkPropertiesFormat();
        }
        this.innerProperties().withBgpCommunities(bgpCommunities);
        return this;
    }

    public List<SubResource> ipAllocations() {
        return this.innerProperties() == null ? null : this.innerProperties().ipAllocations();
    }

    public VirtualNetworkInner withIpAllocations(List<SubResource> ipAllocations) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkPropertiesFormat();
        }
        this.innerProperties().withIpAllocations(ipAllocations);
        return this;
    }

    public void validate() {
        if (this.extendedLocation() != null) {
            this.extendedLocation().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

