/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.fluent.models.SubnetInner;
import com.azure.resourcemanager.network.fluent.models.VirtualNetworkPeeringInner;
import com.azure.resourcemanager.network.models.AddressSpace;
import com.azure.resourcemanager.network.models.DhcpOptions;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.VirtualNetworkBgpCommunities;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class VirtualNetworkPropertiesFormat {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(VirtualNetworkPropertiesFormat.class);
    @JsonProperty(value="addressSpace")
    private AddressSpace addressSpace;
    @JsonProperty(value="dhcpOptions")
    private DhcpOptions dhcpOptions;
    @JsonProperty(value="flowTimeoutInMinutes")
    private Integer flowTimeoutInMinutes;
    @JsonProperty(value="subnets")
    private List<SubnetInner> subnets;
    @JsonProperty(value="virtualNetworkPeerings")
    private List<VirtualNetworkPeeringInner> virtualNetworkPeerings;
    @JsonProperty(value="resourceGuid", access=JsonProperty.Access.WRITE_ONLY)
    private String resourceGuid;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="enableDdosProtection")
    private Boolean enableDdosProtection;
    @JsonProperty(value="enableVmProtection")
    private Boolean enableVmProtection;
    @JsonProperty(value="ddosProtectionPlan")
    private SubResource ddosProtectionPlan;
    @JsonProperty(value="bgpCommunities")
    private VirtualNetworkBgpCommunities bgpCommunities;
    @JsonProperty(value="ipAllocations")
    private List<SubResource> ipAllocations;

    public AddressSpace addressSpace() {
        return this.addressSpace;
    }

    public VirtualNetworkPropertiesFormat withAddressSpace(AddressSpace addressSpace) {
        this.addressSpace = addressSpace;
        return this;
    }

    public DhcpOptions dhcpOptions() {
        return this.dhcpOptions;
    }

    public VirtualNetworkPropertiesFormat withDhcpOptions(DhcpOptions dhcpOptions) {
        this.dhcpOptions = dhcpOptions;
        return this;
    }

    public Integer flowTimeoutInMinutes() {
        return this.flowTimeoutInMinutes;
    }

    public VirtualNetworkPropertiesFormat withFlowTimeoutInMinutes(Integer flowTimeoutInMinutes) {
        this.flowTimeoutInMinutes = flowTimeoutInMinutes;
        return this;
    }

    public List<SubnetInner> subnets() {
        return this.subnets;
    }

    public VirtualNetworkPropertiesFormat withSubnets(List<SubnetInner> subnets) {
        this.subnets = subnets;
        return this;
    }

    public List<VirtualNetworkPeeringInner> virtualNetworkPeerings() {
        return this.virtualNetworkPeerings;
    }

    public VirtualNetworkPropertiesFormat withVirtualNetworkPeerings(List<VirtualNetworkPeeringInner> virtualNetworkPeerings) {
        this.virtualNetworkPeerings = virtualNetworkPeerings;
        return this;
    }

    public String resourceGuid() {
        return this.resourceGuid;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public Boolean enableDdosProtection() {
        return this.enableDdosProtection;
    }

    public VirtualNetworkPropertiesFormat withEnableDdosProtection(Boolean enableDdosProtection) {
        this.enableDdosProtection = enableDdosProtection;
        return this;
    }

    public Boolean enableVmProtection() {
        return this.enableVmProtection;
    }

    public VirtualNetworkPropertiesFormat withEnableVmProtection(Boolean enableVmProtection) {
        this.enableVmProtection = enableVmProtection;
        return this;
    }

    public SubResource ddosProtectionPlan() {
        return this.ddosProtectionPlan;
    }

    public VirtualNetworkPropertiesFormat withDdosProtectionPlan(SubResource ddosProtectionPlan) {
        this.ddosProtectionPlan = ddosProtectionPlan;
        return this;
    }

    public VirtualNetworkBgpCommunities bgpCommunities() {
        return this.bgpCommunities;
    }

    public VirtualNetworkPropertiesFormat withBgpCommunities(VirtualNetworkBgpCommunities bgpCommunities) {
        this.bgpCommunities = bgpCommunities;
        return this;
    }

    public List<SubResource> ipAllocations() {
        return this.ipAllocations;
    }

    public VirtualNetworkPropertiesFormat withIpAllocations(List<SubResource> ipAllocations) {
        this.ipAllocations = ipAllocations;
        return this;
    }

    public void validate() {
        if (this.addressSpace() != null) {
            this.addressSpace().validate();
        }
        if (this.dhcpOptions() != null) {
            this.dhcpOptions().validate();
        }
        if (this.subnets() != null) {
            this.subnets().forEach(e -> e.validate());
        }
        if (this.virtualNetworkPeerings() != null) {
            this.virtualNetworkPeerings().forEach(e -> e.validate());
        }
        if (this.bgpCommunities() != null) {
            this.bgpCommunities().validate();
        }
    }
}

