/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.network.fluent.FirewallPolicyRuleCollectionGroupsClient;
import com.azure.resourcemanager.network.fluent.models.FirewallPolicyRuleCollectionGroupInner;
import com.azure.resourcemanager.network.implementation.NetworkManagementClientImpl;
import com.azure.resourcemanager.network.models.FirewallPolicyRuleCollectionGroupListResult;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class FirewallPolicyRuleCollectionGroupsClientImpl
implements FirewallPolicyRuleCollectionGroupsClient {
    private final ClientLogger logger = new ClientLogger(FirewallPolicyRuleCollectionGroupsClientImpl.class);
    private final FirewallPolicyRuleCollectionGroupsService service;
    private final NetworkManagementClientImpl client;

    FirewallPolicyRuleCollectionGroupsClientImpl(NetworkManagementClientImpl client) {
        this.service = (FirewallPolicyRuleCollectionGroupsService)RestProxy.create(FirewallPolicyRuleCollectionGroupsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String firewallPolicyName, String ruleCollectionGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (firewallPolicyName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter firewallPolicyName is required and cannot be null."));
        }
        if (ruleCollectionGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ruleCollectionGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-03-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, firewallPolicyName, ruleCollectionGroupName, "2021-03-01", this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String firewallPolicyName, String ruleCollectionGroupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (firewallPolicyName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter firewallPolicyName is required and cannot be null."));
        }
        if (ruleCollectionGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ruleCollectionGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-03-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, firewallPolicyName, ruleCollectionGroupName, "2021-03-01", this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String firewallPolicyName, String ruleCollectionGroupName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, firewallPolicyName, ruleCollectionGroupName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String firewallPolicyName, String ruleCollectionGroupName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, firewallPolicyName, ruleCollectionGroupName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String firewallPolicyName, String ruleCollectionGroupName) {
        return this.beginDeleteAsync(resourceGroupName, firewallPolicyName, ruleCollectionGroupName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String firewallPolicyName, String ruleCollectionGroupName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, firewallPolicyName, ruleCollectionGroupName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String firewallPolicyName, String ruleCollectionGroupName) {
        return this.beginDeleteAsync(resourceGroupName, firewallPolicyName, ruleCollectionGroupName).last().flatMap(arg_0 -> ((NetworkManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String firewallPolicyName, String ruleCollectionGroupName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, firewallPolicyName, ruleCollectionGroupName, context).last().flatMap(arg_0 -> ((NetworkManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String firewallPolicyName, String ruleCollectionGroupName) {
        this.deleteAsync(resourceGroupName, firewallPolicyName, ruleCollectionGroupName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String firewallPolicyName, String ruleCollectionGroupName, Context context) {
        this.deleteAsync(resourceGroupName, firewallPolicyName, ruleCollectionGroupName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<FirewallPolicyRuleCollectionGroupInner>> getWithResponseAsync(String resourceGroupName, String firewallPolicyName, String ruleCollectionGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (firewallPolicyName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter firewallPolicyName is required and cannot be null."));
        }
        if (ruleCollectionGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ruleCollectionGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-03-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, firewallPolicyName, ruleCollectionGroupName, "2021-03-01", this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<FirewallPolicyRuleCollectionGroupInner>> getWithResponseAsync(String resourceGroupName, String firewallPolicyName, String ruleCollectionGroupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (firewallPolicyName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter firewallPolicyName is required and cannot be null."));
        }
        if (ruleCollectionGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ruleCollectionGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-03-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, firewallPolicyName, ruleCollectionGroupName, "2021-03-01", this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<FirewallPolicyRuleCollectionGroupInner> getAsync(String resourceGroupName, String firewallPolicyName, String ruleCollectionGroupName) {
        return this.getWithResponseAsync(resourceGroupName, firewallPolicyName, ruleCollectionGroupName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((FirewallPolicyRuleCollectionGroupInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public FirewallPolicyRuleCollectionGroupInner get(String resourceGroupName, String firewallPolicyName, String ruleCollectionGroupName) {
        return (FirewallPolicyRuleCollectionGroupInner)((Object)this.getAsync(resourceGroupName, firewallPolicyName, ruleCollectionGroupName).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<FirewallPolicyRuleCollectionGroupInner> getWithResponse(String resourceGroupName, String firewallPolicyName, String ruleCollectionGroupName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, firewallPolicyName, ruleCollectionGroupName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String firewallPolicyName, String ruleCollectionGroupName, FirewallPolicyRuleCollectionGroupInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (firewallPolicyName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter firewallPolicyName is required and cannot be null."));
        }
        if (ruleCollectionGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ruleCollectionGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2021-03-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, firewallPolicyName, ruleCollectionGroupName, "2021-03-01", this.client.getSubscriptionId(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String firewallPolicyName, String ruleCollectionGroupName, FirewallPolicyRuleCollectionGroupInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (firewallPolicyName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter firewallPolicyName is required and cannot be null."));
        }
        if (ruleCollectionGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ruleCollectionGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2021-03-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, firewallPolicyName, ruleCollectionGroupName, "2021-03-01", this.client.getSubscriptionId(), parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<FirewallPolicyRuleCollectionGroupInner>, FirewallPolicyRuleCollectionGroupInner> beginCreateOrUpdateAsync(String resourceGroupName, String firewallPolicyName, String ruleCollectionGroupName, FirewallPolicyRuleCollectionGroupInner parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, firewallPolicyName, ruleCollectionGroupName, parameters);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)FirewallPolicyRuleCollectionGroupInner.class), (Type)((Object)FirewallPolicyRuleCollectionGroupInner.class), Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<FirewallPolicyRuleCollectionGroupInner>, FirewallPolicyRuleCollectionGroupInner> beginCreateOrUpdateAsync(String resourceGroupName, String firewallPolicyName, String ruleCollectionGroupName, FirewallPolicyRuleCollectionGroupInner parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, firewallPolicyName, ruleCollectionGroupName, parameters, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)FirewallPolicyRuleCollectionGroupInner.class), (Type)((Object)FirewallPolicyRuleCollectionGroupInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<FirewallPolicyRuleCollectionGroupInner>, FirewallPolicyRuleCollectionGroupInner> beginCreateOrUpdate(String resourceGroupName, String firewallPolicyName, String ruleCollectionGroupName, FirewallPolicyRuleCollectionGroupInner parameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, firewallPolicyName, ruleCollectionGroupName, parameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<FirewallPolicyRuleCollectionGroupInner>, FirewallPolicyRuleCollectionGroupInner> beginCreateOrUpdate(String resourceGroupName, String firewallPolicyName, String ruleCollectionGroupName, FirewallPolicyRuleCollectionGroupInner parameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, firewallPolicyName, ruleCollectionGroupName, parameters, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<FirewallPolicyRuleCollectionGroupInner> createOrUpdateAsync(String resourceGroupName, String firewallPolicyName, String ruleCollectionGroupName, FirewallPolicyRuleCollectionGroupInner parameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, firewallPolicyName, ruleCollectionGroupName, parameters).last().flatMap(arg_0 -> ((NetworkManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<FirewallPolicyRuleCollectionGroupInner> createOrUpdateAsync(String resourceGroupName, String firewallPolicyName, String ruleCollectionGroupName, FirewallPolicyRuleCollectionGroupInner parameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, firewallPolicyName, ruleCollectionGroupName, parameters, context).last().flatMap(arg_0 -> ((NetworkManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public FirewallPolicyRuleCollectionGroupInner createOrUpdate(String resourceGroupName, String firewallPolicyName, String ruleCollectionGroupName, FirewallPolicyRuleCollectionGroupInner parameters) {
        return (FirewallPolicyRuleCollectionGroupInner)((Object)this.createOrUpdateAsync(resourceGroupName, firewallPolicyName, ruleCollectionGroupName, parameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public FirewallPolicyRuleCollectionGroupInner createOrUpdate(String resourceGroupName, String firewallPolicyName, String ruleCollectionGroupName, FirewallPolicyRuleCollectionGroupInner parameters, Context context) {
        return (FirewallPolicyRuleCollectionGroupInner)((Object)this.createOrUpdateAsync(resourceGroupName, firewallPolicyName, ruleCollectionGroupName, parameters, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<FirewallPolicyRuleCollectionGroupInner>> listSinglePageAsync(String resourceGroupName, String firewallPolicyName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (firewallPolicyName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter firewallPolicyName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-03-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), resourceGroupName, firewallPolicyName, "2021-03-01", this.client.getSubscriptionId(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((FirewallPolicyRuleCollectionGroupListResult)res.getValue()).value(), ((FirewallPolicyRuleCollectionGroupListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<FirewallPolicyRuleCollectionGroupInner>> listSinglePageAsync(String resourceGroupName, String firewallPolicyName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (firewallPolicyName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter firewallPolicyName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-03-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), resourceGroupName, firewallPolicyName, "2021-03-01", this.client.getSubscriptionId(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((FirewallPolicyRuleCollectionGroupListResult)res.getValue()).value(), ((FirewallPolicyRuleCollectionGroupListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<FirewallPolicyRuleCollectionGroupInner> listAsync(String resourceGroupName, String firewallPolicyName) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, firewallPolicyName), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<FirewallPolicyRuleCollectionGroupInner> listAsync(String resourceGroupName, String firewallPolicyName, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, firewallPolicyName, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<FirewallPolicyRuleCollectionGroupInner> list(String resourceGroupName, String firewallPolicyName) {
        return new PagedIterable(this.listAsync(resourceGroupName, firewallPolicyName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<FirewallPolicyRuleCollectionGroupInner> list(String resourceGroupName, String firewallPolicyName, Context context) {
        return new PagedIterable(this.listAsync(resourceGroupName, firewallPolicyName, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<FirewallPolicyRuleCollectionGroupInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((FirewallPolicyRuleCollectionGroupListResult)res.getValue()).value(), ((FirewallPolicyRuleCollectionGroupListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<FirewallPolicyRuleCollectionGroupInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((FirewallPolicyRuleCollectionGroupListResult)res.getValue()).value(), ((FirewallPolicyRuleCollectionGroupListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="NetworkManagementCli")
    private static interface FirewallPolicyRuleCollectionGroupsService {
        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/firewallPolicies/{firewallPolicyName}/ruleCollectionGroups/{ruleCollectionGroupName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="firewallPolicyName") String var3, @PathParam(value="ruleCollectionGroupName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/firewallPolicies/{firewallPolicyName}/ruleCollectionGroups/{ruleCollectionGroupName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<FirewallPolicyRuleCollectionGroupInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="firewallPolicyName") String var3, @PathParam(value="ruleCollectionGroupName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/firewallPolicies/{firewallPolicyName}/ruleCollectionGroups/{ruleCollectionGroupName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="firewallPolicyName") String var3, @PathParam(value="ruleCollectionGroupName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @BodyParam(value="application/json") FirewallPolicyRuleCollectionGroupInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/firewallPolicies/{firewallPolicyName}/ruleCollectionGroups")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<FirewallPolicyRuleCollectionGroupListResult>> list(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="firewallPolicyName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<FirewallPolicyRuleCollectionGroupListResult>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

